/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AdminTopic;
import com.tongtech.jms.ra.core.JSession;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.core.WSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class WTopicSession
extends WSession
implements TopicSession {
    public WTopicSession(JSession mgr) {
        super(mgr);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership((Destination)topic);
        if (topic instanceof AdminTopic) {
            topic = (Topic)this.mMgr.createDestination((AdminTopic)topic);
        }
        if (topic instanceof Unwrappable) {
            topic = (Topic)((Unwrappable)topic).getWrappedObject();
        }
        try {
            return this.mMgr.createSubscriber(topic, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean boolean2) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership((Destination)topic);
        if (topic instanceof AdminTopic) {
            topic = (Topic)this.mMgr.createDestination((AdminTopic)topic);
        }
        if (topic instanceof Unwrappable) {
            topic = (Topic)((Unwrappable)topic).getWrappedObject();
        }
        try {
            return this.mMgr.createSubscriber(topic, string, boolean2, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkClosed();
        if (topic instanceof AdminTopic) {
            topic = (Topic)this.mMgr.createDestination((AdminTopic)topic);
        }
        if (topic instanceof Unwrappable) {
            topic = (Topic)((Unwrappable)topic).getWrappedObject();
        }
        try {
            return this.mMgr.createPublisher(topic, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }
}

