/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AckHandler;
import com.tongtech.jms.ra.core.CCDelivery;
import com.tongtech.jms.ra.core.Delivery;
import com.tongtech.jms.ra.core.EndOfBatchMessage;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Semaphore;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.Work;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class WorkContainer
implements Work,
ServerSession,
MessageListener {
    private static Logger sLog = Logger.getLogger(WorkContainer.class);
    private static Logger sContextEnter = Logger.getLogger("com.stc.EnterContext");
    private static Logger sContextExit = Logger.getLogger("com.stc.ExitContext");
    private Session mSession;
    private MessageEndpoint mEndpoint;
    private CCDelivery mDelivery;
    private Object mStateLock = new Object();
    private static final int STATE_IDLE = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DESTROYED = 2;
    private static final int STATE_DESTROYED_SUB_ALREADY_DESTROYED = 3;
    private int mState;
    private Delivery.ConnectionForMove mMessageMoveConnection;
    private Delivery.MDB mMDB;
    private LocalizedString mContextName;
    private List mMsgs;
    private Delivery.DeliveryResults mResult = new Delivery.DeliveryResults();
    private static final Localizer LOCALE = Localizer.get();

    public WorkContainer(CCDelivery delivery, MessageEndpoint endpoint, Method method, Session session, Connection conn, Delivery.MDB mdb) {
        this.mDelivery = delivery;
        this.mEndpoint = endpoint;
        this.mSession = session;
        this.mMessageMoveConnection = this.mDelivery.createConnectionForMove();
        this.mMDB = mdb;
        this.mContextName = LocalizedString.valueOf(this.mDelivery.getActivation().getActivationSpec().getContextName());
    }

    public boolean destroy() {
        int state = this.setState(2);
        if (state == 3) {
            return true;
        }
        if (state != 2) {
            return false;
        }
        this.mMessageMoveConnection.destroy();
        this.mDelivery.release(this.mEndpoint);
        this.mEndpoint = null;
        return true;
    }

    boolean hasEndpoint() {
        return this.mEndpoint != null;
    }

    void setEndpoint(MessageEndpoint mep) {
        this.mEndpoint = mep;
    }

    XAResource getXAResource() {
        return this.mMDB.getXAResource();
    }

    private int setState(int newState) {
        Object object = this.mStateLock;
        synchronized (object) {
            switch (this.mState) {
                case 2: {
                    if (newState == 1) {
                        return this.mState;
                    }
                    if (newState != 2) break;
                    return 3;
                }
                case 1: {
                    if (newState == 2) {
                        return this.mState;
                    }
                    if (newState != 0) break;
                    this.mState = 0;
                    return this.mState;
                }
                case 0: {
                    if (newState == 2) {
                        this.mState = 2;
                        return this.mState;
                    }
                    if (newState != 1) break;
                    this.mState = 1;
                    return this.mState;
                }
            }
            throw Exc.rtexc(LOCALE.x("E157: Invalid state transition from {0} to {1} on {2}", Integer.toString(this.mState), Integer.toString(newState), this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block12: {
            if (this.mContextName != null) {
                sContextEnter.info(this.mContextName);
            }
            int state = 0;
            try {
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Running WorkContainer");
                }
                if ((state = this.setState(1)) == 2) {
                    sLog.debug("Shutting down... skipped");
                    break block12;
                }
                this.mResult.reset();
                this.mDelivery.beforeDelivery(this.mResult, this.mEndpoint, true);
                this.mMsgs = new ArrayList();
                try {
                    this.mSession.run();
                }
                catch (RuntimeException e) {
                    sLog.warn(LOCALE.x("E063: Unexpected error encountered while executing a JMS CC-session: {0}", e), e);
                    this.mDelivery.txSetRollbackOnly(this.mResult, true);
                }
                this.deliver();
                this.mMsgs = null;
                this.mDelivery.afterDelivery(this.mResult, this.mMessageMoveConnection, this.mEndpoint, this.mMDB, false);
                this.mDelivery.afterDeliveryNoXA(this.mResult, this.mSession, this.mMessageMoveConnection, this.mEndpoint);
            }
            catch (Throwable e) {
                Exception ex = e instanceof Exception ? (Exception)e : new Exception(e);
                sLog.warn(LOCALE.x("E064: Unexpected exception encountered while executing a JMS CC-session: {0}. Associated exception: {1}", e, this.mResult.getException()), e);
                this.mDelivery.mActivation.distress(ex);
            }
            finally {
                this.setState(0);
                if (this.mResult.getShouldDiscardEndpoint()) {
                    this.mDelivery.release(this.mEndpoint);
                    this.mEndpoint = null;
                }
                this.mDelivery.workDone(this);
                if (this.mContextName != null) {
                    sContextExit.info(this.mContextName);
                }
            }
        }
    }

    public void release() {
    }

    public Session getSession() {
        if (sLog.isDebugEnabled()) {
            sLog.debug("getSession(): " + this.mSession);
        }
        return this.mSession;
    }

    public void start() {
        if (sLog.isDebugEnabled()) {
            sLog.debug("WorkContainer.start(): scheduling work for application server");
        }
        this.mDelivery.scheduleWork(this);
    }

    public void onMessage(Message message) {
        this.mMsgs.add(message);
    }

    private void deliver() throws Exception {
        if (sLog.isDebugEnabled()) {
            sLog.debug("WorkContainer.deliver() -- start");
        }
        SC sc = new SC();
        Transaction tx = null;
        if (this.mDelivery.mActivation.isCMT()) {
            tx = this.mDelivery.getTransaction(true);
        }
        int n = this.mMsgs.size();
        for (int i = 0; i < n; ++i) {
            Message message = (Message)this.mMsgs.get(i);
            if (this.mDelivery.mHoldUntilAck) {
                message = this.wrapMsg(message, sc, this.mResult.getNOnMessageWasCalled(), this.mResult);
            }
            this.mResult.resetDeliveryState();
            this.mDelivery.deliverToEndpoint(this.mResult, this.mMessageMoveConnection, this.mEndpoint, message, false);
            if (this.mResult.getOnMessageFailed()) break;
        }
        if (this.mDelivery.mBatchSize > 1 && this.mResult.getNOnMessageWasCalled() > 0) {
            EndOfBatchMessage m = new EndOfBatchMessage();
            if (this.mDelivery.mHoldUntilAck) {
                m = this.wrapMsg(m, sc, this.mResult.getNOnMessageWasCalled(), this.mResult);
            }
            this.mResult.resetDeliveryState();
            this.mDelivery.deliverToEndpoint(this.mResult, this.mMessageMoveConnection, this.mEndpoint, m, false);
        }
        if (this.mDelivery.mHoldUntilAck && this.mResult.getNOnMessageWasCalled() > 0) {
            sc.waitForAck(this.mResult.getNOnMessageWasCalled());
        }
        if (!this.mResult.getBeforeDeliveryFailed() && this.mDelivery.mActivation.isCMT() && this.mDelivery.mHoldUntilAck && this.mDelivery.getTransaction(true) == null && tx != null) {
            this.mDelivery.getTxMgr().resume(tx);
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("WorkContainer.deliver() -- end");
        }
    }

    private Message wrapMsg(Message msgToWrap, AckHandler ack, int iBatch, Delivery.DeliveryResults result) {
        try {
            return this.mDelivery.wrapMsg(msgToWrap).setBatchSize(this.mDelivery.mBatchSize, ack, iBatch);
        }
        catch (Exception e) {
            result.setRollbackOnly(true);
            result.setException(e);
            this.mDelivery.mActivation.distress(e);
            return msgToWrap;
        }
    }

    private class SC
    extends AckHandler {
        private int mAcksExpected;
        private int mAcksReceived;
        private boolean mIsRollbackOnly;
        private Semaphore mSemaphore = new Semaphore(0L);

        private SC() {
        }

        @Override
        public synchronized void ack(boolean isRollbackOnly, Message m) throws JMSException {
            if (isRollbackOnly) {
                this.mIsRollbackOnly = true;
            }
            ++this.mAcksReceived;
            if (this.mAcksReceived == this.mAcksExpected) {
                this.mSemaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAck(int acksExpected) {
            SC sC = this;
            synchronized (sC) {
                this.mAcksExpected = acksExpected;
                if (this.mAcksReceived == this.mAcksExpected) {
                    this.mSemaphore.release();
                }
            }
            try {
                this.mSemaphore.acquire();
            }
            catch (InterruptedException e) {
                sLog.error(LOCALE.x("E099: HUA was interrupted"));
                Thread.interrupted();
            }
            if (this.mIsRollbackOnly) {
                WorkContainer.this.mResult.setRollbackOnly(true);
            }
        }
    }
}

