/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Str;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.resource.spi.ConnectionRequestInfo;

public class XConnectionRequestInfo
implements ConnectionRequestInfo {
    private Class mConnectionClass;
    private Class mSessionClass;
    private String mUsername;
    private String mPassword;
    private String mClientID;
    private boolean mTransacted;
    private int mAcknowledgeMode;
    private String mOverrideUrl;
    private static final Localizer LOCALE = Localizer.get();
    public static final int DOMAIN_UNKNOWN = 0;
    public static final int DOMAIN_QUEUE_NONXA = 1;
    public static final int DOMAIN_TOPIC_NONXA = 2;
    public static final int DOMAIN_QUEUE_XA = 3;
    public static final int DOMAIN_TOPIC_XA = 4;
    public static final int DOMAIN_UNIFIED_XA = 5;
    public static final int DOMAIN_UNIFIED_NONXA = 6;
    public static final int DOMAIN_UNIFIED_CLUS = 7;
    public static final int NDOMAINS = 7;
    public static final String[] DOMAINSTRS = new String[]{"Unknown", "p-to-p (non XA)", "pub/sub (non XA)", "p-to-p (XA)", "pub/sub (XA)", "unified (XA)", "unified (non XA)"};

    public XConnectionRequestInfo(Class connectionClass, Class sessionClass, String username, String password, String overrideUrl, String clientID, boolean transacted, int acknowledgeMode) {
        this.mConnectionClass = connectionClass;
        this.mSessionClass = sessionClass;
        this.mUsername = username;
        this.mPassword = password;
        this.mClientID = clientID;
        this.mTransacted = transacted;
        this.mAcknowledgeMode = acknowledgeMode;
        this.mOverrideUrl = overrideUrl;
    }

    public Class getConnectionClass() {
        return this.mConnectionClass;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public Class getSessionClass() {
        return this.mSessionClass;
    }

    public String getClientID() {
        return this.mClientID;
    }

    public boolean isCompatible(XConnectionRequestInfo rhs) {
        if (this.getConnectionClass() != rhs.getConnectionClass()) {
            return false;
        }
        if (this.getTransacted() != rhs.getTransacted()) {
            return false;
        }
        if (this.getSessionClass() != rhs.getSessionClass()) {
            return false;
        }
        if (!Str.isEqual(this.getOverrideUrl(), rhs.getOverrideUrl())) {
            return false;
        }
        return Str.isEqual(this.mClientID, rhs.mClientID);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof XConnectionRequestInfo)) {
            return false;
        }
        XConnectionRequestInfo that = (XConnectionRequestInfo)other;
        return this.isCompatible(that) && this.mTransacted == that.mTransacted && this.mAcknowledgeMode == that.mAcknowledgeMode;
    }

    public int hashCode() {
        int result = 17;
        result = Str.hash(result, this.mSessionClass.getName());
        result = Str.hash(result, this.mConnectionClass.getName());
        result = Str.hash(result, this.mClientID);
        result = Str.hash(result, this.mUsername);
        result = Str.hash(result, this.mPassword);
        result = Str.hash(result, this.mOverrideUrl);
        result = Str.hash(result, this.mTransacted);
        result = 7 * result + this.mAcknowledgeMode;
        return result;
    }

    public static int guessDomain(boolean isXA, boolean isTopic) {
        if (isXA) {
            if (isTopic) {
                return 4;
            }
            return 3;
        }
        if (isTopic) {
            return 2;
        }
        return 1;
    }

    public int getDomain(boolean isXA) {
        int i = 0;
        if (this.mSessionClass == QueueSession.class) {
            i = isXA ? 3 : 1;
        } else if (this.mSessionClass == TopicSession.class) {
            i = isXA ? 4 : 2;
        } else if (this.mSessionClass == Session.class) {
            int n = i = isXA ? 5 : 6;
        }
        if (i == 0) {
            throw Exc.rtexc(LOCALE.x("E133Unknown domain {0}", this.mSessionClass));
        }
        return i;
    }

    public boolean getTransacted() {
        return this.mTransacted;
    }

    public int getAcknowledgeMode() {
        return this.mAcknowledgeMode;
    }

    public String getOverrideUrl() {
        return this.mOverrideUrl;
    }

    public void setOverrideUrl(String overrideUrl) {
        this.mOverrideUrl = overrideUrl;
    }
}

