/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.RAStopListener;
import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.FIFOSemaphore;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Semaphore;
import com.tongtech.jms.ra.util.Utility;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class XDefaultConnectionManager
implements ConnectionManager,
RAStopListener {
    private static Logger sLog = Logger.getLogger(XDefaultConnectionManager.class);
    private ConnectionEventListener mConnectionEventListener;
    private Map mAll = Collections.synchronizedMap(new IdentityHashMap());
    private int mCurrentPoolsize;
    private Semaphore mSemaphore;
    private int mWaiters;
    private Map mIdle = Collections.synchronizedMap(new IdentityHashMap());
    private Map mIdleEnlisted = Collections.synchronizedMap(new IdentityHashMap());
    private Subject mTestSubject;
    private XManagedConnectionFactory mFact;
    private int mMaxSize = 32;
    private int mMinSize = 0;
    private int mTimeout = -1;
    private boolean mIsInitialized;
    private boolean mStopped;
    private boolean mXATxFailureLogged;
    private static final Localizer LOCALE = Localizer.get();

    public XDefaultConnectionManager(XManagedConnectionFactory managedConnectionFactory) {
        this.mConnectionEventListener = new Listener();
        this.mFact = managedConnectionFactory;
        this.mFact.getRAJMSResourceAdapter().addStopListener(this);
    }

    private synchronized void init() {
        if (this.mIsInitialized) {
            return;
        }
        Properties p = this.mFact.getOptionsAsProperties();
        this.mMaxSize = Utility.getIntProperty(p, "JMSJCA.poolmaxsize", this.mMaxSize);
        this.mMinSize = Utility.getIntProperty(p, "JMSJCA.poolminsize", this.mMinSize);
        this.mTimeout = Utility.getIntProperty(p, "JMSJCA.pooltimeout", this.mTimeout);
        if (this.mTimeout == 0) {
            this.mTimeout = Integer.MAX_VALUE;
        }
        if (this.mTimeout < 0) {
            this.mTimeout = 0;
        }
        this.mSemaphore = new FIFOSemaphore(this.mMaxSize);
        this.mIsInitialized = true;
    }

    private TransactionManager getTransactionManager() throws Exception {
        if (this.mFact.getTxMgr() != null) {
            return this.mFact.getTxMgr().getTransactionManager();
        }
        return null;
    }

    private Transaction getXATx() throws Exception {
        TransactionManager txmgr;
        if (!this.mFact.getOptionNoXA() && (txmgr = this.getTransactionManager()) != null) {
            return txmgr.getTransaction();
        }
        return null;
    }

    private Transaction getXATxNoExc() {
        try {
            return this.getXATx();
        }
        catch (Exception e) {
            if (!this.mXATxFailureLogged) {
                sLog.warn(LOCALE.x("E067: Could not get hold of transaction or transaction manager: {0}", e), e);
                this.mXATxFailureLogged = true;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ManagedConnection[] mcsToDestroy;
        XDefaultConnectionManager xDefaultConnectionManager = this;
        synchronized (xDefaultConnectionManager) {
            mcsToDestroy = this.mIdle.keySet().toArray(new ManagedConnection[this.mIdle.size()]);
            this.mIdle.clear();
            this.mStopped = true;
            if (this.mSemaphore != null) {
                this.mSemaphore.release(this.mWaiters);
            }
        }
        for (int i = 0; i < mcsToDestroy.length; ++i) {
            this.destroyAndAdjust(mcsToDestroy[i]);
        }
    }

    private synchronized ManagedConnection findIdleConnectionInTxAndAdjust(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo, Transaction tx) throws ResourceException {
        ManagedConnection mc = null;
        Set candidates = (Set)this.mIdleEnlisted.get(tx);
        if (candidates != null && (mc = managedConnectionFactory.matchManagedConnections(candidates, this.mTestSubject, connectionRequestInfo)) != null) {
            candidates.remove(mc);
            if (candidates.isEmpty()) {
                this.mIdleEnlisted.remove(tx);
            }
        }
        return mc;
    }

    private ManagedConnection findIdleConnectionAndAdjust(ManagedConnectionFactory mcf, ConnectionRequestInfo descr) throws ResourceException {
        ManagedConnection mc = null;
        Set candidates = this.mIdle.keySet();
        mc = mcf.matchManagedConnections(candidates, this.mTestSubject, descr);
        if (mc != null) {
            this.mIdle.remove(mc);
        }
        return mc;
    }

    private boolean isInvalid(ManagedConnectionFactory mcf, ManagedConnection mc) {
        boolean ret = false;
        if (mcf == this.mFact || mcf instanceof ValidatingManagedConnectionFactory) {
            ValidatingManagedConnectionFactory vmcf = (ValidatingManagedConnectionFactory)mcf;
            HashSet<ManagedConnection> validtest = new HashSet<ManagedConnection>();
            validtest.add(mc);
            try {
                Set invalid = vmcf.getInvalidConnections(validtest);
                ret = invalid.size() > 0;
            }
            catch (ResourceException e) {
                sLog.warn(LOCALE.x("E068: Unexpected error while checking a connection for validity: {0}", (Object)e), e);
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo descr) throws ResourceException {
        this.init();
        Object ret = this.tryObtainConnectionFromTx(mcf, descr);
        if (ret == null) {
            boolean acquired;
            try {
                XDefaultConnectionManager xDefaultConnectionManager = this;
                synchronized (xDefaultConnectionManager) {
                    ++this.mWaiters;
                    if (this.mStopped) {
                        throw Exc.rsrcExc(LOCALE.x("E159: Resource adapter was stopped"));
                    }
                }
                acquired = this.mSemaphore.attempt(this.mTimeout);
            }
            catch (InterruptedException e) {
                throw Exc.rsrcExc(LOCALE.x("Interrupted"));
            }
            finally {
                XDefaultConnectionManager xDefaultConnectionManager = this;
                synchronized (xDefaultConnectionManager) {
                    --this.mWaiters;
                }
            }
            if (!acquired) {
                throw Exc.rsrcExc(LOCALE.x("E158: Connection could not be acquired in the configured time of {0} ms; {1} connections are in use", Integer.toString(this.mTimeout), Integer.toString(this.mMaxSize)));
            }
            try {
                ret = this.obtainConnection(mcf, descr);
            }
            catch (ResourceException e) {
                this.mSemaphore.release();
                throw e;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object obtainConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo descr) throws ResourceException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Allocating connection using " + mcf + "; request=" + descr);
        }
        try {
            ManagedConnection mc = null;
            boolean connectionNeedsToBeCreated = false;
            boolean connectionNeedsToBeValidated = false;
            ManagedConnection toDestroy = null;
            Object ret = null;
            XDefaultConnectionManager xDefaultConnectionManager = this;
            synchronized (xDefaultConnectionManager) {
                if (this.mStopped) {
                    throw Exc.rsrcExc(LOCALE.x("E161: RA is stopped"));
                }
                boolean done = false;
                mc = this.findIdleConnectionAndAdjust(mcf, descr);
                if (mc != null) {
                    connectionNeedsToBeValidated = true;
                    done = true;
                }
                if (!done && this.mCurrentPoolsize < this.mMaxSize) {
                    connectionNeedsToBeCreated = true;
                    ++this.mCurrentPoolsize;
                    done = true;
                }
                if (!done && !this.mIdle.isEmpty()) {
                    toDestroy = (ManagedConnection)this.mIdle.keySet().iterator().next();
                    this.mIdle.remove(toDestroy);
                    this.mAll.remove(toDestroy);
                    connectionNeedsToBeCreated = true;
                    done = true;
                }
                if (!done) {
                    throw Exc.exc(LOCALE.x("E162: Logic exception (current pool size={0}; semaphore={1})", Integer.toString(this.mCurrentPoolsize), Long.toString(this.mSemaphore.peek())));
                }
            }
            if (connectionNeedsToBeValidated && this.isInvalid(mcf, mc)) {
                toDestroy = mc;
                this.mAll.remove(mc);
                connectionNeedsToBeCreated = true;
            }
            if (toDestroy != null) {
                try {
                    toDestroy.destroy();
                }
                catch (Exception ex) {
                    sLog.error(LOCALE.x("E069: Unexpected exception when destroying a connection (connection={0}): {1}", toDestroy, ex), ex);
                }
            }
            if (connectionNeedsToBeCreated) {
                try {
                    mc = mcf.createManagedConnection(this.mTestSubject, descr);
                    XDefaultConnectionManager ex = this;
                    synchronized (ex) {
                        this.mAll.put(mc, new ConnectionState());
                    }
                }
                catch (Exception e) {
                    XDefaultConnectionManager done = this;
                    synchronized (done) {
                        --this.mCurrentPoolsize;
                    }
                    throw e;
                }
            }
            if (mc != null) {
                try {
                    mc.addConnectionEventListener(this.mConnectionEventListener);
                    Transaction tx = this.getXATxNoExc();
                    if (tx != null) {
                        tx.enlistResource(mc.getXAResource());
                        tx.registerSynchronization((Synchronization)new TxDelister(mc, tx));
                    }
                    ret = mc.getConnection(this.mTestSubject, descr);
                }
                catch (Exception e) {
                    XDefaultConnectionManager done = this;
                    synchronized (done) {
                        this.mAll.remove(mc);
                        --this.mCurrentPoolsize;
                    }
                    try {
                        mc.destroy();
                    }
                    catch (Exception e2) {
                        sLog.warn(LOCALE.x("E070: Connection could not be setup or enlisted: [{0}]... and could not be destroyed properly either: [{1}] stacktrace of destruction problem follows in next log entry.", e, e2), e);
                        sLog.warn(LOCALE.x("E071: Destruction exception: {0}", e2), e2);
                    }
                    throw e;
                }
            }
            return ret;
        }
        catch (Exception ex) {
            throw Exc.rsrcExc(LOCALE.x("E073: Could not allocate connection: {0}", ex), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object tryObtainConnectionFromTx(ManagedConnectionFactory mcf, ConnectionRequestInfo descr) throws ResourceException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Allocating connection using " + mcf + "; request=" + descr);
        }
        try {
            ManagedConnection mc = null;
            Transaction tx = this.getXATxNoExc();
            Object ret = null;
            XDefaultConnectionManager xDefaultConnectionManager = this;
            synchronized (xDefaultConnectionManager) {
                if (tx != null) {
                    mc = this.findIdleConnectionInTxAndAdjust(mcf, descr, tx);
                }
            }
            if (mc != null) {
                mc.addConnectionEventListener(this.mConnectionEventListener);
                ret = mc.getConnection(this.mTestSubject, descr);
            }
            return ret;
        }
        catch (Exception ex) {
            throw Exc.rsrcExc(LOCALE.x("E073: Could not allocate connection: {0}", ex), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAndAdjust(ManagedConnection mc) {
        try {
            mc.destroy();
        }
        catch (Exception ex) {
            sLog.error(LOCALE.x("E074: Unexpected exception destroying a connection: {0}", ex), ex);
        }
        XDefaultConnectionManager xDefaultConnectionManager = this;
        synchronized (xDefaultConnectionManager) {
            this.mAll.remove(mc);
        }
        this.mSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionClosed(ManagedConnection mc) {
        Transaction tx = this.getXATxNoExc();
        if (tx == null) {
            ManagedConnection toDestroy = null;
            try {
                mc.cleanup();
                XDefaultConnectionManager xDefaultConnectionManager = this;
                synchronized (xDefaultConnectionManager) {
                    if (this.mStopped) {
                        toDestroy = mc;
                    } else {
                        this.mIdle.put(mc, null);
                        this.mSemaphore.release();
                    }
                }
            }
            catch (Exception e) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Caught exception in cleanup(); connection will be destroyed: " + e, e);
                }
                toDestroy = mc;
            }
            if (toDestroy != null) {
                this.destroyAndAdjust(mc);
            } else if (sLog.isDebugEnabled()) {
                sLog.debug("Connection closed event received; added connection " + mc + " to idle-pool");
            }
        } else {
            boolean isAlreadyRegistered;
            Exception cleanupException;
            block25: {
                cleanupException = null;
                try {
                    mc.cleanup();
                }
                catch (Exception e) {
                    cleanupException = e;
                    if (!sLog.isDebugEnabled()) break block25;
                    sLog.debug("Unexpected error in cleanup: " + e, e);
                }
            }
            XDefaultConnectionManager xDefaultConnectionManager = this;
            synchronized (xDefaultConnectionManager) {
                HashSet<ManagedConnection> idleInTx;
                ConnectionState state = (ConnectionState)this.mAll.get(mc);
                if (!state.isBad()) {
                    state.setBad(cleanupException);
                }
                if ((idleInTx = (HashSet<ManagedConnection>)this.mIdleEnlisted.get(tx)) == null) {
                    idleInTx = new HashSet<ManagedConnection>();
                    this.mIdleEnlisted.put(tx, idleInTx);
                }
                idleInTx.add(mc);
                isAlreadyRegistered = state.isTxDeferredReleaseRegistered();
                if (!isAlreadyRegistered) {
                    state.setTxDeferredReleaseRegistered(true);
                }
            }
            if (!isAlreadyRegistered) {
                try {
                    tx.registerSynchronization((Synchronization)new TxDeferredRelease(mc, tx));
                }
                catch (Exception e) {
                    sLog.error(LOCALE.x("E076: Synchronization registration failed: {0}", e), e);
                }
            }
        }
    }

    public RAJMSResourceAdapter getRAJMSResourceAdapter() {
        return this.mFact.getRAJMSResourceAdapter();
    }

    public XManagedConnectionFactory getMCF() {
        return this.mFact;
    }

    public void testAddToPool(ManagedConnection mc) {
        this.mIdle.put(mc, null);
    }

    public void testIdleConsistency() {
        if (this.mSemaphore.peek() != (long)(this.mIdle.size() + (this.mMaxSize - this.mAll.size()))) {
            throw Exc.rtexc(LOCALE.x("E163: Inconsistent: semaphore={0}, idle={1}, max={2}, all={3}", Long.toString(this.mSemaphore.peek()), Integer.toString(this.mIdle.size()), Integer.toString(this.mMaxSize), Integer.toString(this.mAll.size())));
        }
    }

    public void testConsistency() {
        if (this.mStopped) {
            return;
        }
        this.init();
        if (this.mSemaphore.peek() > (long)this.mMaxSize || this.mAll.size() > this.mMaxSize) {
            throw Exc.rtexc(LOCALE.x("E163: Inconsistent: semaphore={0}, idle={1}, max={2}, all={3}", Long.toString(this.mSemaphore.peek()), Integer.toString(this.mIdle.size()), Integer.toString(this.mMaxSize), Integer.toString(this.mAll.size())));
        }
    }

    public void clear() throws ResourceException {
        this.testConsistency();
        for (ManagedConnection mc : this.mIdle.keySet()) {
            mc.destroy();
        }
        this.mIdle.clear();
    }

    public void clearAll() throws ResourceException {
        this.testConsistency();
        for (ManagedConnection mc : this.mAll.keySet()) {
            mc.destroy();
        }
        this.mAll.clear();
        this.mIdle.clear();
        this.mCurrentPoolsize = 0;
    }

    public void setSubject(Subject s) {
        this.mTestSubject = s;
    }

    public void cleanInvalid() throws ResourceException {
        for (XManagedConnection mc : this.mIdle.keySet()) {
            if (!mc.isInvalid()) continue;
            mc.destroy();
        }
    }

    private class ConnectionState {
        private Exception mBad;
        private boolean mTxDeferredReleaseRegistered;

        private ConnectionState() {
        }

        public void setBad(Exception e) {
            this.mBad = e;
        }

        public void setTxDeferredReleaseRegistered(boolean isRegistered) {
            this.mTxDeferredReleaseRegistered = isRegistered;
        }

        public boolean isTxDeferredReleaseRegistered() {
            return this.mTxDeferredReleaseRegistered;
        }

        public boolean isBad() {
            return this.mBad != null;
        }
    }

    private class Listener
    implements ConnectionEventListener,
    Serializable {
        private Listener() {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            ManagedConnection mc = (ManagedConnection)connectionEvent.getSource();
            mc.removeConnectionEventListener((ConnectionEventListener)this);
            XDefaultConnectionManager.this.connectionClosed(mc);
        }

        public void localTransactionStarted(ConnectionEvent connectionEvent) {
        }

        public void localTransactionCommitted(ConnectionEvent connectionEvent) {
        }

        public void localTransactionRolledback(ConnectionEvent connectionEvent) {
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        }
    }

    private class TxDeferredRelease
    implements Synchronization {
        private ManagedConnection mMC;
        private Transaction mTx;

        public TxDeferredRelease(ManagedConnection mc, Transaction tx) {
            this.mMC = mc;
            this.mTx = tx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            ManagedConnection toBeDestroyed = null;
            XDefaultConnectionManager xDefaultConnectionManager = XDefaultConnectionManager.this;
            synchronized (xDefaultConnectionManager) {
                ConnectionState state = (ConnectionState)XDefaultConnectionManager.this.mAll.get(this.mMC);
                state.setTxDeferredReleaseRegistered(false);
                if (state.isBad() || XDefaultConnectionManager.this.mStopped) {
                    toBeDestroyed = this.mMC;
                } else {
                    XDefaultConnectionManager.this.mIdle.put(this.mMC, null);
                    XDefaultConnectionManager.this.mSemaphore.release();
                }
                Set candidates = (Set)XDefaultConnectionManager.this.mIdleEnlisted.get(this.mTx);
                if (candidates != null) {
                    candidates.remove(this.mMC);
                    if (candidates.isEmpty()) {
                        XDefaultConnectionManager.this.mIdleEnlisted.remove(this.mTx);
                    }
                }
            }
            if (toBeDestroyed != null) {
                XDefaultConnectionManager.this.destroyAndAdjust(this.mMC);
            }
        }

        public void beforeCompletion() {
        }
    }

    private class TxDelister
    implements Synchronization {
        private ManagedConnection mMC;
        private Transaction mTX;

        public TxDelister(ManagedConnection mc, Transaction tx) {
            this.mMC = mc;
            this.mTX = tx;
        }

        public void afterCompletion(int status) {
        }

        public void beforeCompletion() {
            try {
                this.mTX.delistResource(this.mMC.getXAResource(), 0x4000000);
            }
            catch (Exception e) {
                sLog.warn(LOCALE.x("E075: XAResource could not be delisted ({0}): {1}", this.mMC, e), e);
            }
        }
    }
}

