/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.Cred;
import com.tongtech.jms.ra.core.DestinationCache;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.TxMgr;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import com.tongtech.jms.ra.util.Utility;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public abstract class XManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
ValidatingManagedConnectionFactory {
    private static Logger sLog = Logger.getLogger(XManagedConnectionFactory.class);
    private transient PrintWriter mLogWriter;
    private RAJMSResourceAdapter mRA;
    private Map mConnectionFactories;
    private Object[] mDefaultConnectionFactories;
    private boolean mProducerPoolingOn;
    private String mConnectionURL;
    private String mUserName;
    private String mPassword;
    private String mOptionsStr;
    private Properties mOptions;
    private String mClientId;
    private long mIdleTimeout = 30000L;
    private transient RAJMSObjectFactory mObjFactory;
    private transient DestinationCache mQueueCache;
    private transient DestinationCache mTopicCache;
    private transient TxMgr mTxMgr;
    private transient boolean mOptionsAreSet;
    private transient String mRAUrl;
    private transient String mRAOptionsStr;
    private transient boolean mNoXA;
    private transient boolean mIgnoreTx;
    private transient boolean mClientContainer;
    private transient boolean mBypassRA;
    private transient boolean mDoNotCacheConnectionFactories;
    private transient boolean mStrict;
    private transient String mTxMgrLocatorClass;
    private transient int mCtMCCreated;
    private transient int mCtMCDestroyed;
    private transient Map mMCCreated;
    private transient boolean mIsTestModeInvalidConnections;
    private transient TestAllocator mAllocator;
    private transient IdentityHashMap mCredentialCache;
    private static final int MAXCREDENTIALCACHE = 50;
    private static final Localizer LOCALE = Localizer.get();

    public void setResourceAdapter(ResourceAdapter ra) {
        this.mRA = (RAJMSResourceAdapter)ra;
        this.mRA.notifyMCFCreated(this);
    }

    public ResourceAdapter getResourceAdapter() {
        return this.mRA;
    }

    private Map getActiveManagedConnections() {
        if (this.mMCCreated == null) {
            this.mMCCreated = Collections.synchronizedMap(new WeakHashMap());
        }
        return this.mMCCreated;
    }

    public RAJMSResourceAdapter getRAJMSResourceAdapter() {
        return this.mRA;
    }

    public RAJMSObjectFactory getObjFactory() {
        return this.mObjFactory;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public synchronized Object getConnectionFactory(int domain, String overrideUrl) throws JMSException {
        Object[] factories;
        if (domain >= 7) {
            throw Exc.jmsExc(LOCALE.x("E133: Unknown domain {0}", Integer.toString(domain)));
        }
        if (this.getOptionDoNotCacheConnectionFactories()) {
            ConnectionFactory o = this.getObjFactory().createConnectionFactory(domain, this.mRA, null, this, overrideUrl);
            return o;
        }
        if (overrideUrl == null) {
            if (this.mDefaultConnectionFactories == null) {
                this.mDefaultConnectionFactories = new Object[7];
            }
            factories = this.mDefaultConnectionFactories;
        } else {
            if (this.mConnectionFactories == null) {
                this.mConnectionFactories = new HashMap();
            }
            if ((factories = (Object[])this.mConnectionFactories.get(overrideUrl)) == null) {
                factories = new Object[7];
                this.mConnectionFactories.put(overrideUrl, factories);
            }
        }
        if (factories[domain] == null) {
            RAJMSResourceAdapter ra = this.mRA;
            ConnectionFactory o = this.getObjFactory().createConnectionFactory(domain, ra, null, this, overrideUrl);
            factories[domain] = o;
        }
        return factories[domain];
    }

    public Object getConnectionFactory(boolean isXA, XConnectionRequestInfo descr) throws JMSException {
        return this.getConnectionFactory(descr.getDomain(isXA), descr.getOverrideUrl());
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Creating managed connection for subject " + subject + " and request info " + cxRequestInfo);
        }
        XConnectionRequestInfo descr = (XConnectionRequestInfo)cxRequestInfo;
        XManagedConnection ret = this.mAllocator == null ? new XManagedConnection(this, subject, descr) : this.mAllocator.createConnection(this, subject, descr);
        this.getActiveManagedConnections().put(ret, new Date());
        ++this.mCtMCCreated;
        return ret;
    }

    String[] getEffectiveUseridAndPassword(XConnectionRequestInfo descr, Subject subject) throws ResourceException {
        PasswordCredential pc = this.getPasswordCredential(subject);
        String userid = null;
        String password = null;
        if (pc != null) {
            userid = pc.getUserName();
            password = new String(pc.getPassword());
        } else if (descr != null && !Str.empty(descr.getUsername())) {
            userid = descr.getUsername();
            password = descr.getPassword();
        } else if (!Str.empty(this.getUserName())) {
            userid = this.getUserName();
            password = this.getClearTextPassword();
        } else if (!Str.empty(this.getRAJMSResourceAdapter().getUserName())) {
            userid = this.getRAJMSResourceAdapter().getUserName();
            password = this.getRAJMSResourceAdapter().getClearTextPassword();
        }
        return new String[]{userid, password};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordCredential getPasswordCredential(Subject subject) throws ResourceException {
        if (subject == null) {
            return null;
        }
        XManagedConnectionFactory xManagedConnectionFactory = this;
        synchronized (xManagedConnectionFactory) {
            if (this.mCredentialCache == null) {
                this.mCredentialCache = new IdentityHashMap();
            }
            if (this.mCredentialCache.containsKey(subject)) {
                return (PasswordCredential)this.mCredentialCache.get(subject);
            }
        }
        PasswordCredential ret = Cred.extractPasswordCredential(this, subject);
        XManagedConnectionFactory xManagedConnectionFactory2 = this;
        synchronized (xManagedConnectionFactory2) {
            if (this.mCredentialCache.size() > 50) {
                this.mCredentialCache.clear();
            }
            this.mCredentialCache.put(subject, ret);
        }
        return ret;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        XConnectionRequestInfo descr = (XConnectionRequestInfo)cxRequestInfo;
        this.extractOptions();
        for (Object obj : connectionSet) {
            XManagedConnection mc;
            XManagedConnectionFactory mcf;
            if (!(obj instanceof XManagedConnection) || !(mcf = (mc = (XManagedConnection)obj).getManagedConnectionFactory()).equals(this) || !mc.getDescription().isCompatible(descr)) continue;
            String[] uidpw = this.getEffectiveUseridAndPassword(descr, subject);
            String userid = uidpw[0];
            String password = uidpw[1];
            if (!Str.isEqual(userid, mc.getUserid()) || !Str.isEqual(password, mc.getPassword())) continue;
            if (sLog.isDebugEnabled()) {
                sLog.debug("matchManagedConnections: was offered " + connectionSet.size() + " connections for " + cxRequestInfo + "; found a match in " + mc);
            }
            return mc;
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("matchManagedConnections: was offered " + connectionSet.size() + " connections for " + cxRequestInfo + "; found no match");
        }
        return null;
    }

    public Set getInvalidConnections(Set toCheck) throws ResourceException {
        HashSet<XManagedConnection> ret = new HashSet<XManagedConnection>();
        for (ManagedConnection cmc : toCheck) {
            XManagedConnection mc;
            if (!(cmc instanceof XManagedConnection) || !(mc = (XManagedConnection)cmc).isInvalid()) continue;
            ret.add(mc);
        }
        return ret;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.mLogWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.mLogWriter;
    }

    private synchronized void extractOptions() {
        if (this.mOptionsAreSet && this.mRAUrl == this.mRA.getConnectionURL() && this.mRAOptionsStr == this.mRA.getOptions()) {
            return;
        }
        String urlstr = this.mConnectionURL == null ? this.mRA.getConnectionURL() : this.mConnectionURL;
        this.mObjFactory = this.mRA.createObjectFactory(urlstr);
        Properties p = new Properties();
        this.mRAUrl = this.mRA.lookUpLDAP(this.mRA.getConnectionURL());
        this.mRAOptionsStr = this.mRA.getOptions();
        Str.deserializeProperties(Str.parseProperties("JMSJCA.sep=", this.mRAOptionsStr), p);
        if (!Str.empty(this.mRAUrl)) {
            this.getObjFactory().createConnectionUrl(this.mRAUrl).getQueryProperties(p);
        }
        Str.deserializeProperties(Str.parseProperties("JMSJCA.sep=", this.mOptionsStr), p);
        this.mOptions = p;
        if (this.mConnectionURL != null) {
            this.getObjFactory().createConnectionUrl(this.mConnectionURL).getQueryProperties(p);
        }
        this.mClientContainer = Utility.isTrue(p.getProperty("JMSJCA.ACC"), false);
        this.mClientContainer = Utility.getSystemProperty("JMSJCA.ACC", this.mClientContainer);
        this.mIgnoreTx = Utility.isTrue(p.getProperty("JMSJCA.IgnoreTx"), !this.mClientContainer);
        this.mIgnoreTx = Utility.getSystemProperty("JMSJCA.IgnoreTx", this.mIgnoreTx);
        this.mNoXA = Utility.isTrue(p.getProperty("JMSJCA.NoXA"), this.mClientContainer);
        this.mNoXA = Utility.getSystemProperty("JMSJCA.NoXA", this.mNoXA);
        sLog.infoNoloc("TLQ ResourceAdapter, mNoXA=" + this.mNoXA);
        this.mBypassRA = Utility.isTrue(p.getProperty("JMSJCA.BypassRA"), false);
        this.mBypassRA = Utility.getSystemProperty("JMSJCA.BypassRA", this.mBypassRA);
        this.mDoNotCacheConnectionFactories = Utility.isTrue(p.getProperty("JMSJCA.nocfcache"), !this.getObjFactory().shouldCacheConnectionFactories());
        this.mStrict = Utility.isTrue(p.getProperty("JMSJCA.Strict"), false);
        this.mStrict = Utility.getSystemProperty("JMSJCA.Strict", this.mStrict);
        this.mTxMgrLocatorClass = p.getProperty("JMSJCA.LocatorClass", TxMgr.class.getName());
        this.mTxMgrLocatorClass = Utility.getSystemProperty("JMSJCA.LocatorClass", this.mTxMgrLocatorClass);
        this.mProducerPoolingOn = Utility.isTrue(p.getProperty("JMSJCA.producerpooling", null), this.mProducerPoolingOn || this.getObjFactory().shouldUseProducerPooling());
        this.mIdleTimeout = Long.parseLong(p.getProperty("JMSJCA.idletimeout", Long.toString(this.mIdleTimeout)));
        this.mOptionsAreSet = true;
    }

    public int hashCode() {
        int h = 7;
        h = Str.hash(h, this.mUserName);
        h = Str.hash(h, this.mPassword);
        h = Str.hash(h, this.mConnectionURL);
        h = Str.hash(h, this.mProducerPoolingOn);
        h = Str.hash(h, this.mRA);
        h = Str.hash(h, this.mOptionsStr);
        return h;
    }

    public String[] getUserIdAndPasswordAndUrl(String suggestedUsername, String suggestedPassword) {
        String userid = null;
        String password = null;
        String url = null;
        if (suggestedUsername != null) {
            if (!this.getObjFactory().isUrl(suggestedUsername)) {
                userid = suggestedUsername;
                password = suggestedPassword;
            } else {
                ConnectionUrl p = this.getObjFactory().createConnectionUrl(suggestedUsername);
                Properties props = p.getQueryProperties();
                userid = props.getProperty("username");
                password = props.getProperty("password");
                if (password == null) {
                    password = suggestedPassword;
                }
                url = p.toString();
            }
        }
        return new String[]{userid, password, url};
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof XManagedConnectionFactory)) {
            return false;
        }
        if (!rhs.getClass().equals(this.getClass())) {
            return false;
        }
        XManagedConnectionFactory x = (XManagedConnectionFactory)rhs;
        return Str.isEqual(this.mUserName, x.mUserName) && Str.isEqual(this.mPassword, x.mPassword) && Str.isEqual(this.mConnectionURL, x.mConnectionURL) && this.isProducerPoolingOn() == x.isProducerPoolingOn() && this.mRA.equals(x.mRA) && Str.isEqual(this.mOptionsStr, x.mOptionsStr);
    }

    public void setProducerPooling(String setOn) {
        this.mProducerPoolingOn = "true".equalsIgnoreCase(setOn);
        if (sLog.isDebugEnabled()) {
            sLog.debug("Setting mProducerPoolingOn to " + this.mProducerPoolingOn);
        }
    }

    public String getProducerPooling() {
        return Boolean.toString(this.mProducerPoolingOn);
    }

    public boolean isProducerPoolingOn() {
        return this.mProducerPoolingOn;
    }

    public void setConnectionURL(String url) {
        this.mConnectionURL = url != null && url.trim().length() > 0 ? url : null;
    }

    public String getConnectionURL() {
        return this.mConnectionURL;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setUserName(String username) {
        this.mUserName = username;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public String getClearTextPassword() {
        return Str.pwdecode(this.mPassword);
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getOptions() {
        return this.mOptionsStr;
    }

    public void setOptions(String options) {
        this.mOptionsStr = options;
        this.mOptionsAreSet = false;
    }

    public Properties getOptionsAsProperties() {
        this.extractOptions();
        return this.mOptions;
    }

    public boolean getOptionNoXA() {
        this.extractOptions();
        return this.mNoXA;
    }

    public boolean getOptionClientContainer() {
        this.extractOptions();
        return this.mClientContainer;
    }

    public boolean getOptionIgnoreNonTx() {
        this.extractOptions();
        return this.mIgnoreTx;
    }

    public boolean getOptionBypassRA() {
        this.extractOptions();
        return this.mBypassRA;
    }

    public boolean getOptionDoNotCacheConnectionFactories() {
        this.extractOptions();
        return this.mDoNotCacheConnectionFactories;
    }

    public boolean getOptionStrict() {
        this.extractOptions();
        return this.mStrict;
    }

    public synchronized DestinationCache getQueueCache() {
        if (this.mQueueCache == null) {
            this.mQueueCache = new DestinationCache();
        }
        return this.mQueueCache;
    }

    public synchronized DestinationCache getTopicCache() {
        if (this.mTopicCache == null) {
            this.mTopicCache = new DestinationCache();
        }
        return this.mTopicCache;
    }

    public void notifyMCDestroyed(XManagedConnection c) {
        ++this.mCtMCDestroyed;
        this.getActiveManagedConnections().remove(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpMCFInfo() {
        Object[] factories;
        StringBuffer ret = new StringBuffer();
        ret.append("Class: " + this.getClass() + ";\n");
        ret.append("Managed connections created: " + this.mCtMCCreated + ";\n");
        ret.append("Managed connections destroyed: " + this.mCtMCDestroyed + ";\n");
        ret.append("Current managed connections:\n");
        Map map = this.getActiveManagedConnections();
        synchronized (map) {
            factories = this.getActiveManagedConnections().keySet().toArray();
        }
        for (int i = 0; i < factories.length; ++i) {
            if (factories[i] == null) continue;
            XManagedConnection mc = (XManagedConnection)factories[i];
            ret.append("[" + mc.dumpMCInfo() + "]\n");
        }
        return ret.toString();
    }

    public boolean isTestModeInvalidConnections() {
        return this.mIsTestModeInvalidConnections;
    }

    public void testSetModeInvalidConnections(boolean setInvalid) {
        this.mIsTestModeInvalidConnections = setInvalid;
    }

    public void testSetAllocator(TestAllocator allocator) {
        this.mAllocator = allocator;
    }

    public synchronized TxMgr getTxMgr() {
        if (this.mTxMgr == null) {
            try {
                Class<?> c = Class.forName(this.mTxMgrLocatorClass, false, this.getClass().getClassLoader());
                TxMgr txmgr = (TxMgr)c.newInstance();
                this.extractOptions();
                txmgr.init(this.mOptions);
                this.mTxMgr = txmgr;
            }
            catch (Exception e) {
                sLog.warn(LOCALE.x("E088: Transaction manager locator cannot be initialized: {0}", e), e);
            }
        }
        return this.mTxMgr;
    }

    public long internalGetIdleTimeout() {
        return this.mIdleTimeout;
    }

    public void internalSetIdleTimeout(long idleTimeout) {
        if (idleTimeout < 1000L) {
            throw Exc.rtexc(LOCALE.x("E168: Invalid timeout [{0}] ms: should be > 1000 ms", Long.toString(idleTimeout)));
        }
        this.mIdleTimeout = idleTimeout;
    }

    public String getIdleTimeout() {
        return Long.toString(this.internalGetIdleTimeout());
    }

    public void setIdleTimeout(String idleTimeout) {
        this.internalSetIdleTimeout(Integer.parseInt(idleTimeout));
    }

    public static interface TestAllocator {
        public XManagedConnection createConnection(XManagedConnectionFactory var1, Subject var2, XConnectionRequestInfo var3) throws ResourceException;
    }
}

