/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.jndi;

import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.AdminQueue;
import com.tongtech.jms.ra.core.AdminTopic;
import com.tongtech.jms.ra.core.DestinationCache;
import com.tongtech.jms.ra.core.DestinationCacheEntry;
import com.tongtech.jms.ra.core.GenericSessionConnection;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.jndi.RAJNDIObjectFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class JNDISessionConnection
extends GenericSessionConnection {
    public JNDISessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection managedConnection, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        super(connectionFactory, objfact, ra, managedConnection, descr, isXa, isTransacted, acknowledgmentMode, sessionClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination createDestination(AdminDestination dest) throws JMSException {
        RAJNDIObjectFactory o = (RAJNDIObjectFactory)this.getObjFact();
        Object ret = null;
        String name = dest.retrieveCheckedName();
        if (!name.startsWith("jndi://")) {
            ret = dest instanceof AdminQueue ? super.createQueue(name) : super.createTopic(name);
        } else {
            DestinationCacheEntry d;
            name = name.substring("jndi://".length());
            DestinationCache cache = dest instanceof AdminQueue ? this.mMC.getManagedConnectionFactory().getQueueCache() : this.mMC.getManagedConnectionFactory().getTopicCache();
            DestinationCacheEntry destinationCacheEntry = d = cache.get(name);
            synchronized (destinationCacheEntry) {
                if (d.get() == null) {
                    Destination realdest = (Destination)o.getJndiObject(this.getRA(), null, this.mMC.getManagedConnectionFactory(), null, name);
                    d.set(realdest);
                }
                ret = d.get();
            }
        }
        return ret;
    }

    @Override
    public Queue createQueue(String name) throws JMSException {
        AdminQueue admindest = new AdminQueue();
        admindest.setName(name);
        return (Queue)this.createDestination(admindest);
    }

    @Override
    public Topic createTopic(String name) throws JMSException {
        AdminTopic admindest = new AdminTopic();
        admindest.setName(name);
        return (Topic)this.createDestination(admindest);
    }
}

