/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.localization;

import com.tongtech.jms.ra.localization.LocalizedString;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LocalizationSupport {
    private PropertyResourceBundle mBundle;
    private Pattern mIdPattern;
    private String mPrefix;
    private String mBundleName;
    public static final String DEFAULTBUNDLENAME = "msgs";
    public static Pattern DEFAULTPATTERN = Pattern.compile("([A-Z]\\d\\d\\d)(: )(.*)", 32);

    protected LocalizationSupport(Pattern idpattern, String prefix, String bundlename) {
        this.mIdPattern = idpattern == null ? DEFAULTPATTERN : idpattern;
        this.mPrefix = prefix;
        this.mBundleName = bundlename == null ? DEFAULTBUNDLENAME : bundlename;
        String packagename = this.getClass().getName();
        int lastdot = packagename.lastIndexOf(".");
        packagename = packagename.substring(0, lastdot);
        try {
            this.mBundle = (PropertyResourceBundle)ResourceBundle.getBundle(packagename + "." + this.mBundleName, Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Resource bundle could not be loaded: " + e, e);
        }
        String clname = this.getClass().getName();
        if (!clname.endsWith(".Localizer") && !clname.endsWith("$Localizer")) {
            throw new RuntimeException("Localizer class [" + clname + "] should be [Localizer]");
        }
    }

    protected LocalizationSupport(String prefix) {
        this(null, prefix, null);
    }

    private String salvage(Object[] args) {
        StringBuffer ret = new StringBuffer();
        ret.append(" [FORMAT ERROR.");
        if (args != null && args.length > 0) {
            ret.append(" Arguments: ");
        }
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append("{").append(i).append("}=\"").append(args[i]).append("\"");
        }
        ret.append("]");
        return ret.toString();
    }

    private String format(String msg, Object[] args) {
        try {
            return MessageFormat.format(msg, args);
        }
        catch (Exception e) {
            return msg + this.salvage(args);
        }
    }

    public LocalizedString x(String msg, Object[] args) {
        return new LocalizedString(this.t(msg, args));
    }

    public String t(String msg, Object[] args) {
        try {
            String localizedmsg;
            Matcher matcher = this.mIdPattern.matcher(msg);
            if (!matcher.matches() || matcher.groupCount() <= 1) {
                return this.mPrefix + "<?>: " + this.format(msg, args);
            }
            String msgid = matcher.group(1);
            try {
                localizedmsg = this.mBundle.getString(this.mPrefix + msgid);
            }
            catch (Exception e) {
                return this.mPrefix + this.format(msg, args);
            }
            return this.mPrefix + msgid + ": " + this.format(localizedmsg, args);
        }
        catch (Exception e) {
            return this.mPrefix + this.format(msg, args);
        }
    }

    public LocalizedString x(String msg) {
        return this.x(msg, new Object[0]);
    }

    public LocalizedString x(String msg, Object arg0) {
        return this.x(msg, new Object[]{arg0});
    }

    public LocalizedString x(String msg, Object arg0, Object arg1) {
        return this.x(msg, new Object[]{arg0, arg1});
    }

    public LocalizedString x(String msg, Object arg0, Object arg1, Object arg2) {
        return this.x(msg, new Object[]{arg0, arg1, arg2});
    }

    public LocalizedString x(String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.x(msg, new Object[]{arg0, arg1, arg2, arg3});
    }

    public LocalizedString x(String msg, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.x(msg, new Object[]{arg0, arg1, arg2, arg3, arg4});
    }

    public LocalizedString x(String msg, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.x(msg, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5});
    }
}

