/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.tlqjms;

import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.tlqjms.Localizer;
import com.tongtech.jms.ra.tlqjms.TlqConnectionUrl;
import com.tongtech.jms.ra.tlqjms.TlqUrlParser;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.TopicConnectionFactory;
import com.tongtech.tmqi.XAConnectionFactory;
import com.tongtech.tmqi.XAQueueConnectionFactory;
import com.tongtech.tmqi.XATopicConnectionFactory;
import com.tongtech.tmqi.jmscluster_v2.ClusConnectionFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class RATlqObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger(RATlqObjectFactory.class);
    private static Localizer LOCALE = Localizer.get();

    @Override
    public int adjustDeliveryMode(int mode, boolean xa) {
        int newMode = mode;
        if (mode == 0) {
            newMode = 3;
        }
        return newMode;
    }

    @Override
    public ConnectionUrl createConnectionUrl(String s) {
        return new TlqUrlParser(s);
    }

    private String getInternalKey(String hostOrUsername) {
        if (hostOrUsername != null && hostOrUsername.startsWith("(") && hostOrUsername.endsWith(")") && hostOrUsername.length() > 2) {
            String key = hostOrUsername.substring(1, hostOrUsername.length() - 1);
            return key;
        }
        return null;
    }

    private ConnectionValues getConnectionValues(String key) throws Exception {
        Class<?> c = Class.forName("com.sun.enterprise.admin.common.MBeanServerFactory");
        Method m = c.getMethod("getMBeanServer", new Class[0]);
        MBeanServer mBeanServer = (MBeanServer)m.invoke(null, new Object[0]);
        ObjectName objName = new ObjectName("com.sun.appserv:type=jms-host,name=" + key + ",config=server-config,category=config");
        ConnectionValues ret = new ConnectionValues();
        ret.host = (String)mBeanServer.getAttribute(objName, "host");
        ret.port = (String)mBeanServer.getAttribute(objName, "port");
        ret.password = (String)mBeanServer.getAttribute(objName, "admin-password");
        ret.username = (String)mBeanServer.getAttribute(objName, "admin-user-name");
        return ret;
    }

    @Override
    public boolean validateAndAdjustURL(ConnectionUrl aurl) throws JMSException {
        TlqUrlParser urlParser = (TlqUrlParser)aurl;
        urlParser.validate();
        boolean hasChanged = false;
        return hasChanged;
    }

    @Override
    public Connection createConnection(Object fact, int domain, RAJMSActivationSpec activationSpec, RAJMSResourceAdapter ra, String username, String password) throws JMSException {
        String key = this.getInternalKey(username);
        if (key != null) {
            ConnectionValues v;
            try {
                v = this.getConnectionValues(key);
            }
            catch (Exception e) {
                throw Exc.jmsExc(LOCALE.x("E307: Could not obtain connection info for {0} (from [{1}]): {2}", key, username, e));
            }
            username = v.username;
            password = v.password;
        }
        return super.createConnection(fact, domain, activationSpec, ra, username, password);
    }

    @Override
    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Object basicConnectionFactory;
        TlqUrlParser urlParser;
        Properties p;
        String mfcname;
        block34: {
            mfcname = resourceAdapter.getFactoryName();
            p = new Properties();
            urlParser = (TlqUrlParser)this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
            TlqConnectionUrl[] tlqconnurls = urlParser.getConnectionUrls();
            try {
                if (Str.empty(mfcname)) {
                    switch (domain) {
                        case 1: {
                            basicConnectionFactory = Class.forName("com.tongtech.tmqi.QueueConnectionFactory").newInstance();
                            break block34;
                        }
                        case 3: {
                            basicConnectionFactory = Class.forName("com.tongtech.tmqi.XAQueueConnectionFactory").newInstance();
                            break block34;
                        }
                        case 2: {
                            basicConnectionFactory = Class.forName("com.tongtech.tmqi.TopicConnectionFactory").newInstance();
                            break block34;
                        }
                        case 4: {
                            basicConnectionFactory = Class.forName("com.tongtech.tmqi.XATopicConnectionFactory").newInstance();
                            break block34;
                        }
                        case 6: {
                            basicConnectionFactory = Class.forName("com.tongtech.tmqi.ConnectionFactory").newInstance();
                            break block34;
                        }
                        case 5: {
                            basicConnectionFactory = Class.forName("com.tongtech.tmqi.XAConnectionFactory").newInstance();
                            break block34;
                        }
                        default: {
                            throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                        }
                    }
                }
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "tongtech.jms.jndi.JmsContextFactory");
                env.put("java.naming.provider.url", urlParser.getSunOneUrlSet());
                InitialContext ctx = new InitialContext(env);
                basicConnectionFactory = ctx.lookup(mfcname);
                if (basicConnectionFactory instanceof ClusConnectionFactory) break block34;
                switch (domain) {
                    case 1: {
                        if (!(basicConnectionFactory instanceof QueueConnectionFactory)) {
                            sLog.error(new LocalizedString("type of [" + mfcname + "] is error, here need  QueueConnectionFactory "));
                            throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                        }
                        break;
                    }
                    case 3: {
                        if (!(basicConnectionFactory instanceof XAQueueConnectionFactory)) {
                            sLog.error(new LocalizedString("type of [" + mfcname + "] is error, here need  XAQueueConnectionFactory "));
                            throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                        }
                        break;
                    }
                    case 2: {
                        if (!(basicConnectionFactory instanceof TopicConnectionFactory)) {
                            sLog.error(new LocalizedString("type of [" + mfcname + "] is error, here need  TopicConnectionFactory "));
                            throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                        }
                        break;
                    }
                    case 4: {
                        if (!(basicConnectionFactory instanceof XATopicConnectionFactory)) {
                            sLog.error(new LocalizedString("type of [" + mfcname + "] is error, here need  XATopicConnectionFactory "));
                            throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                        }
                        break;
                    }
                    case 6: {
                        if (!(basicConnectionFactory instanceof com.tongtech.tmqi.ConnectionFactory)) {
                            sLog.error(new LocalizedString("type of [" + mfcname + "] is error, here need  ConnectionFactory "));
                            throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                        }
                        break;
                    }
                    case 5: {
                        if (!(basicConnectionFactory instanceof XAConnectionFactory)) {
                            sLog.error(new LocalizedString("type of [" + mfcname + "] is error, here need  XAConnectionFactory "));
                            throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                        }
                        break;
                    }
                    default: {
                        throw Exc.jmsExc(LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                    }
                }
            }
            catch (Exception e) {
                throw Exc.jmsExc(LOCALE.x("E300: Could not load or instantiate connection factory class: {0}", e), e);
            }
        }
        urlParser.getQueryProperties(p);
        if (Str.empty(mfcname)) {
            Method setProperty;
            try {
                setProperty = basicConnectionFactory.getClass().getMethod("setProperty", String.class, String.class);
                setProperty.invoke(basicConnectionFactory, "tmqiAddressList", urlParser.getSunOneUrlSet());
                setProperty.invoke(basicConnectionFactory, "tmqiConnectionFlowLimitEnabled", "true");
            }
            catch (Exception e) {
                throw Exc.jmsExc(LOCALE.x("E301: Failed to configure connection factory: {0}", e), e);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug("sjsmq Normal AddressList: " + urlParser.getSunOneUrlSet());
            }
            Enumeration<?> names = p.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith("tmqi")) continue;
                String value = p.getProperty(name);
                try {
                    setProperty.invoke(basicConnectionFactory, name, value);
                }
                catch (Exception e) {
                    throw Exc.jmsExc(LOCALE.x("Failed to configure connection factory: {0}", e), e);
                }
            }
        }
        if (!Str.empty(mfcname) && basicConnectionFactory instanceof ClusConnectionFactory) {
            ArrayList urls = new ArrayList();
            ClusConnectionFactory clusconnFC = (ClusConnectionFactory)basicConnectionFactory;
            clusconnFC.setMaxConnsPerClusterMember(1);
            clusconnFC.setStrategy(1);
            if (!Str.empty(mfcname)) {
                clusconnFC.setFactoryName(mfcname);
                clusconnFC.setJndiURLS(urlParser.getSunOneUrlSet());
            }
            return clusconnFC;
        }
        return (ConnectionFactory)basicConnectionFactory;
    }

    @Override
    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < TlqUrlParser.URL_PREFIXES.length; ++i) {
                if (!url.startsWith(TlqUrlParser.URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setClientID(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isTopic && "Durable".equals(spec.getSubscriptionDurability())) {
            String currentClientId;
            String newClientId = spec.getClientId();
            if (newClientId == null || newClientId.length() == 0) {
                newClientId = "CLIENTID-" + spec.getSubscriptionName();
            }
            if ((currentClientId = connection.getClientID()) == null || currentClientId.length() == 0) {
                this.setClientID(connection, newClientId);
            } else if (!newClientId.equals(currentClientId)) {
                sLog.warn(LOCALE.x("E303: ClientID is already set to [{0}]; cannot set to [{1}] as required in activationspec [{3}]", currentClientId, newClientId, spec));
            }
        }
    }

    @Override
    public Object getServerMgtMBean(RAJMSResourceAdapter ra, RAJMSActivationSpec spec) throws JMSException {
        String password;
        String username;
        Object ret = null;
        Properties p = new Properties();
        TlqUrlParser urlParser = (TlqUrlParser)this.getProperties(p, ra, spec, null, null);
        this.validateAndAdjustURL(urlParser);
        String string = username = spec == null ? null : spec.getUserName();
        if (username == null) {
            username = ra.getUserName();
        }
        String string2 = password = spec == null ? null : spec.getClearTextPassword();
        if (password == null) {
            password = ra.getClearTextPassword();
        }
        Properties connectionprops = new Properties();
        connectionprops.setProperty("tmqiAddressList", urlParser.getSunOneUrlAdminSet());
        if (sLog.isDebugEnabled()) {
            sLog.debug("sjsmq administration AddressList: " + urlParser.getSunOneUrlAdminSet());
        }
        try {
            Class<?> c = Class.forName("com.stc.jmsmx.sjsmq.ExternalSJSMQMBean");
            Object mbean = c.newInstance();
            Class[] signatures = new Class[]{Properties.class, String.class, String.class};
            Object[] args = new Object[]{connectionprops, username, password};
            Method method = c.getMethod("setConnectInfo", signatures);
            method.invoke(mbean, args);
            ret = mbean;
        }
        catch (Exception e) {
            sLog.info(LOCALE.x("E302: Error instantiating or configuring MBean for external SJS MQ server management: {0}", e));
        }
        return ret;
    }

    @Override
    public String getJMSServerType() {
        return "SUNONE";
    }

    private static class ConnectionValues {
        String host;
        String port;
        String username;
        String password;

        private ConnectionValues() {
        }
    }
}

