/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.tlqjms;

import com.tongtech.jms.ra.tlqjms.TlqConnectionUrl;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.Str;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.JMSException;

public class TlqUrlParser
extends ConnectionUrl {
    private TlqConnectionUrl[] mConnectionUrls;
    public static final String TLQ_LOCAL = "tlqlocal";
    public static final String TLQ_REMOTE = "tlq";
    public static final String TLQ_REMOTE_TLKQ = "tlkq";
    public static final String[] URL_PREFIXES = new String[]{"tlqlocal://", "tlq://", "tlkq://"};
    public static final String[] PROTOCOLS = new String[]{"tlqlocal", "tlq", "tlkq"};

    public TlqUrlParser(String s) {
        if (s == null || s.length() == 0) {
            s = "tlqlocal://";
        }
        ArrayList<TlqConnectionUrl> urls = new ArrayList<TlqConnectionUrl>();
        StringTokenizer it = new StringTokenizer(s, ",");
        while (it.hasMoreTokens()) {
            String url = it.nextToken();
            urls.add(new TlqConnectionUrl(url));
        }
        this.mConnectionUrls = urls.toArray(new TlqConnectionUrl[urls.size()]);
    }

    @Override
    public void getQueryProperties(Properties toAddTo) {
        TlqConnectionUrl[] urls = this.getConnectionUrls();
        for (int i = 0; i < urls.length; ++i) {
            urls[i].getQueryProperties(toAddTo);
        }
    }

    public boolean validate() throws JMSException {
        if (this.mConnectionUrls.length == 0) {
            throw new JMSException("URL should be a comma delimited set of URLs");
        }
        for (int j = 0; j < this.mConnectionUrls.length; ++j) {
            TlqConnectionUrl url = this.mConnectionUrls[j];
            boolean protOk = false;
            for (int i = 0; i < PROTOCOLS.length; ++i) {
                if (!PROTOCOLS[i].equals(url.getProtocol())) continue;
                protOk = true;
                break;
            }
            if (protOk) continue;
            throw new JMSException("Invalid protocol [" + url.getProtocol() + "]: should be one of [" + Str.concat(PROTOCOLS, ", ") + "].");
        }
        return false;
    }

    public TlqConnectionUrl[] getConnectionUrls() {
        return this.mConnectionUrls;
    }

    public String getSunOneUrlSet() {
        TlqConnectionUrl[] urls = this.getConnectionUrls();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            String protocol;
            if (i != 0) {
                buf.append(",");
            }
            if (TLQ_LOCAL.equals(protocol = urls[i].getProtocol())) {
                buf.append(protocol + "://" + urls[i].getHost() + "/" + urls[i].getService());
                continue;
            }
            buf.append(protocol + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/");
        }
        return buf.toString();
    }

    public String getSunOneUrlAdminSet() {
        TlqConnectionUrl[] urls = this.getConnectionUrls();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            if ("jms".equals(urls[i].getService())) {
                buf.append(urls[i].getProtocol() + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/admin");
                continue;
            }
            if ("jssljms".equals(urls[i].getService())) {
                buf.append(urls[i].getProtocol() + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/ssladmin");
                continue;
            }
            buf.append(urls[i].getProtocol() + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/admin");
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        TlqConnectionUrl[] urls = this.getConnectionUrls();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(urls[i].toString());
        }
        return buf.toString();
    }
}

