/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.unifiedjms;

import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.unifiedjms.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RAUnifiedResourceAdapter
extends RAJMSResourceAdapter {
    private static Logger sLog = Logger.getLogger(RAUnifiedResourceAdapter.class);
    private Map mObjFactories = Collections.synchronizedMap(new HashMap());
    private static Localizer LOCALE = Localizer.get();

    @Override
    public RAJMSObjectFactory createObjectFactory(String url) {
        RAJMSObjectFactory alreadyset = (RAJMSObjectFactory)this.mObjFactories.get(url);
        if (alreadyset != null) {
            return alreadyset;
        }
        if (url == null || url.length() == 0) {
            url = "tlqlocal://";
        }
        if (url == null || url.length() == 0) {
            throw Exc.rtexc(LOCALE.x("E701: URL is not set"));
        }
        String[] classnames = new String[]{"com.tongtech.jms.ra.jndi.RAJNDIObjectFactory", "com.tongtech.jms.ra.tlqjms.RATlqObjectFactory"};
        for (int i = 0; i < classnames.length; ++i) {
            try {
                Class<?> c = Class.forName(classnames[i], true, this.getClass().getClassLoader());
                RAJMSObjectFactory o = (RAJMSObjectFactory)c.newInstance();
                if (!o.isUrl(url)) continue;
                this.mObjFactories.put(url, o);
                return o;
            }
            catch (Exception e) {
                sLog.warn(LOCALE.x("E700: Error while matching URL [{0}] with classname [{1}]: {2}", url, classnames[i], e), e);
            }
        }
        throw Exc.rtexc(LOCALE.x("E702: The url [{0}] cannot be matched with a JMS provider", url));
    }
}

