/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplaceHeaders {
    private static Pattern SEEBEYONDPATTERN = Pattern.compile("(.*?)(\\/\\*.*?SEEBEYOND.*?\\*\\/)(.*)", 32);
    private static Pattern CONCURRENTPATTERN = Pattern.compile("(.*)(\\/\\*.*Doug Lea and released into the public domain.*\\*\\/)(.*)", 32);
    private static Pattern CDDLPATTERN = Pattern.compile("(.*)(\\/\\*.*Common Development and Distribution License.*\\*\\/)(.*)", 32);
    private static String CR = System.getProperty("line.separator");
    private static String REPLACE1 = "/*" + CR + " * The contents of this file are subject to the terms of the Common Development and Distribution License" + CR + " * (the \"License\"). You may not use this file except in compliance with the License." + CR + " *" + CR + " * You can obtain a copy of the license at https://glassfish.dev.java.net/public/CDDLv1.0.html." + CR + " * See the License for the specific language governing permissions and limitations under the License." + CR + " *" + CR + " * When distributing Covered Code, include this CDDL HEADER in each file and include the License file at" + CR + " * https://glassfish.dev.java.net/public/CDDLv1.0.html. If applicable add the following below this" + CR + " * CDDL HEADER, with the fields enclosed by brackets \"[]\" replaced with your own identifying" + CR + " * information: Portions Copyright [year] [name of copyright owner]" + CR + " */" + CR;
    private static String REPLACE2 = "/*" + CR + " * Copyright 2003-2007 Sun Microsystems, Inc. All Rights Reserved." + CR + " */";
    private int mWritten;
    private int mSkipped;

    public static void safeclose(InputStream inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void safeclose(Reader inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void safeclose(Writer f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void safeclose(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(File f) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            char[] buf = new char[(int)f.length() + 1];
            reader = new BufferedReader(new FileReader(f));
            int n = reader.read(buf);
            if (n == buf.length) {
                throw new RuntimeException("Buffer overflow in " + f.getAbsolutePath() + ": " + n);
            }
            if (n <= 0) {
                throw new RuntimeException("Buffer underflow in " + f.getAbsolutePath() + ": " + n);
            }
            string = new String(buf, 0, n);
        }
        catch (Throwable throwable) {
            ReplaceHeaders.safeclose(reader);
            throw throwable;
        }
        ReplaceHeaders.safeclose(reader);
        return string;
    }

    private static void write(String what, File f) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f));
            writer.write(what);
            writer.flush();
        }
        catch (Throwable throwable) {
            ReplaceHeaders.safeclose(writer);
            throw throwable;
        }
        ReplaceHeaders.safeclose(writer);
    }

    private void processFile(File f) throws Exception {
        String contents = ReplaceHeaders.read(f);
        Matcher m = SEEBEYONDPATTERN.matcher(contents);
        boolean ok = true;
        if (ok && !(ok = m.matches()) && !CONCURRENTPATTERN.matcher(contents).matches() && !CDDLPATTERN.matcher(contents).matches()) {
            System.out.println("NO MATCH: " + f.getAbsolutePath());
        }
        if (ok) {
            boolean bl = ok = !contents.startsWith(REPLACE1);
        }
        if (ok && m.groupCount() != 3) {
            ok = false;
            System.out.println("Invalid group count: " + m.groupCount() + " in " + f.getAbsolutePath());
        }
        String m1 = null;
        String m2 = null;
        String m3 = null;
        if (ok) {
            m1 = m.group(1);
            m2 = m.group(2);
            m3 = m.group(3);
            String check = m1 + m2 + m3;
            if (!check.equals(contents)) {
                System.out.println("Check failure in " + f.getAbsolutePath());
                System.out.println("x=[" + check + "]");
                System.out.println("contents=[" + contents + "]");
                ok = false;
            }
        }
        if (ok) {
            String replace = m1 + REPLACE1 + REPLACE2 + m3;
            ReplaceHeaders.write(replace, f);
            ++this.mWritten;
        }
        if (!ok) {
            ++this.mSkipped;
        }
    }

    private void report() {
        System.out.println(this.mWritten + " files changed");
        System.out.println(this.mSkipped + " files skipped");
    }

    private ReplaceHeaders recurse(File dir) throws Exception {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            File f = list[i];
            if (f.isDirectory()) {
                this.recurse(f);
                continue;
            }
            if (!f.getName().endsWith(".java")) continue;
            this.processFile(f);
        }
        return this;
    }

    public static void main(String[] args) {
        String dir = args[0];
        try {
            new ReplaceHeaders().recurse(new File(dir)).report();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

