/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class Str {
    private static final String MARK = "JMSJCA.sep=";
    private static final String PW_PREFIX = "__:ENC:08:";

    public static String msg(String msg, Object[] args) {
        return MessageFormat.format(msg, args);
    }

    public static String msg(String msg) {
        return Str.msg(msg, new Object[0]);
    }

    public static String msg(String msg, Object arg1) {
        return Str.msg(msg, new Object[]{arg1});
    }

    public static String msg(String msg, Object arg1, Object arg2) {
        return Str.msg(msg, new Object[]{arg1, arg2});
    }

    public static String msg(String msg, Object arg1, Object arg2, Object arg3) {
        return Str.msg(msg, new Object[]{arg1, arg2, arg3});
    }

    public static String msg(String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        return Str.msg(msg, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static String msg(String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return Str.msg(msg, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public static String password(String inp) {
        if (inp == null) {
            return "null";
        }
        if (inp.length() == 0) {
            return "zero-length";
        }
        return "###";
    }

    public static boolean empty(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isSpaceChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int hash(int seed, Object o) {
        if (o == null) {
            return seed + 17;
        }
        return seed * 37 + o.hashCode();
    }

    public static int hash(int seed, boolean o) {
        return seed * 37 + (o ? 3 : 7);
    }

    public static String parseProperties(String mark, String toParse) {
        if (Str.empty(toParse)) {
            return toParse;
        }
        int at = toParse.indexOf(mark);
        if (at < 0) {
            return toParse;
        }
        if (at + mark.length() == toParse.length()) {
            throw new RuntimeException("Missing separator character in [" + toParse + "]");
        }
        char sep = toParse.charAt(at + mark.length());
        return Str.parseProperties(sep, toParse);
    }

    public static String packOptions(String original, String toPack) {
        char sep = original == null || !original.startsWith(MARK) || original.length() <= MARK.length() ? (char)',' : original.charAt(MARK.length());
        toPack = toPack.replaceAll("" + sep, "\\" + sep);
        toPack = toPack.replaceAll("\r\n", "\n");
        toPack = toPack.replace('\r', '\n');
        toPack = toPack.replace('\n', sep);
        return MARK + sep + toPack;
    }

    public static String unpackOptions(String toUnpack) {
        if (toUnpack == null || !toUnpack.startsWith(MARK) || toUnpack.length() <= MARK.length()) {
            return toUnpack;
        }
        StringBuffer ret = new StringBuffer();
        char sep = toUnpack.charAt(MARK.length());
        for (int i = MARK.length() + 1; i < toUnpack.length(); ++i) {
            char c = toUnpack.charAt(i);
            if (c == sep) {
                ret.append("\r\n");
                continue;
            }
            if (c == '\\') {
                if (i < toUnpack.length() - 1 && toUnpack.charAt(i + 1) == sep) {
                    ret.append(sep);
                    ++i;
                    continue;
                }
                ret.append(c);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private static String parseProperties(char delimiter, String input) {
        StringBuffer ret = new StringBuffer();
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            if (c == delimiter) {
                ret.append("\r\n");
                continue;
            }
            if (c == '\\') {
                if (i < n - 1 && input.charAt(i + 1) == delimiter) {
                    ret.append(delimiter);
                    ++i;
                    continue;
                }
                ret.append(c);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static void deserializeProperties(String s, Properties toAdd) {
        if (Str.empty(s)) {
            return;
        }
        try {
            Properties p = new Properties();
            ByteArrayInputStream inp = new ByteArrayInputStream(s.getBytes("ISO-8859-1"));
            p.load(inp);
            for (Map.Entry<Object, Object> element : p.entrySet()) {
                toAdd.put(element.getKey(), element.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load properties: " + e, e);
        }
    }

    public static String serializeProperties(Properties p) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            p.store(out, "");
            return out.toString("ISO-8859-1");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize properties: " + e, e);
        }
    }

    public static String concat(Object[] strs, String delim) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            if (i != 0) {
                ret.append(delim);
            }
            ret.append(strs[i]);
        }
        return ret.toString();
    }

    public boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String substituteAntProperty(String value, Translator substitutions, int[] nResolved, int[] nUnresolved) throws Exception {
        int pos;
        StringBuffer ret = new StringBuffer();
        int prev = 0;
        nResolved[0] = 0;
        nUnresolved[0] = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                ret.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                ret.append("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                ret.append(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new Exception("Syntax error in property in " + value + " at index " + pos);
            }
            String propertyName = value.substring(pos + 2, endName);
            String replacement = substitutions.get(propertyName);
            if (replacement != null) {
                ret.append(replacement);
                nResolved[0] = nResolved[0] + 1;
            } else {
                ret.append("${").append(propertyName).append("}");
                nUnresolved[0] = nUnresolved[0] + 1;
            }
            prev = endName + 1;
        }
        if (prev < value.length()) {
            ret.append(value.substring(prev));
        }
        return ret.toString();
    }

    public static String pwdecode(String todecode) {
        if (todecode == null) {
            return null;
        }
        if (todecode.length() == 0) {
            return "";
        }
        if (!todecode.startsWith(PW_PREFIX)) {
            return todecode;
        }
        String encoded = todecode.substring(PW_PREFIX.length());
        return Base64Coder.decode(encoded);
    }

    public static String pwencode(String toencode) {
        return PW_PREFIX + Base64Coder.encode(toencode);
    }

    private static class Base64Coder {
        private static final int END_OF_INPUT = -1;
        private static final int NON_BASE_64 = -1;
        protected static final byte[] BASE64CARS;
        protected static final byte[] DECODETABLE;

        private Base64Coder() {
        }

        public static String encode(String string) {
            return new String(Base64Coder.encode(string.getBytes()));
        }

        public static String encode(String string, String enc) throws UnsupportedEncodingException {
            return new String(Base64Coder.encode(string.getBytes(enc)), enc);
        }

        public static byte[] encode(byte[] bytes) {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            int length = bytes.length;
            int mod = length % 3;
            if (mod != 0) {
                length += 3 - mod;
            }
            length = length * 4 / 3;
            ByteArrayOutputStream out = new ByteArrayOutputStream(length);
            try {
                Base64Coder.encode(in, out, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return out.toByteArray();
        }

        public static void encode(InputStream in, OutputStream out) throws IOException {
            Base64Coder.encode(in, out, true);
        }

        public static void encode(InputStream in, OutputStream out, boolean lineBreaks) throws IOException {
            int[] inBuffer = new int[3];
            int lineCount = 0;
            boolean done = false;
            while (!done && (inBuffer[0] = in.read()) != -1) {
                inBuffer[1] = in.read();
                inBuffer[2] = in.read();
                out.write(BASE64CARS[inBuffer[0] >> 2]);
                if (inBuffer[1] != -1) {
                    out.write(BASE64CARS[inBuffer[0] << 4 & 0x30 | inBuffer[1] >> 4]);
                    if (inBuffer[2] != -1) {
                        out.write(BASE64CARS[inBuffer[1] << 2 & 0x3C | inBuffer[2] >> 6]);
                        out.write(BASE64CARS[inBuffer[2] & 0x3F]);
                    } else {
                        out.write(BASE64CARS[inBuffer[1] << 2 & 0x3C]);
                        out.write(61);
                        done = true;
                    }
                } else {
                    out.write(BASE64CARS[inBuffer[0] << 4 & 0x30]);
                    out.write(61);
                    out.write(61);
                    done = true;
                }
                if (!lineBreaks || (lineCount += 4) < 76) continue;
                out.write(10);
                lineCount = 0;
            }
            if (lineBreaks && lineCount >= 1) {
                out.write(10);
                lineCount = 0;
            }
            out.flush();
        }

        public static String decode(String string) {
            return new String(Base64Coder.decode(string.getBytes()));
        }

        public static String decode(String string, String enc) throws UnsupportedEncodingException {
            return new String(Base64Coder.decode(string.getBytes(enc)), enc);
        }

        public static byte[] decode(byte[] bytes) {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            int length = bytes.length;
            int mod = length % 4;
            if (mod != 0) {
                length += 4 - mod;
            }
            length = length * 3 / 4;
            ByteArrayOutputStream out = new ByteArrayOutputStream(length);
            try {
                Base64Coder.decode(in, out, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return out.toByteArray();
        }

        private static final int readBase64(InputStream in, boolean throwExceptions) throws IOException {
            int read;
            do {
                if ((read = in.read()) != -1) continue;
                return -1;
            } while ((read = DECODETABLE[(byte)read]) <= -1);
            return read;
        }

        public static void decode(InputStream in, OutputStream out) throws IOException {
            Base64Coder.decode(in, out, true);
        }

        public static void decode(InputStream in, OutputStream out, boolean throwExceptions) throws IOException {
            int[] inBuffer = new int[4];
            boolean done = false;
            while (!done && (inBuffer[0] = Base64Coder.readBase64(in, throwExceptions)) != -1 && (inBuffer[1] = Base64Coder.readBase64(in, throwExceptions)) != -1) {
                inBuffer[2] = Base64Coder.readBase64(in, throwExceptions);
                inBuffer[3] = Base64Coder.readBase64(in, throwExceptions);
                out.write(inBuffer[0] << 2 | inBuffer[1] >> 4);
                if (inBuffer[2] != -1) {
                    out.write(inBuffer[1] << 4 | inBuffer[2] >> 2);
                    if (inBuffer[3] != -1) {
                        out.write(inBuffer[2] << 6 | inBuffer[3]);
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
            }
            out.flush();
        }

        static {
            int i;
            BASE64CARS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
            DECODETABLE = new byte[256];
            for (i = 0; i < DECODETABLE.length; ++i) {
                Base64Coder.DECODETABLE[i] = -1;
            }
            for (i = 0; i < BASE64CARS.length; i = (int)((byte)(i + 1))) {
                Base64Coder.DECODETABLE[Base64Coder.BASE64CARS[i]] = i;
            }
        }
    }

    public static interface Translator {
        public String get(String var1);
    }
}

