/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.util;

import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;

public abstract class Wrapper
implements InvocationHandler {
    private static Logger sLog = Logger.getLogger(Wrapper.class);
    private Class mItf;
    private Object mInterceptor;
    private Object mWrapper;
    private Set mInterceptedMethods;
    private ClassLoader mClassloader;
    private Object mDelegate;
    private int mCtExceptions;
    private Exception mFirstException;
    private String mSignature;
    private static final Localizer LOCALE = Localizer.get();

    protected void init(ClassLoader classloader, Class itf, Object delegate, Object interceptor, String signature) {
        this.mItf = itf;
        this.mInterceptor = interceptor;
        this.mInterceptedMethods = new HashSet();
        this.mClassloader = classloader;
        this.mDelegate = delegate;
        this.mSignature = signature;
        Method[] methods = this.mInterceptor.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.mInterceptedMethods.add(methods[i].getName());
        }
        this.createNewWrapper();
    }

    public Class getItfClass() {
        return this.mItf;
    }

    public static boolean isClass(Class a, Class b) {
        return a == b || a.getName().equals(b.getName());
    }

    public boolean isItfClass(Class c) {
        return Wrapper.isClass(c, this.mItf);
    }

    public Object getDelegate() throws Throwable {
        return this.mDelegate;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public Object getWrapper() {
        return this.mWrapper;
    }

    public void createNewWrapper() {
        this.mWrapper = Proxy.newProxyInstance(this.mClassloader, new Class[]{this.mItf}, (InvocationHandler)this);
    }

    public static Wrapper getWrapperFromProxy(Object o) {
        return (Wrapper)Proxy.getInvocationHandler(o);
    }

    public void invokeOnClosed(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.getName().equals("close")) {
            throw Exc.illstate(LOCALE.x("E153: This {0} is closed", this.getItfClass().getName()));
        }
    }

    public void physicalClose() {
        this.createNewWrapper();
        try {
            Method m = this.getDelegate().getClass().getMethod("close", new Class[0]);
            m.invoke(this.getDelegate(), new Object[0]);
        }
        catch (InvocationTargetException ex1) {
            sLog.warn(LOCALE.x("E094: This {0} could not be closed properly: {1}", this.getItfClass(), ex1.getTargetException()), ex1.getTargetException());
        }
        catch (Throwable ex) {
            sLog.warn(LOCALE.x("E094: This {0} could not be closed properly: {1}", this.getItfClass(), ex), ex);
        }
    }

    public void exceptionOccurred(Throwable ex) {
        if (this.mFirstException == null) {
            if (ex instanceof Exception) {
                this.mFirstException = (Exception)ex;
            } else {
                this.mFirstException = new Exception("Runtime exception: " + ex);
                Exc.setCause(this.mFirstException, ex);
            }
        }
        ++this.mCtExceptions;
    }

    public boolean hasExceptionOccurred() {
        return this.mCtExceptions > 0;
    }

    public Exception getFirstException() {
        return this.mFirstException;
    }

    public int getExceptionCount() {
        return this.mCtExceptions;
    }

    public boolean equals(Object other) {
        return other == this || other == this.mWrapper;
    }

    public int hashCode() {
        int ret = 37;
        ret = Str.hash(ret, this.mDelegate);
        return ret;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        Object target = null;
        if (proxy != this.mWrapper) {
            this.invokeOnClosed(proxy, method, args);
        } else {
            if (!this.mInterceptedMethods.contains(method.getName())) {
                target = this.getDelegate();
            } else {
                try {
                    method = this.mInterceptor.getClass().getMethod(method.getName(), method.getParameterTypes());
                    target = this.mInterceptor;
                }
                catch (NoSuchMethodException ignore) {
                    target = this.getDelegate();
                }
            }
            try {
                ret = method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                this.exceptionOccurred(ex.getTargetException());
                throw ex.getTargetException();
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (IllegalAccessException ex) {
                throw ex;
            }
        }
        return ret;
    }
}

