/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.tlq;

import com.tongtech.jms.JMSException;
import com.tongtech.jms.jni.TlqException;
import com.tongtech.jms.jni.TlqId;
import com.tongtech.jms.jni.TlqMessage;
import com.tongtech.jms.jni.TlqMsgOpt;
import com.tongtech.jms.jni.TlqQCUHdl;
import com.tongtech.jms.tlq.ConsumerQcuHandlerTable;
import com.tongtech.jms.tlq.JMSShutdownHook;
import com.tongtech.jms.tlq.TlqCompositeMessage;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tlq.basement.Basement;
import com.tongtech.tlq.basement.LocalBasement;
import com.tongtech.tlq.basement.TlqQueInfo;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.util.Hex;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class TlqWrapper {
    static Logger logger = LoggerFactory.getLogger(TlqWrapper.class);
    public static final String MESSAGE_FLAG = "-100";
    public static final int LAST_MSG_FLAG = 1;
    static final String QCU_NAME = "QCUNAME";
    private TlqId gid = null;
    private Basement serverDelegate = null;
    private TlqQCUHdl readAckQcuHandler = null;
    private TlqQCUHdl readMessageQcuHandler = null;
    private TlqQCUHdl connQcuHandler = null;
    private TlqQCUHdl writeQcuHandler = null;
    ConsumerQcuHandlerTable qcuTable = null;
    private boolean isDisConneted = false;
    private static JMSShutdownHook hook = new JMSShutdownHook();
    static Thread shutdownThread = new Thread(hook);
    public static final int NO_SPACE_TLQ_BUFFER = 1017;
    public static final int NO_MESSAGE_IN_QUEUE = 2602;
    public static final int SUBER_IS_NOT_EXIST = 1002;
    private final int BUFF_FULL_RETRY_COUNT = 100;
    private long messageSum = 0L;
    private long continueSum = 0L;
    private static boolean isLoggedVersion;
    private String qcuName;

    public TlqWrapper(String qcuName) {
        if (!isLoggedVersion) {
            logger.info("VERSION:2009-6-18 18:00");
            isLoggedVersion = true;
        }
        this.qcuTable = new ConsumerQcuHandlerTable();
        hook.addConnection(this);
        this.qcuName = qcuName;
    }

    public String getClientId() {
        return this.gid.getClientId();
    }

    public void checkin(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_checkin");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isTraceEnabled()) {
            logger.trace("CheckIn AnsId:" + msgopt.AnsId + "ConsumerId:" + msgopt.ConsumerId + " Type:" + msgopt.getOperateType());
        }
        if (msgopt.getOperateType() == 117) {
            this.writeQcuHandler = new TlqQCUHdl();
            this.serverDelegate.Jms_CheckIn(this.gid, this.writeQcuHandler, msgopt);
            if (logger.isTraceEnabled()) {
                logger.trace("checkin gid:{}, writeQcuHandler:{}", this.gid, (Object)this.writeQcuHandler);
            }
        } else {
            TlqQCUHdl consumerQcuHandler = new TlqQCUHdl();
            long consumerId = Long.parseLong(msgopt.ConsumerId);
            this.serverDelegate.Jms_CheckIn(this.gid, consumerQcuHandler, msgopt);
            this.qcuTable.put(new Long(consumerId), consumerQcuHandler);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_checkin");
        }
    }

    public void checkout(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_checkout");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isTraceEnabled()) {
            logger.trace("call tlq CheckOut AnsId:" + msgopt.AnsId + "ConsumerId:" + msgopt.ConsumerId);
        }
        if (commsg.getPacketType() == 118) {
            if (logger.isTraceEnabled()) {
                logger.trace("+++checkout gid:{}, writeQcuHandler:{}", this.gid, (Object)this.writeQcuHandler);
            }
            this.serverDelegate.Jms_CheckOut(this.gid, this.writeQcuHandler, msgopt);
        } else if (commsg.getPacketType() == 202) {
            int txid = this.connQcuHandler.getTransId();
            this.connQcuHandler.setTransId((int)Long.parseLong(msgopt.ConsumerId));
            if (logger.isTraceEnabled()) {
                logger.trace("+++checkout gid:{}, connQcuHandler:{}", this.gid, (Object)this.connQcuHandler);
            }
            this.serverDelegate.Jms_CheckOut(this.gid, this.connQcuHandler, msgopt);
            this.connQcuHandler.setTransId(txid);
        } else {
            long consumerId = Long.parseLong(commsg.getTlqMsgOpt().getConsumerId());
            TlqQCUHdl consumerQcuHandler = this.qcuTable.get(new Long(consumerId));
            if (logger.isTraceEnabled()) {
                logger.trace("+++checkout consumerid:{}, consumerQcuHandler:{}", new Long(consumerId), (Object)consumerQcuHandler);
            }
            this.serverDelegate.Jms_CheckOut(this.gid, consumerQcuHandler, msgopt);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_checkout");
        }
    }

    public void jmsWrite(ReadWritePacket pkt) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("write pkt, packetType: {} id: {} , messageId: {}", new Object[]{new Integer(pkt.getPacketType()), new Long(pkt.getConsumerID()), pkt.getMessageID()});
        }
        long txid = 0L;
        TlqCompositeMessage commsg = this.jmsmsgConvertTlqmsg(pkt);
        for (int i = 0; i < 100; ++i) {
            try {
                switch (pkt.getPacketType()) {
                    case 211: {
                        this.unSubcribe(commsg);
                        break;
                    }
                    case 210: {
                        this.subMessage(commsg);
                        break;
                    }
                    case 301: {
                        this.closeConnection();
                        break;
                    }
                    case 300: {
                        this.openConnection();
                        break;
                    }
                    case 117: 
                    case 200: {
                        this.checkin(commsg);
                        break;
                    }
                    case 118: 
                    case 201: 
                    case 202: {
                        this.checkout(commsg);
                        break;
                    }
                    case 24: {
                        txid = pkt.getTransactionID();
                        this.tlqAcknowledge(commsg, txid, 1);
                        break;
                    }
                    case 32: {
                        txid = pkt.getTransactionID();
                        this.tlqAcknowledge(commsg, txid, 0);
                        break;
                    }
                    case 14: {
                        txid = pkt.getTransactionID();
                        this.addConsumer(commsg, txid);
                        break;
                    }
                    case 34: {
                        Boolean isTemp = (Boolean)pkt.getProperties().get("JMS_TONG_ISTempDestination");
                        this.createDestination(commsg, pkt.getIsQueue(), isTemp);
                        break;
                    }
                    case 40: {
                        this.verifyDestination(commsg);
                        break;
                    }
                    case 26: {
                        this.brower(commsg);
                        break;
                    }
                    case 42: {
                        this.deliver(commsg);
                        break;
                    }
                    case 16: {
                        this.deleteConsumer(commsg);
                        break;
                    }
                    case 36: {
                        this.destroyDestination(commsg, pkt.getIsQueue());
                        break;
                    }
                    case 20: {
                        this.start(commsg);
                        break;
                    }
                    case 22: {
                        this.stop(commsg);
                        break;
                    }
                    case 56: {
                        this.prepareTransaction(commsg);
                        break;
                    }
                    case 44: {
                        this.startTransaction(commsg);
                        break;
                    }
                    case 46: {
                        txid = pkt.getTransactionID();
                        this.commitTransaction(commsg, txid);
                        break;
                    }
                    case 48: {
                        txid = pkt.getTransactionID();
                        this.rollbackTransacation(commsg, txid);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        txid = pkt.getTransactionID();
                        this.writeJmsMessage(commsg, txid);
                        break;
                    }
                    case 66: {
                        this.deleteProducer(commsg);
                        break;
                    }
                    case 28: {
                        this.goodbye(commsg);
                        break;
                    }
                    case 65: {
                        this.resumeConsumerFlow(commsg);
                        break;
                    }
                }
                break;
            }
            catch (com.tongtech.tlq.basement.TlqException e) {
                logger.info(e.toString());
                if (e.getTlqErrno() == 1017) {
                    logger.warn("write buffer full, please modify QueSendBuff in tlq's conf file.packetType: {} id: {} consumerId: {}, messageId: {}", new Object[]{new Integer(pkt.getPacketType()), new Long(pkt.getConsumerID()), pkt.getMessageID()});
                    if (i == 99) {
                        throw e;
                    }
                    Thread.sleep(100L);
                    continue;
                }
                TlqException e1 = new TlqException(e.toString());
                e1.setTlqErrno(e.getTlqErrno());
                logger.error(e.toString(), (Throwable)((Object)e));
                throw e1;
            }
            catch (Exception ex) {
                logger.error("", ex);
                throw ex;
            }
        }
    }

    private void unSubcribe(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_write, unSubcribe");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        this.serverDelegate.Jms_Write(this.gid, this.connQcuHandler, tlqmsg, msgopt);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_write, add unSubcribe");
        }
    }

    private void handleCPkt(ReadWritePacket pkt, TlqMessage msg, TlqMsgOpt msgopt) {
        Hashtable msght = msg.getUserProperties();
        if (msg.MsgType == '\u0000' || msg.MsgType == '\u0002') {
            if (logger.isTraceEnabled()) {
                logger.trace("CPacket: get BYTES_MESSAGE");
            }
            pkt.setPacketType(2);
        } else if (msg.MsgType == '\u0001') {
            if (logger.isTraceEnabled()) {
                logger.trace("CPacket: get FILE_MESSAGE");
            }
            pkt.setPacketType(7);
            msght.put("JMS_TONG_RENAME_FLAG", new Boolean(msg.RenamedFlag == '\u0001'));
        } else {
            logger.error("message type is not known, {}", new Integer(msg.MsgType));
            throw new RuntimeException("message type is not known " + msg.MsgType);
        }
        String msgid = msg.getMsgId();
        String corrmsgid = msg.getCorrMsgId();
        pkt.setExpiration(msg.Expiry == -1 ? 0L : (long)(msg.Expiry * 1000) + System.currentTimeMillis());
        pkt.setPriority(msg.Priority);
        if (msgid.startsWith("ID:")) {
            pkt.setMessageID(msgid);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("__TONGTECH__");
            sb.append(new String(Hex.encodeHex(msg.getByteMsgId())));
            sb.append("__:ID:__");
            pkt.setMessageID(sb.toString());
            if (logger.isDebugEnabled()) {
                logger.debug("after encoder, from IBMMQ. {}", (Object)sb.toString());
            }
        }
        pkt.setTimestamp(msg.PutDateTime);
        if (logger.isDebugEnabled()) {
            logger.debug("Destination={}, {}, corrMsgId={} subFlag={} {}", new Object[]{msgopt.QueName, msg.DestQName, corrmsgid, new Integer(msg.SubFlag), new Boolean(msg.SubFlag == '\u0001')});
        }
        if (msg.SubFlag == '\u0000') {
            pkt.setDestination(msgopt.QueName);
            pkt.setDestinationClass("com.tongtech.tmqi.Queue");
            pkt.setIsQueue(true);
        } else {
            pkt.setDestination((String)msg.getUserProperties().get("JMSDestination"));
            pkt.setDestinationClass("com.tongtech.tmqi.Topic");
            pkt.setSubQueue(msgopt.QueName);
            pkt.setIsQueue(false);
        }
        if (msg.Persistence == '\u0001') {
            pkt.setPersistent(true);
        } else {
            pkt.setPersistent(false);
        }
        pkt.setCorrelationID(corrmsgid);
        pkt.setSrcNode(msg.SrcNode);
        logger.debug("TlqWrapper srcNode:{}", (Object)pkt.getSrcNode());
        if (logger.isTraceEnabled()) {
            logger.trace("recieve message JMSDestination:{} ,srcNode:{}", (Object)pkt.getMessageID(), (Object)msg.SrcNode);
        }
        if (msg.MsgSize == 0 || msg.getMsgData() == null || msg.getMsgData().length == 0) {
            pkt.setMessageBody(null);
        } else {
            pkt.setMessageBody(msg.getMsgData());
        }
        pkt.setConsumerID(Long.parseLong(msgopt.ConsumerId));
        msght.put("JMS_TONG_ConsumerID", msgopt.ConsumerId);
        msght.put("JMS_TONG_Status", new Integer(200));
        if (msg.getUsrContext() != null) {
            String usrContext = null;
            try {
                usrContext = new String(msg.getUsrContext(), "GB2312");
            }
            catch (UnsupportedEncodingException e) {
                usrContext = new String(msg.getUsrContext());
            }
            msght.put("JMS_TONG_UsrContext", usrContext);
        }
        pkt.setProperties(msght);
    }

    private boolean isFromJms(TlqMessage msg, TlqMsgOpt msgopt) {
        Object obj = msg.getUserProperties().get("JMS_TONG_MessageType");
        return obj != null;
    }

    private void resumeConsumerFlow(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_continue");
        }
        long consumerId = Long.parseLong(commsg.getTlqMsgOpt().ConsumerId);
        int msgSize = commsg.getTlqMsgOpt().GetMsgNum;
        if (logger.isDebugEnabled()) {
            logger.debug("Send jms_continue,consumerId:{},Size:{}", new Long(consumerId), (Object)new Integer(msgSize));
        }
        this.serverDelegate.Jms_Continue(this.gid, this.connQcuHandler, commsg.getTlqMsgOpt(), consumerId + "|" + msgSize);
        this.continueSum += (long)msgSize;
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_continue");
        }
    }

    public ReadWritePacket jmsAckRead() throws Exception {
        ReadWritePacket pkt;
        long txid;
        TlqMsgOpt msgOpt;
        TlqMessage tlqmsg;
        block12: {
            if (logger.isTraceEnabled()) {
                logger.trace("start call tlq's jms_ackread");
            }
            tlqmsg = new TlqMessage();
            msgOpt = new TlqMsgOpt();
            int ret = 0;
            txid = -1201L;
            try {
                ret = this.serverDelegate.Jms_Read(this.gid, this.readAckQcuHandler, tlqmsg, msgOpt, 0);
                txid = this.readAckQcuHandler.getTransId();
                logger.debug("read a ack: AnsId:{} ConsumerId:{} opreateType:{} txid:{} corrmsgId:{}", new Object[]{msgOpt.AnsId, msgOpt.ConsumerId, PacketType.getString(msgOpt.OperateType), new Long(txid), tlqmsg.getCorrMsgId()});
            }
            catch (com.tongtech.tlq.basement.TlqException e) {
                logger.warn("catch a tlqException: packetType:{} , ackId:{}", new Integer(msgOpt.OperateType), (Object)msgOpt.AnsId);
                logger.warn("TlqErrno:" + e.getTlqErrno());
                pkt = InjectorUtil.createReadWritePacket(1);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                boolean realError = true;
                if (e.getTlqErrno() == 1017) {
                    logger.warn("tlq's queue full." + e.toString());
                    props.put("JMS_TONG_Status", new Integer(414));
                } else if (e.getTlqErrno() == 2602 && msgOpt.OperateType == 123) {
                    realError = false;
                } else if (e.getTlqErrno() == 1002 && msgOpt.OperateType == 8) {
                    realError = false;
                    tlqmsg.setIntProperty("JMS_TONG_Status", 404);
                } else {
                    logger.error(e.toString(), (Throwable)((Object)e));
                    props.put("JMS_TONG_Status", new Integer(400));
                    props.put("JMS_TONG_Error", e.toString());
                }
                if (!realError) break block12;
                props.put("JMS_TONG_TransactionID", new Long(txid));
                pkt.setProperties(props);
                pkt.setPacketType(msgOpt.OperateType);
                pkt.setConsumerID(Long.parseLong(msgOpt.AnsId));
                logger.warn("tlqException: packetType:{} , ackId:{}", new Integer(msgOpt.OperateType), (Object)msgOpt.AnsId);
                if (msgOpt.AnsId != MESSAGE_FLAG && msgOpt.OperateType == 1) {
                    pkt.setPacketType(15);
                    props.put("JMS_TONG_ConsumerID", msgOpt.ConsumerId);
                }
                return pkt;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("jmsAckRead AnsId:{} ConsumerId:{} opreateType:{} txid:{} corrmsgId:{}", new Object[]{msgOpt.AnsId, msgOpt.ConsumerId, PacketType.getString(msgOpt.OperateType), new Long(txid), tlqmsg.getCorrMsgId()});
        }
        TlqCompositeMessage commsg = new TlqCompositeMessage();
        commsg.setTlqMessage(tlqmsg);
        commsg.setTlqMsgOpt(msgOpt);
        pkt = this.tlqmsgConvertJmsmsg(commsg, txid);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_ackread");
        }
        return pkt;
    }

    public ReadWritePacket jmsMessageRead() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_messageread");
        }
        TlqMessage tlqmsg = new TlqMessage();
        TlqMsgOpt msgOpt = new TlqMsgOpt();
        int ret = 0;
        try {
            ret = this.serverDelegate.Jms_Read(this.gid, this.readMessageQcuHandler, tlqmsg, msgOpt, 1);
            ++this.messageSum;
            this.readMessageQcuHandler.setTransId(-2);
        }
        catch (com.tongtech.tlq.basement.TlqException e) {
            logger.error(e.toString(), (Throwable)((Object)e));
            ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
            Hashtable<String, Integer> props = new Hashtable<String, Integer>();
            props.put("JMS_TONG_Status", new Integer(400));
            pkt.setProperties(props);
            pkt.setPacketType(msgOpt.OperateType);
            pkt.setConsumerID(Long.parseLong(msgOpt.AnsId));
            logger.warn("tlqException: packetType:{} , ackId:{}", new Integer(msgOpt.OperateType), (Object)msgOpt.AnsId);
            return pkt;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("jmsMessageRead AnsId:{} ConsumerId:{} opreateType:{} messageSum:{} continueSum:{} msgId:{},hexId:{},dest:{}", new Object[]{msgOpt.AnsId, msgOpt.ConsumerId, PacketType.getString(msgOpt.OperateType), new Long(this.messageSum), new Long(this.continueSum), tlqmsg.getMsgId(), new String(Hex.encodeHex(tlqmsg.getByteMsgId()))});
        }
        TlqCompositeMessage commsg = new TlqCompositeMessage();
        commsg.setTlqMessage(tlqmsg);
        commsg.setTlqMsgOpt(msgOpt);
        ReadWritePacket pkt = this.tlqmsgConvertJmsmsg(commsg, -1L);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_messageread");
        }
        return pkt;
    }

    public void openConnection() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("start call tlq's jms_conn");
        }
        if (this.serverDelegate == null) {
            this.serverDelegate = new LocalBasement();
        }
        this.gid = new TlqId();
        if (this.connQcuHandler == null) {
            this.connQcuHandler = new TlqQCUHdl();
            String qcuName = this.qcuName;
            if (logger.isTraceEnabled()) {
                logger.trace("qcuName {}", (Object)qcuName);
            }
            this.connQcuHandler.setQCUName(qcuName);
            this.serverDelegate.Jms_Conn(this.gid, this.connQcuHandler);
            this.readAckQcuHandler = (TlqQCUHdl)this.connQcuHandler.clone();
            this.readMessageQcuHandler = (TlqQCUHdl)this.connQcuHandler.clone();
            if (logger.isTraceEnabled()) {
                logger.trace("openConnection  gid:" + this.gid + "  qcuHandler:" + this.connQcuHandler);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("end of call tlq's jms_conn");
        }
    }

    public void closeConnection() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("start call tlq's jms_disconn ,gid ={},qcu={}", this.gid, (Object)this.connQcuHandler);
        }
        int res = this.serverDelegate.Jms_DisConn(this.gid, this.connQcuHandler);
        this.isDisConneted = true;
        hook.removeConnection(this);
        if (logger.isDebugEnabled()) {
            logger.debug("end of call tlq's jms_disconn");
        }
    }

    private void addConsumer(TlqCompositeMessage commsg, long txid) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_write, add consumer");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        long consumerId = Long.parseLong(msgopt.ConsumerId);
        TlqQCUHdl consumerQcuHandler = this.qcuTable.get(new Long(consumerId));
        if (logger.isDebugEnabled()) {
            logger.debug("addConsumer size: {} AnsId:{} ConsumerId:{} txid:{} quename:{} corrMsgId:{} selector:{}", new Object[]{new Integer(msgopt.GetMsgNum), msgopt.AnsId, msgopt.ConsumerId, new Integer(consumerQcuHandler.getTransId()), msgopt.QueName, tlqmsg.getCorrMsgId(), msgopt.Selector});
        }
        this.serverDelegate.Jms_Write(this.gid, consumerQcuHandler, tlqmsg, msgopt);
        this.continueSum += (long)msgopt.GetMsgNum;
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_write, add consumer");
        }
    }

    private void commitTransaction(TlqCompositeMessage commsg, long txid) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_commit");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        this.writeQcuHandler.setTransId((int)txid);
        if (logger.isDebugEnabled()) {
            logger.debug("commitTransaction AnsId:{}, txid:{}", (Object)msgopt.AnsId, (Object)new Long(txid));
        }
        this.serverDelegate.Jms_Commit(this.gid, this.writeQcuHandler, msgopt);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_commit,txid{}", txid);
        }
    }

    private void createDestination(TlqCompositeMessage commsg, boolean isQueue, boolean isTemp) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_getQue(Topic)");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isDebugEnabled()) {
            logger.debug("create Destination AnsId: {}, ConsumerId:{}", (Object)msgopt.ConsumerId, (Object)msgopt.AnsId);
        }
        if (isQueue) {
            if (logger.isDebugEnabled()) {
                logger.debug("create Queue isTemp: {},QueueName: {}", new Boolean(isTemp), (Object)msgopt.QueName);
            }
            if (isTemp) {
                TlqQueInfo queinfo = new TlqQueInfo();
                queinfo.QueueName = msgopt.QueName.getBytes();
                queinfo.QueueType = (char)76;
                queinfo.MsgNum = 100;
                queinfo.MsgSize = 1000;
                queinfo.QueSpaceSize = 0;
                queinfo.DataBuff = 100;
                queinfo.DefPriority = 4;
                queinfo.DefPersistence = 0;
                queinfo.MsgArrangeMode = 0;
                queinfo.UsageType = 0;
                queinfo.TrigType = (char)78;
                queinfo.TrigProgId = -1;
                queinfo.TrigAmount = 5;
                queinfo.TrigPara = null;
                this.serverDelegate.Jms_CreateTempQueue(this.gid, this.connQcuHandler, msgopt, queinfo, null);
            } else {
                this.serverDelegate.Jms_GetQue(this.gid, this.connQcuHandler, msgopt);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("create Topic isTemp: {},TopicName: {}", new Boolean(isTemp), (Object)msgopt.Topic);
            }
            if (isTemp) {
                this.serverDelegate.Jms_CreateTempTopic(this.gid, this.connQcuHandler, msgopt);
            } else {
                this.serverDelegate.Jms_GetTopic(this.gid, this.connQcuHandler, msgopt);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_getque(topic)");
        }
    }

    private void deleteConsumer(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_checkout, delete consumer");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isDebugEnabled()) {
            logger.debug("AnsId:{}, consumerid:{} quename:{}", new Object[]{msgopt.AnsId, msgopt.ConsumerId, msgopt.QueName});
        }
        long interestId = Long.parseLong(msgopt.ConsumerId);
        TlqQCUHdl consumerHandler = this.qcuTable.get(new Long(interestId));
        this.serverDelegate.Jms_CheckOut(this.gid, consumerHandler, msgopt);
        this.qcuTable.remove(new Long(interestId));
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_checkout, delete consumer");
        }
    }

    private void deleteProducer(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_checkout,delete producer");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        long interestId = Long.parseLong(msgopt.ConsumerId);
        TlqQCUHdl producerHandler = this.qcuTable.get(new Long(interestId));
        if (logger.isDebugEnabled()) {
            logger.debug("deleteProducer AnsId:{}, consumerid:{}", (Object)msgopt.AnsId, (Object)msgopt.ConsumerId);
        }
        this.serverDelegate.Jms_CheckOut(this.gid, producerHandler, msgopt);
        this.qcuTable.remove(new Long(interestId));
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_out, delete producer");
        }
    }

    private void deliver(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's Jms_Deliever");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        this.serverDelegate.Jms_Deliever(this.gid, this.connQcuHandler, msgopt, new String(tlqmsg.getMsgData()));
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's Jms_Deliever");
        }
    }

    private void destroyDestination(TlqCompositeMessage commsg, boolean isQueue) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's Jms_DeleteTempQueue(Topic)");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isDebugEnabled()) {
            logger.debug("create Destination AnsId: {}, ConsumerId:{}", (Object)msgopt.ConsumerId, (Object)msgopt.AnsId);
        }
        if (isQueue) {
            this.serverDelegate.Jms_DeleteTempQueue(this.gid, this.connQcuHandler, msgopt, msgopt.QueName, 1);
        } else {
            this.serverDelegate.Jms_DeleteTempTopic(this.gid, this.connQcuHandler, msgopt);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's Jms_DeleteTempQueue(Topic)");
        }
    }

    private void prepareTransaction(TlqCompositeMessage commsg) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void rollbackTransacation(TlqCompositeMessage commsg, long txid) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_rollback");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isDebugEnabled()) {
            logger.debug("rollbackTranscation :txid{}", new Long(txid));
        }
        this.writeQcuHandler.setTransId((int)txid);
        this.serverDelegate.Jms_Rollback(this.gid, this.writeQcuHandler, msgopt);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_rollback");
        }
    }

    private void start(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_start");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isDebugEnabled()) {
            logger.debug("start AnsId:" + msgopt.AnsId + "     connQcuHandler:" + this.connQcuHandler + " gid:" + this.gid);
        }
        this.serverDelegate.Jms_Start(this.gid, this.connQcuHandler, msgopt);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_start");
        }
    }

    private void startTransaction(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_begin");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        if (logger.isDebugEnabled()) {
            logger.debug("startTransaction AnsId:{} writeQcuHandler:{}", (Object)msgopt.AnsId, (Object)this.writeQcuHandler);
        }
        this.writeQcuHandler.setTransId(-1);
        try {
            this.serverDelegate.Jms_Begin(this.gid, this.writeQcuHandler, msgopt);
        }
        catch (Exception e) {
            logger.error(e.toString(), e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_begin, txid:{}", this.writeQcuHandler.getTransId());
        }
    }

    private void stop(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_stop");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        this.serverDelegate.Jms_Stop(this.gid, this.connQcuHandler, msgopt);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_stop");
        }
    }

    private TlqCompositeMessage jmsmsgConvertTlqmsg(ReadWritePacket pkt) throws Exception {
        TlqCompositeMessage compmsg = new TlqCompositeMessage();
        TlqMessage msg = new TlqMessage();
        TlqMsgOpt msgopt = new TlqMsgOpt();
        try {
            switch (pkt.getPacketType()) {
                case 24: 
                case 32: {
                    msgopt.AckMode = '\u0000';
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    if (!pkt.getIsQueue()) {
                        msgopt.ConsumerId = String.valueOf(pkt.getConsumerID());
                        msgopt.QueName = pkt.getSubQueue();
                    } else {
                        msgopt.QueName = pkt.getDestination();
                    }
                    String s = pkt.getMessageID();
                    if (logger.isDebugEnabled()) {
                        logger.debug("ackMsg: {},consumerId :{}", (Object)s, (Object)new Long(msgopt.ConsumerId));
                    }
                    if (s.startsWith("__TONGTECH__") && s.endsWith("__:ID:__")) {
                        String encoderStr = s.substring("__TONGTECH__".length(), s.length() - "__:ID:__".length());
                        if (logger.isDebugEnabled()) {
                            logger.debug("IBMMQ ackMsg: {}", (Object)encoderStr);
                        }
                        msg.setMsgId(Hex.decodeHex(encoderStr.toCharArray()));
                    } else {
                        msg.setMsgId(pkt.getMessageID());
                    }
                    msg.SrcNode = pkt.getSrcNode();
                    if (logger.isTraceEnabled()) {
                        logger.trace("getDestination:{}, srcNode:{}", (Object)pkt.getDestination(), (Object)msg.SrcNode);
                    }
                    break;
                }
                case 117: 
                case 200: {
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    msgopt.ConsumerId = String.valueOf(pkt.getProducerID());
                    if (pkt.getProperties() != null) {
                        msgopt.JmsSessionId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_SessionID"));
                    }
                    break;
                }
                case 118: 
                case 201: 
                case 202: {
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    msgopt.ConsumerId = String.valueOf(pkt.getProducerID());
                    break;
                }
                case 210: {
                    msgopt.OperateType = 5;
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    msgopt.Topic = pkt.getDestination();
                    msgopt.PubSubScope = (char)3;
                    String durableName = (String)pkt.getProperties().get("JMS_TONG_DurableName");
                    String clientId = (String)pkt.getProperties().get("JMS_TONG_ClientID");
                    if (durableName != null) {
                        msg.Persistence = '\u0001';
                        msg.setMsgData((clientId + durableName).getBytes());
                    } else {
                        msg.Persistence = '\u0000';
                    }
                    msgopt.QueName = pkt.getSubQueue();
                    if (pkt.getProperties() != null) {
                        msgopt.ConsumerId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_ConsumerID"));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("sub Message,topic:{} destQName:{}", (Object)msgopt.Topic, (Object)msg.DestQName);
                    }
                    break;
                }
                case 211: {
                    msgopt.OperateType = 6;
                    msgopt.PubSubScope = (char)3;
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    String dName = (String)pkt.getProperties().get("JMS_TONG_DurableName");
                    String cId = (String)pkt.getProperties().get("JMS_TONG_ClientID");
                    msg.setMsgData((cId + dName).getBytes());
                    if (logger.isTraceEnabled()) {
                        logger.trace("unsubsribe,clientId:{},durableName:{}", (Object)cId, (Object)dName);
                    }
                    break;
                }
                case 14: {
                    msgopt.AckMode = '\u0000';
                    msgopt.OperateType = 0;
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    if (pkt.getIsQueue()) {
                        msgopt.QueName = pkt.getDestination();
                    } else {
                        msgopt.QueName = pkt.getSubQueue();
                        if (logger.isTraceEnabled()) {
                            logger.trace("topic destination:{},topic quename:{}", (Object)pkt.getDestination(), (Object)msgopt.QueName);
                        }
                        msgopt.Topic = pkt.getDestination();
                        msgopt.MatchOption = 2;
                        msg.setCorrMsgId(pkt.getFixedMessageID());
                        if (logger.isTraceEnabled()) {
                            logger.trace("add consumer, corrMsgId:{}", (Object)msg.getCorrMsgId());
                        }
                    }
                    if (pkt.getProperties() != null) {
                        msgopt.setSelector((String)pkt.getProperties().get("JMS_TONG_Selector"));
                        if (logger.isTraceEnabled()) {
                            logger.trace("Selector:{},  SelectorLen:{}", (Object)msgopt.getSelector(), (Object)new Integer(msgopt.getSelectorLen()));
                        }
                        msgopt.JmsSessionId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_SessionID"));
                        msgopt.ConsumerId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_ConsumerID"));
                        msgopt.GetMsgNum = (Integer)pkt.getProperties().get("JMS_TONG_Size");
                        msg.setUserProperties(pkt.getProperties());
                    }
                    msg.parsePropertiesByte();
                    break;
                }
                case 16: 
                case 42: {
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    msgopt.ConsumerId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_ConsumerID"));
                    msg.setUserProperties(pkt.getProperties());
                    msgopt.QueName = (String)pkt.getProperties().get("JMS_TONG_Destination");
                    msg.setMsgData(pkt.getMessageBody());
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    long exprit;
                    if (pkt.getPacketType() == 7) {
                        Object removeFlag;
                        msg.MsgType = '\u0001';
                        if (pkt.getProperties() != null && (removeFlag = pkt.getProperties().get("JMS_TONG_Removefile")) != null && ((Boolean)removeFlag).booleanValue()) {
                            msgopt.RemoveFileFlag = '\u0001';
                        }
                    }
                    if (pkt.getProperties() != null) {
                        Object usrContext = pkt.getProperties().get("JMS_TONG_UsrContext");
                        if (usrContext != null) {
                            msg.setUsrContext(((String)usrContext).getBytes("GB2312"));
                        }
                        pkt.getProperties().remove("JMS_TONG_UsrContext");
                    }
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    long producerId = pkt.getProducerID();
                    msgopt.setProducerId(producerId);
                    if (pkt.getIsQueue()) {
                        msgopt.OperateType = 2;
                        msgopt.QueName = pkt.getDestination();
                    } else {
                        String subQueue;
                        msgopt.OperateType = 3;
                        msgopt.Topic = pkt.getDestination();
                        String pubQueue = pkt.getPubQueue();
                        if (pubQueue != null && !pubQueue.equals("")) {
                            msgopt.QueName = pubQueue;
                        }
                        if ((subQueue = pkt.getSubQueue()) != null && !subQueue.equals("")) {
                            msg.DestQName = subQueue;
                        }
                        msgopt.PubSubScope = (char)3;
                        if (logger.isTraceEnabled()) {
                            logger.trace("msgopt.QueName:{}  msg.DestQName:{}", (Object)msgopt.QueName, (Object)msg.DestQName);
                        }
                    }
                    if (pkt.getProperties() != null) {
                        msg.setUserProperties(pkt.getProperties());
                    }
                    exprit = (exprit = (pkt.getTimeToLive() - 1L) / 1000L + 1L) < 3L ? 3L : exprit;
                    msg.Expiry = (int)(pkt.getTimeToLive() == 0L ? -1L : exprit);
                    msg.Priority = (char)pkt.getPriority();
                    msg.MsgSize = pkt.getMessageBodyLength();
                    msg.Persistence = pkt.getPersistent() ? (char)'\u0001' : '\u0000';
                    msg.PutDateTime = (int)pkt.getTimestamp();
                    msg.setCorrMsgId(pkt.getCorrelationID());
                    if (pkt.getMessageBody() == null || pkt.getMessageBody().length == 0) {
                        msg.setMsgData(null);
                    } else {
                        msg.setMsgData(pkt.getMessageBody());
                    }
                    if (pkt.getProperties() != null) {
                        if (pkt.getProperties().get("JMSXGroupID") != null) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("========pkt.getProperties().get(JMSXGroupID is  null");
                            }
                            msg.GroupID = (String)pkt.getProperties().get("JMSXGroupID");
                        }
                        if (pkt.getProperties().get("JMSXGroupSeq") != null) {
                            msg.GroupSeq = (Integer)pkt.getProperties().get("JMSXGroupSeq");
                        }
                    }
                    msg.setStringProperty("JMSCorrelationID", pkt.getCorrelationID());
                    msg.setBooleanProperty("JMSRedelivered", pkt.getRedelivered());
                    msg.setStringProperty("JMSType", pkt.getMessageType());
                    msg.setLongProperty("JMSTimestamp", pkt.getTimestamp());
                    msg.setStringProperty("JMSMessageID", pkt.getMessageID());
                    msg.setStringProperty("JMSReplyTo", pkt.getReplyTo());
                    msg.setLongProperty("JMSExpiration", pkt.getExpiration());
                    msg.setStringProperty("JMSDestination", pkt.getDestination());
                    msg.setIntProperty("JMSPriority", pkt.getPriority());
                    if (pkt.getPersistent()) {
                        msg.setIntProperty("JMSDeliveryMode", 2);
                    } else {
                        msg.setIntProperty("JMSDeliveryMode", 1);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("JMS_TONG_MessageType:" + pkt.getPacketType());
                    }
                    msg.setIntProperty("JMS_TONG_MessageType", pkt.getPacketType());
                    msg.setStringProperty("JMS_TONG_ReplyToClass", pkt.getReplyToClass());
                    msg.pack();
                    msg.parsePropertiesByte();
                    break;
                }
                case 34: {
                    if (pkt.getIsQueue()) {
                        msgopt.QueName = pkt.getDestination();
                    } else {
                        msgopt.Topic = pkt.getDestination();
                    }
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    break;
                }
                case 66: {
                    msgopt.ConsumerId = String.valueOf(pkt.getProducerID());
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    break;
                }
                case 65: {
                    msgopt.OperateType = 0;
                    msgopt.ConsumerId = String.valueOf(pkt.getConsumerID());
                    if (pkt.getIsQueue()) {
                        msgopt.QueName = pkt.getDestination();
                    } else {
                        msgopt.Topic = pkt.getDestination();
                    }
                    msgopt.GetMsgNum = (Integer)pkt.getProperties().get("JMS_TONG_Size");
                    break;
                }
                case 26: {
                    msgopt.OperateType = 1;
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    msgopt.ConsumerId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_ConsumerID"));
                    msgopt.QueName = (String)pkt.getProperties().get("JMS_TONG_Destination");
                    String selector = (String)pkt.getProperties().get("JMS_TONG_Selector");
                    if (selector != null) {
                        msgopt.setSelector(selector);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Selector:{},  SelectorLen:{}", (Object)msgopt.getSelector(), (Object)new Integer(msgopt.getSelectorLen()));
                        }
                    }
                    msg.setUserProperties(pkt.getProperties());
                    break;
                }
                case 36: {
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    msgopt.QueName = (String)pkt.getProperties().get("JMS_TONG_Destination");
                    if (pkt.getIsQueue()) {
                        msgopt.QueName = pkt.getDestination();
                        break;
                    }
                    msgopt.Topic = pkt.getDestination();
                    break;
                }
                case 44: {
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    if (pkt.getProperties() != null) {
                        msgopt.JmsSessionId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_SessionID"));
                    }
                    break;
                }
                case 22: {
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    if (pkt.getProperties() != null) {
                        msg.setUserProperties(pkt.getProperties());
                        msgopt.JmsSessionId = String.valueOf((Long)pkt.getProperties().get("JMS_TONG_SessionID"));
                        break;
                    }
                    msgopt.JmsSessionId = "-1";
                    break;
                }
                default: {
                    msgopt.OperateType = pkt.getPacketType();
                    msgopt.AnsId = String.valueOf(pkt.getConsumerID());
                    if (pkt.getProperties() != null) {
                        msg.setUserProperties(pkt.getProperties());
                    }
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JMSException exception = new JMSException("Error: The user properties is too long !");
            throw exception;
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace(e.toString(), e);
            }
            throw e;
        }
        compmsg.setTlqMessage(msg);
        compmsg.setTlqMsgOpt(msgopt);
        return compmsg;
    }

    private void subMessage(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_write, subscriber message");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        long consumerId = Long.parseLong(msgopt.ConsumerId);
        TlqQCUHdl consumerQcuHandler = this.qcuTable.get(new Long(consumerId));
        if (tlqmsg.Persistence == '\u0001') {
            tlqmsg.setSubFlag('\u0001');
        }
        if (logger.isDebugEnabled()) {
            logger.debug("subMessage: corrMsgid:{}", (Object)tlqmsg.getCorrMsgId());
        }
        this.serverDelegate.Jms_Write(this.gid, consumerQcuHandler, tlqmsg, msgopt);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_write, subscriber message");
        }
    }

    private ReadWritePacket tlqmsgConvertJmsmsg(TlqCompositeMessage commsg, long txid) throws Exception {
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        TlqMessage msg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        int packetType = commsg.getPacketType();
        pkt.setPacketType(packetType);
        pkt.setConsumerID(Long.parseLong(msgopt.AnsId.equals("") ? "0" : msgopt.AnsId));
        try {
            switch (packetType) {
                case 16: 
                case 42: {
                    Hashtable ht = msg.getUserProperties();
                    ht.put("JMS_TONG_ConsumerID", msgopt.ConsumerId);
                    pkt.setProperties(ht);
                    break;
                }
                case 1: 
                case 168: {
                    msg.parseProperties();
                    if (msgopt.AnsId.equals(MESSAGE_FLAG)) {
                        boolean fromJms = this.isFromJms(msg, msgopt);
                        if (fromJms) {
                            msg.unpack();
                            pkt.setPacketType((Integer)msg.getUserProperties().get("JMS_TONG_MessageType"));
                            pkt.setExpiration((Long)msg.getUserProperties().get("JMSExpiration"));
                            pkt.setPriority(msg.Priority);
                            pkt.setMessageID(msg.getMsgId());
                            pkt.setTimestamp((Long)msg.getUserProperties().get("JMSTimestamp"));
                            pkt.setMessageType((String)msg.getUserProperties().get("JMSType"));
                            if (msg.SubFlag == '\u0001') {
                                pkt.setDestination((String)msg.getUserProperties().get("JMSDestination"));
                                pkt.setSubQueue(msgopt.QueName);
                                pkt.setIsQueue(false);
                                pkt.setDestinationClass("com.tongtech.tmqi.Topic");
                            } else {
                                pkt.setDestination(msgopt.QueName);
                                pkt.setIsQueue(true);
                                pkt.setDestinationClass("com.tongtech.tmqi.Queue");
                            }
                            if (msg.getUserProperties().get("JMSReplyTo") != null) {
                                pkt.setReplyTo((String)msg.getUserProperties().get("JMSReplyTo"));
                            }
                            if (msg.getUserProperties().get("JMS_TONG_ReplyToClass") != null) {
                                pkt.setReplyToClass((String)msg.getUserProperties().get("JMS_TONG_ReplyToClass"));
                            }
                            if (msg.Persistence == '\u0001') {
                                pkt.setPersistent(true);
                            } else {
                                pkt.setPersistent(false);
                            }
                            if (msg.getUserProperties().get("JMSCorrelationID") != null) {
                                pkt.setCorrelationID((String)msg.getUserProperties().get("JMSCorrelationID"));
                            }
                            pkt.setSrcNode(msg.SrcNode);
                            logger.debug("TlqWrapper srcNode:{},queName:{},destQname:{}", new Object[]{pkt.getSrcNode(), msgopt.QueName, msg.DestQName});
                            if (msg.MsgSize == 0 || msg.getMsgData() == null || msg.getMsgData().length == 0) {
                                pkt.setMessageBody(null);
                            } else {
                                pkt.setMessageBody(msg.getMsgData());
                            }
                            Hashtable msght = msg.getUserProperties();
                            pkt.setConsumerID(Long.parseLong(msgopt.ConsumerId));
                            msght.put("JMS_TONG_ConsumerID", msgopt.ConsumerId);
                            msght.put("JMS_TONG_Status", new Integer(200));
                            if (msg.getUsrContext() != null) {
                                String usrContext = null;
                                try {
                                    usrContext = new String(msg.getUsrContext(), "GB2312");
                                }
                                catch (UnsupportedEncodingException e) {
                                    usrContext = new String(msg.getUsrContext());
                                }
                                msght.put("JMS_TONG_UsrContext", usrContext);
                            }
                            pkt.setProperties(msght);
                            if (msg.SubFlag == '\u0001') {
                                pkt.setFlag(32, true);
                            }
                            if (pkt.getPacketType() == 7) {
                                msght.put("JMS_TONG_RENAME_FLAG", new Boolean(msg.RenamedFlag == '\u0001'));
                            }
                            break;
                        }
                        this.handleCPkt(pkt, msg, msgopt);
                        break;
                    }
                    if (168 == pkt.getPacketType()) {
                        Hashtable htdeliReply = msg.getUserProperties();
                        htdeliReply.put("JMS_TONG_ConsumerID", msgopt.ConsumerId);
                        htdeliReply.put("JMS_TONG_Status", new Integer(200));
                        pkt.setProperties(htdeliReply);
                        break;
                    }
                    pkt.setPacketType(15);
                    if (msgopt.QueName == null) {
                        pkt.setDestination(msgopt.Topic);
                    } else {
                        pkt.setDestination(msgopt.QueName);
                    }
                    Hashtable htconsumer = msg.getUserProperties();
                    htconsumer.put("JMS_TONG_ConsumerID", msgopt.ConsumerId);
                    htconsumer.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(htconsumer);
                    break;
                }
                case 7: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("jms read,subMessage ,msgId:{},CorrMsgId:{}", (Object)msg.getMsgId(), (Object)(msg.getCorrMsgId() + msg.getCorrMsgId().length()));
                    }
                    pkt.setPacketType(210);
                    pkt.setFixedMessageID(msg.getCorrMsgId());
                    Hashtable<String, Integer> subht = new Hashtable<String, Integer>();
                    subht.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(subht);
                    break;
                }
                case 0: {
                    pkt.setMessageID(msg.getMsgId());
                    if (logger.isDebugEnabled()) {
                        logger.debug("pkt's msgid: {} ", (Object)pkt.getMessageID());
                    }
                    Hashtable<String, Integer> replyht = new Hashtable<String, Integer>();
                    replyht.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(replyht);
                    break;
                }
                case 126: {
                    Hashtable<String, Number> props = new Hashtable<String, Number>();
                    props.put("JMS_TONG_Status", new Integer(200));
                    long id = txid;
                    if (id < 0L) {
                        throw new Exception("get error tlq's txid: " + id);
                    }
                    props.put("JMS_TONG_TransactionID", new Long(id));
                    pkt.setProperties(props);
                    break;
                }
                case 125: {
                    pkt.setPacketType(packetType);
                    Hashtable<String, Integer> acktemp = new Hashtable<String, Integer>();
                    acktemp.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(acktemp);
                    break;
                }
                case 118: {
                    pkt.setPacketType(packetType);
                    Hashtable<String, Integer> deletetemp = new Hashtable<String, Integer>();
                    deletetemp.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(deletetemp);
                    break;
                }
                case 120: {
                    Hashtable<String, Integer> stopht = new Hashtable<String, Integer>();
                    stopht.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(stopht);
                    break;
                }
                case 157: 
                case 162: 
                case 177: 
                case 213: {
                    pkt.setPacketType(157);
                    Hashtable<String, Integer> destht = new Hashtable<String, Integer>();
                    destht.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(destht);
                    break;
                }
                case 160: {
                    Hashtable<String, Integer> byeht = new Hashtable<String, Integer>();
                    byeht.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(byeht);
                    break;
                }
                case 137: {
                    pkt.setConsumerID(Long.parseLong(msgopt.ConsumerId));
                    break;
                }
                case 123: {
                    Hashtable<String, Object> broht = new Hashtable<String, Object>();
                    broht.put("JMS_TONG_Status", new Integer(200));
                    broht.put("JMS_TONG_ConsumerID", msgopt.ConsumerId);
                    pkt.setProperties(broht);
                    if (msg.MsgSize == 0 || msg.getMsgData() == null || msg.getMsgData().length == 0) {
                        pkt.setMessageBody(null);
                        break;
                    }
                    pkt.setMessageBody(msg.getMsgData());
                    break;
                }
                case 180: 
                case 216: {
                    pkt.setPacketType(37);
                    Hashtable<String, Integer> delht = new Hashtable<String, Integer>();
                    delht.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(delht);
                    break;
                }
                case 8: {
                    if (msg.getUserProperties() != null && msg.getUserProperties().size() != 0) {
                        pkt.setProperties(msg.getUserProperties());
                        break;
                    }
                    Hashtable<String, Integer> unSubht = new Hashtable<String, Integer>();
                    unSubht.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(unSubht);
                    break;
                }
                default: {
                    Hashtable<String, Integer> temp = new Hashtable<String, Integer>();
                    temp.put("JMS_TONG_Status", new Integer(200));
                    pkt.setProperties(temp);
                }
            }
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("tlq-->jms failed", e);
            }
            throw e;
        }
        return pkt;
    }

    private void tlqAcknowledge(TlqCompositeMessage commsg, long txid, int ackMode) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_ackmsg");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        msgopt.AckMode = '\u0000';
        this.writeQcuHandler.setTransId((int)txid);
        if (logger.isDebugEnabled()) {
            logger.debug("ackMsg:  queName {}, messageid {}, hexId:{},txid {},ackMode {},consumerid {} ", new Object[]{msgopt.QueName, tlqmsg.getMsgId(), new String(Hex.encodeHex(tlqmsg.getByteMsgId())), new Long(txid), new Integer(ackMode), msgopt.ConsumerId});
        }
        this.serverDelegate.Jms_AckMsg(this.gid, this.writeQcuHandler, tlqmsg, msgopt, ackMode);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_ackmsg");
        }
    }

    private void verifyDestination(TlqCompositeMessage commsg) {
    }

    private void brower(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's browser");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        this.serverDelegate.Jms_Write(this.gid, this.writeQcuHandler, tlqmsg, msgopt);
    }

    private void goodbye(TlqCompositeMessage commsg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_goodbye");
        }
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        this.serverDelegate.Jms_GoodBye(this.gid, this.connQcuHandler, msgopt);
        this.isDisConneted = true;
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_goodbye");
        }
    }

    private void writeJmsMessage(TlqCompositeMessage commsg, long txid) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("start call tlq's jms_write, send message");
        }
        TlqMessage tlqmsg = commsg.getTlqMessage();
        TlqMsgOpt msgopt = commsg.getTlqMsgOpt();
        this.writeQcuHandler.setTransId((int)txid);
        if (logger.isTraceEnabled()) {
            logger.trace("writeJmsMessage AnsId:{},ConsumerId:{} topic:{}  txid:{} msgopt.QueName:{}  tlqmsg.DestQName:{} PubSubScope:{} msgSize:{} expiry:{}", new Object[]{msgopt.AnsId, msgopt.ConsumerId, msgopt.Topic, new Long(txid), msgopt.QueName, tlqmsg.DestQName, new Integer(msgopt.PubSubScope), new Integer(tlqmsg.MsgSize), new Integer(tlqmsg.Expiry)});
        }
        this.serverDelegate.Jms_Write(this.gid, this.writeQcuHandler, tlqmsg, msgopt);
        if (logger.isTraceEnabled()) {
            logger.trace("end of call tlq's jms_write, send message");
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        isLoggedVersion = false;
    }
}

