/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.transport.httptunnel;

import com.tongtech.jms.transport.httptunnel.HttpLongLiveInputStream;
import com.tongtech.jms.transport.httptunnel.HttpLongLiveOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class HTTPLongLiveSocket {
    private InputStream is;
    private OutputStream os;
    private boolean sockClosed;
    private URL connUrl;

    public HTTPLongLiveSocket(String uRLString) throws IOException {
        this.connUrl = new URL(uRLString);
        this.init();
    }

    private void init() throws IOException {
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.is == null) {
            this.is = new HttpLongLiveInputStream(this.connUrl);
        }
        return this.is;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.os == null) {
            this.os = new HttpLongLiveOutputStream(this.connUrl);
        }
        return this.os;
    }

    public synchronized void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        this.sockClosed = true;
    }

    public int getConnId() {
        return 0;
    }
}

