/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.transport.httptunnel;

import com.tongtech.jms.transport.httptunnel.HttpTunnelConnection;
import com.tongtech.jms.transport.httptunnel.HttpTunnelInputStream;
import com.tongtech.jms.transport.httptunnel.HttpTunnelOutputStream;
import com.tongtech.jms.transport.httptunnel.client.HttpTunnelClientDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class HttpTunnelSocket {
    private HttpTunnelConnection conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean sockClosed = false;

    public HttpTunnelSocket(String serverAddr) throws IOException {
        HttpTunnelClientDriver wire = new HttpTunnelClientDriver(serverAddr);
        this.conn = wire.doConnect();
        this.initSocket();
    }

    protected HttpTunnelSocket(HttpTunnelConnection conn) {
        this.conn = conn;
        this.initSocket();
    }

    protected void initSocket() {
        this.is = null;
        this.os = null;
        this.sockClosed = false;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.is == null) {
            this.is = new HttpTunnelInputStream(this.conn);
        }
        return this.is;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.os == null) {
            this.os = new HttpTunnelOutputStream(this.conn);
        }
        return this.os;
    }

    public synchronized void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        this.sockClosed = true;
        this.conn.closeConn();
    }

    public int getConnId() {
        return this.conn.getConnId();
    }

    public InetAddress getRemoteAddress() throws UnknownHostException, SecurityException {
        HttpTunnelConnection c = this.conn;
        if (c == null || c.getRemoteAddr() == null) {
            return null;
        }
        return InetAddress.getByName(c.getRemoteAddr());
    }

    public int getPullPeriod() {
        return this.conn.getPullPeriod();
    }

    public void setPullPeriod(int pullPeriod) throws IOException {
        this.conn.setPullPeriod(pullPeriod);
    }

    public int getConnectionTimeout() {
        return this.conn.getConnectionTimeout();
    }

    public void setConnectionTimeout(int connectionTimeout) throws IOException {
        this.conn.setConnectionTimeout(connectionTimeout);
    }

    public Hashtable getDebugState() {
        return this.conn.getDebugState();
    }
}

