/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.transport.httptunnel.test;

import com.tongtech.jms.transport.httptunnel.HttpTunnelSocket;
import com.tongtech.jms.transport.httptunnel.test.RandomBytes;
import java.io.InputStream;
import java.io.ObjectInputStream;

class Reader
extends Thread {
    private HttpTunnelSocket s = null;
    private InputStream is = null;
    private static int VERBOSITY = Integer.getInteger("test.verbosity", 0);
    private static int MAX = Integer.getInteger("test.max", -1);
    private static int PULLPERIOD = Integer.getInteger("test.pullperiod", -1);

    public Reader(HttpTunnelSocket s) {
        this.s = s;
        try {
            s.setPullPeriod(PULLPERIOD);
            this.is = s.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            ObjectInputStream dis = new ObjectInputStream(this.is);
            int n = 0;
            while (MAX < 0 || n < MAX) {
                RandomBytes rb = (RandomBytes)dis.readObject();
                boolean valid = rb.isValid();
                int seq = rb.getSequence();
                if (seq != n) {
                    System.out.println("#### PACKET OUT OF SEQUENCE ####");
                    return;
                }
                if (VERBOSITY > 0) {
                    System.out.println("#### Received packet #" + seq);
                }
                if (VERBOSITY > 1) {
                    byte[] tmp = rb.getData();
                    int len = tmp.length > 64 ? 64 : tmp.length;
                    System.out.println("Bytes = " + new String(tmp, 1, len - 1));
                    System.out.println("Length = " + (tmp.length - 1));
                    System.out.println("Checksum = " + rb.getChecksum());
                    System.out.println("Computed checksum = " + RandomBytes.computeChecksum(tmp));
                    System.out.println("rb.isValid() = " + valid);
                    System.out.println();
                }
                if (!valid) {
                    System.out.println("#### CHECKSUM ERROR DETECTED ####");
                    return;
                }
                if (++n % 100 != 0) continue;
                System.out.println("#### Free memory = " + Runtime.getRuntime().freeMemory());
                System.out.println("#### Total memory = " + Runtime.getRuntime().totalMemory());
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("#### Reader exiting...");
    }
}

