/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.util;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.MessageIDWriter;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.QueueBrowserImpl;
import com.tongtech.tmqi.jmsclient.StreamHandler;
import com.tongtech.tmqi.jmsclient.UnifiedReadChannel;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Queue;

public class InjectorUtil {
    private static boolean isInited = false;
    static Logger logger = LoggerFactory.getLogger(InjectorUtil.class);
    public static final int PROTOCOL_TYPE_TLQ_LOCAL = 1;
    public static final int PROTOCOL_TYPE_TLQ_REMOTE = 2;
    public static final int PROTOCOL_TYPE_TLQ_HTTP = 3;
    static Properties protocolXmlProps = new Properties();
    private static Class readWritePacketLocalClass = null;
    private static Class protocolHandlerLocalClass = null;
    private static Class readChannelLocalClass = null;
    private static Class streamHandlerLocalClass = null;
    private static Class mqAddressLocalClass = null;
    private static Class msgIDWriterLocalClass = null;
    private static MessageIDWriter messageIDWriterLocal = null;
    private static Class browserConsumerLocal = null;
    private static Class readWritePacketRemoteClass = null;
    private static Class protocolHandlerRemoteClass = null;
    private static Class readChannelRemoteClass = null;
    private static Class streamHandlerRemoteClass = null;
    private static Class streamHandlerHTTPClass = null;
    private static Class mqAddressRemoteClass = null;
    private static Class msgIDWriterRemoteClass = null;
    private static MessageIDWriter messageIDWriterRemote = null;
    private static Class browserConsumerRemote = null;

    public static void init() {
        if (isInited) {
            return;
        }
        try {
            readChannelLocalClass = Class.forName("com.tongtech.jmsclient.TlqLocalReadChannel");
            readWritePacketLocalClass = Class.forName("com.tongtech.jms.protocol.TlqLocalReadWritePacket");
            protocolHandlerLocalClass = Class.forName("com.tongtech.jms.protocol.TlqLocalProtocolHandler");
            streamHandlerLocalClass = Class.forName("com.tongtech.jms.protocol.io.TlqLocalStreamHandler");
            mqAddressLocalClass = Class.forName("com.tongtech.jms.protocol.io.TlqLocalMQAddress");
            msgIDWriterLocalClass = Class.forName("com.tongtech.jmsclient.TlqLocalMessageIDWriter");
            browserConsumerLocal = Class.forName("com.tongtech.tmqi.jmsclient.LocalBrowserConsumer");
            readChannelRemoteClass = Class.forName("com.tongtech.jmsclient.TlqRemoteReadChannel");
            readWritePacketRemoteClass = Class.forName("com.tongtech.jms.protocol.TlqRemoteReadWritePacket");
            protocolHandlerRemoteClass = Class.forName("com.tongtech.jms.protocol.TlqRemoteProtocolHandler");
            streamHandlerRemoteClass = Class.forName("com.tongtech.jms.protocol.io.TlqRemoteStreamHandler");
            streamHandlerHTTPClass = Class.forName("com.tongtech.jms.protocol.http.HTTPStreamHandler");
            mqAddressRemoteClass = Class.forName("com.tongtech.jms.protocol.io.TlqRemoteMQAddress");
            msgIDWriterRemoteClass = Class.forName("com.tongtech.jmsclient.TlqRemoteMessageIDWriter");
            browserConsumerRemote = Class.forName("com.tongtech.tmqi.jmsclient.RemoteBrowserConsumer");
            messageIDWriterLocal = (MessageIDWriter)msgIDWriterLocalClass.newInstance();
            messageIDWriterRemote = (MessageIDWriter)msgIDWriterRemoteClass.newInstance();
            isInited = true;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("get class " + e.getMessage() + "fail.");
        }
    }

    public static UnifiedReadChannel createReadChannel(int type) {
        UnifiedReadChannel readChannel = null;
        try {
            if (type == 1) {
                readChannel = (UnifiedReadChannel)readChannelLocalClass.newInstance();
            } else if (type == 2 || type == 3) {
                readChannel = (UnifiedReadChannel)readChannelRemoteClass.newInstance();
            }
            return readChannel;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("instance class " + e.getMessage() + " fail.");
        }
    }

    public static ReadWritePacket createReadWritePacket(int type) {
        ReadWritePacket pkt = null;
        try {
            if (type == 1) {
                pkt = (ReadWritePacket)readWritePacketLocalClass.newInstance();
            } else if (type == 2 || type == 3) {
                pkt = (ReadWritePacket)readWritePacketRemoteClass.newInstance();
            }
            return pkt;
        }
        catch (Exception e) {
            logger.error("create ReadWritePacket fail.", e);
            throw new RuntimeException("instance class " + e.getMessage() + " fail.");
        }
    }

    public static ProtocolHandler createProtocolHandle(int type) {
        ProtocolHandler protocolHandler = null;
        try {
            if (type == 1) {
                protocolHandler = (ProtocolHandler)protocolHandlerLocalClass.newInstance();
            } else if (type == 2 || type == 3) {
                protocolHandler = (ProtocolHandler)protocolHandlerRemoteClass.newInstance();
            }
            return protocolHandler;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("instance class " + e.getMessage() + " fail.");
        }
    }

    public static StreamHandler createStreamHandler(int type) {
        StreamHandler streamHandler = null;
        try {
            if (type == 1) {
                streamHandler = (StreamHandler)streamHandlerLocalClass.newInstance();
            } else if (type == 2) {
                streamHandler = (StreamHandler)streamHandlerRemoteClass.newInstance();
            } else if (type == 3) {
                streamHandler = (StreamHandler)streamHandlerHTTPClass.newInstance();
            }
            return streamHandler;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("instance class " + e.getMessage() + " fail.");
        }
    }

    public static MQAddress createMQAddress(int type) {
        MQAddress mqAddress = null;
        try {
            if (type == 1) {
                mqAddress = (MQAddress)mqAddressRemoteClass.newInstance();
            } else if (type == 2 || type == 3) {
                mqAddress = (MQAddress)mqAddressRemoteClass.newInstance();
            }
            return mqAddress;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("instance class " + e.getMessage() + " fail.");
        }
    }

    public static MQAddress createMQAddress() {
        MQAddress mqAddress = null;
        try {
            mqAddress = (MQAddress)mqAddressRemoteClass.newInstance();
            return mqAddress;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("instance class " + e.getMessage() + " fail.");
        }
    }

    public static MessageIDWriter createMessageIDWriter(int type) {
        try {
            if (type == 1) {
                return messageIDWriterLocal;
            }
            if (type == 2 || type == 3) {
                return messageIDWriterRemote;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("instance class " + e.getMessage() + " fail.");
        }
    }

    public static BrowserConsumer createBrowserConsumer(int type, QueueBrowserImpl queueBrowserImpl, Queue queue, String selector) {
        Class clazz = null;
        if (type == 1) {
            clazz = browserConsumerLocal;
        } else if (type == 2) {
            clazz = browserConsumerRemote;
        }
        try {
            Constructor constructor = clazz.getConstructor(QueueBrowserImpl.class, Destination.class, String.class);
            return (BrowserConsumer)constructor.newInstance(queueBrowserImpl, queue, selector);
        }
        catch (Exception e) {
            throw new RuntimeException("instance class " + clazz + " fail.");
        }
    }
}

