/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.jms.protocol.TlqRemoteReadWritePacket;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class PartialMessageDebugThread
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(PartialMessageDebugThread.class);
    private boolean isClosed = false;
    private Map partialMessageMap;

    public PartialMessageDebugThread(Map partialMessageMap) {
        this.partialMessageMap = partialMessageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        PartialMessageDebugThread partialMessageDebugThread = this;
        synchronized (partialMessageDebugThread) {
            block4: while (!this.isClosed) {
                try {
                    this.wait(300000L);
                    if (this.isClosed) continue;
                    Iterator it = this.partialMessageMap.entrySet().iterator();
                    while (true) {
                        if (!it.hasNext()) continue block4;
                        Map.Entry entry = it.next();
                        Object msgid = entry.getKey();
                        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)entry.getValue();
                        logger.error("Not receive next partial message,msgid :[{}],put in time:[{}]", msgid, (Object)new Date(pkt.getPartialMessageLastRecTimestamp()));
                    }
                }
                catch (InterruptedException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
            return;
        }
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notify();
    }
}

