/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.jms.JMSException;
import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.jms.protocol.TlqRemoteReadOnlyPacket;
import com.tongtech.jmsclient.PartialMessageMarshaller;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataResponse;
import com.tongtech.remote.protocol.command.Message;
import com.tongtech.remote.protocol.command.PartialMessageAck;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import java.io.DataOutputStream;

public class PartialMessageSender {
    static Logger logger = LoggerFactory.getLogger(PartialMessageSender.class);
    final int ERRORTIMES = 10;
    private int pktSize;
    private int msgInfoSize;

    public PartialMessageSender(ConnectionImpl connection) {
        this.pktSize = Integer.parseInt(connection.getTrimmedProperty("tmqiPartialMessageSize"));
        this.msgInfoSize = Integer.parseInt(connection.getTrimmedProperty("tmqiTlqMessageInfoSize"));
    }

    public ReadWritePacket sendWithPartialReply(Message msg, DataOutputStream os, OpenWireFormat format, TlqRemoteProtocolHandler handler, boolean needAck, MessageProducerImpl producer) throws javax.jms.JMSException {
        PartialMessageMarshaller marshall = new PartialMessageMarshaller(this.pktSize, this.msgInfoSize);
        TlqRemoteReadOnlyPacket ack = null;
        boolean sendFlag = true;
        int sendTimes = 0;
        String reason = null;
        while (sendTimes < 11) {
            if (ack != null) {
                DataResponse response = (DataResponse)ack.getCommand();
                PartialMessageAck res = (PartialMessageAck)response.getData();
                reason = res.getReason();
                logger.trace("got message response ,CommandId:[" + response.getCommandId() + "] MsgSeq:[" + res.getMsgSeq() + "] StatusCode:[" + res.getStatusCode() + "]" + "Reason:[" + reason + "] id : " + msg.getMessageId().getValue());
                switch (res.getStatusCode()) {
                    case 0: {
                        sendFlag = false;
                        break;
                    }
                    default: {
                        sendFlag = false;
                        ExceptionHandler.throwJMSException(new JMSException("StatusCode:[" + res.getStatusCode() + "]  " + reason));
                    }
                }
            }
            if (sendTimes == 10 && sendFlag) {
                throw new JMSException("fail send Message after resend " + sendTimes + " times" + (reason == null ? "" : "," + reason));
            }
            if (sendFlag) {
                Long ackId = handler.getNextAckID();
                AckQueue tmpQ = null;
                if (needAck) {
                    tmpQ = new AckQueue(true, 1);
                }
                try {
                    marshall.sendWithPartial(msg, os, format, handler, needAck, tmpQ, ackId, producer);
                    ++sendTimes;
                    if (needAck) {
                        ack = TlqRemoteProtocolHandler.waitForAck(handler, ackId, tmpQ);
                        continue;
                    }
                    ReadWritePacket readWritePacket = null;
                    return readWritePacket;
                }
                catch (javax.jms.JMSException e) {
                    throw e;
                }
                finally {
                    handler.partialMessageErrorAckMap.remove(ackId);
                    if (needAck) {
                        handler.connection.removeFromAckQTable(ackId);
                    }
                    continue;
                }
            }
            return ack;
        }
        return ack;
    }

    public void sendWithPartialNoReply(Message msg, DataOutputStream os, OpenWireFormat format, TlqRemoteProtocolHandler handler) throws javax.jms.JMSException {
    }
}

