/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.jmsclient.MessageIDWriter;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.util.TupleOutput;
import java.io.IOException;

public class TlqLocalMessageIDWriter
implements MessageIDWriter {
    static Logger logger = LoggerFactory.getLogger(TlqLocalMessageIDWriter.class);

    @Override
    public void writeID(TupleOutput out, MessageImpl msg) throws IOException {
        TupleOutput realAckMsgInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("InterestID:{},messageID:{},destination:{},isQueue:{},srcNode:{}", new Object[]{new Long(msg.getInterestID()), msg.getPacket().getMessageID(), msg.getPacket().getDestination(), new Boolean(msg.getPacket().getIsQueue()), msg.getPacket().getSrcNode()});
        }
        if ((realAckMsgInfo = msg.getRealAckMsgInfo()) == null) {
            out.writeLong(msg.getInterestID());
            out.writeString(msg.getPacket().getMessageID());
            out.writeBoolean(msg.getPacket().getIsQueue());
            out.writeString(msg.getPacket().getDestination());
            out.writeString(msg.getPacket().getSrcNode());
            out.writeString(msg.getPacket().getSubQueue());
        } else {
            out.write(realAckMsgInfo.getBufferBytes(), realAckMsgInfo.getBufferOffset(), realAckMsgInfo.getBufferLength() - 8);
        }
    }

    @Override
    public void writeID(TupleOutput out, SessionImpl.UnAckedMessage msg) throws IOException {
        out.writeLong(msg.getConsumerID());
        out.writeString(msg.getMsgId());
        out.writeBoolean(msg.getIsQueue());
        out.writeString(msg.getDestination());
        out.writeString(msg.getSrcNode());
        out.writeString(msg.getSubQueue());
    }

    @Override
    public void writeID(TupleOutput out, ReadOnlyPacket msg) throws IOException {
        out.writeLong(msg.getConsumerID());
        out.writeString(msg.getMessageID());
        out.writeBoolean(msg.getIsQueue());
        out.writeString(msg.getDestination());
        out.writeString(msg.getSrcNode());
        out.writeString(msg.getSubQueue());
    }
}

