/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient;

import com.tongtech.backport.java.util.concurrent.BlockingQueue;
import com.tongtech.backport.java.util.concurrent.TimeUnit;
import com.tongtech.jmsclient.ReadAckChannel;
import com.tongtech.jmsclient.ReadMessageChannel;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.UnifiedReadChannel;
import java.util.Hashtable;
import javax.jms.JMSException;

public class TlqLocalReadChannel
implements UnifiedReadChannel {
    static Logger logger = LoggerFactory.getLogger(TlqLocalReadChannel.class);
    ReadMessageChannel readMessageChannel = null;
    ReadAckChannel readAckChannel = null;

    @Override
    public FlowControl getFlowControl() {
        return this.readMessageChannel.flowControl;
    }

    @Override
    public void setFatalError(Error err) {
        this.readAckChannel.setFatalError(err);
        this.readMessageChannel.setFatalError(err);
    }

    @Override
    public void waitGoodByeAck(BlockingQueue ackQueue) {
        try {
            ackQueue.poll(60L, TimeUnit.MILLISECONDS);
            ackQueue.poll(60L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            logger.error("", ex);
        }
    }

    @Override
    public void close() {
        this.readMessageChannel.close();
        this.readAckChannel.close();
    }

    @Override
    public void putHashTable(Hashtable ht) {
        if (this.readMessageChannel != null) {
            ht.put("readMessageChannnelIsClosed", String.valueOf(this.readMessageChannel.isClosed));
            ht.put("readMessageChannnelReceivedGoodByeReply", String.valueOf(this.readMessageChannel.receivedGoodByeReply));
        }
        if (this.readAckChannel != null) {
            ht.put("readAckChannelIsClosed", String.valueOf(this.readAckChannel.isClosed));
            ht.put("readAckChannelReceivedGoodByeReply", String.valueOf(this.readAckChannel.receivedGoodByeReply));
        }
    }

    @Override
    public void setConnection(ConnectionImpl connection) {
        this.readMessageChannel = new ReadMessageChannel(connection);
        this.readAckChannel = new ReadAckChannel(connection);
    }

    @Override
    public void closeIOAndNotify() {
        this.readAckChannel.closeIOAndNotify();
    }

    @Override
    public void savedJMSException(JMSException jmse) {
        if (this.readMessageChannel.savedJMSException != null) {
            jmse.setLinkedException((Exception)((Object)this.readMessageChannel.savedJMSException));
        }
        if (this.readAckChannel.savedJMSException != null) {
            jmse.setLinkedException((Exception)((Object)this.readAckChannel.savedJMSException));
        }
    }

    @Override
    public boolean IsCurrentThread(Thread currentThread) {
        return currentThread != this.readAckChannel.readAckChannelThread || currentThread != this.readMessageChannel.readMessageChannelThread;
    }

    @Override
    public void setBrokerNonResponsive() {
    }

    @Override
    public Thread getReadChannelThread() {
        return null;
    }
}

