/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient.filemessage;

import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.jmsclient.filemessage.FileMessageSender;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.protocol.util.ByteSequence;
import com.tongtech.protocol.util.DataByteArrayOutputStream;
import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.FileInfo;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jms.JMSException;

public class FileInfoMarshaller
extends BaseCommandMarshaller {
    static Logger logger = LoggerFactory.getLogger(FileInfoMarshaller.class);
    DataByteArrayOutputStream bytesOut = new DataByteArrayOutputStream();
    private int messagePropertiesPktSize;
    private int msgPropertiesoffset;

    @Override
    public byte getDataStructureType() {
        return 82;
    }

    @Override
    public DataStructure createObject() {
        return new FileInfo();
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        FileInfo info = (FileInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalLong1(wireFormat, info.getSeqId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getProducerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getDestination(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getTargetConsumerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getMessageId(), bs);
        rc += this.tightMarshalString1(info.getFileName(), bs);
        bs.writeBoolean(info.isLast());
        rc += this.tightMarshalMessageProperties1(info.getMarshalledProperties(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getTransactionId(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getExpiration(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getTimestamp(), bs);
        rc += this.tightMarshalString1(info.getCorrelationId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getReplyTo(), bs);
        bs.writeBoolean(info.isPersistent());
        rc += this.tightMarshalString1(info.getType(), bs);
        rc += this.tightMarshalString1(info.getGroupID(), bs);
        bs.writeBoolean(info.isCompressed());
        rc += this.tightMarshalString1(info.getUserID(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getFileSize(), bs);
        bs.writeBoolean(info.isResume());
        bs.writeBoolean(info.isRenamed());
        return (rc += this.tightMarshalByteArray1(info.getUsrContext(), bs)) + 33;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        FileInfo info = (FileInfo)o;
        this.tightMarshalLong2(wireFormat, info.getSeqId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getProducerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getDestination(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getTargetConsumerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getMessageId(), dataOut, bs);
        this.tightMarshalString2(info.getFileName(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalMessageProperties2(info.getMarshalledProperties(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getTransactionId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getExpiration(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getTimestamp(), dataOut, bs);
        this.tightMarshalString2(info.getCorrelationId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getReplyTo(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalString2(info.getType(), dataOut, bs);
        dataOut.writeByte(info.getPriority());
        this.tightMarshalString2(info.getGroupID(), dataOut, bs);
        dataOut.writeInt(info.getGroupSequence());
        bs.readBoolean();
        this.tightMarshalString2(info.getUserID(), dataOut, bs);
        dataOut.writeInt(info.getRedeliveryCounter());
        this.tightMarshalLong2(wireFormat, info.getFileSize(), dataOut, bs);
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getPieceSize());
        bs.readBoolean();
        dataOut.writeInt(info.getPropNum());
        bs.readBoolean();
        dataOut.writeInt(info.getSeq());
        this.tightMarshalByteArray2(info.getUsrContext(), dataOut, bs);
        dataOut.writeInt(info.getMsgIdx());
        dataOut.writeInt(info.getFlag());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        FileInfo info = (FileInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalLong(wireFormat, info.getSeqId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getProducerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getDestination(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getTargetConsumerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getMessageId(), dataOut);
        this.looseMarshalString(info.getFileName(), dataOut);
        dataOut.writeBoolean(info.isLast());
        this.looseMarshalMessageProperties(wireFormat, info.getMarshalledProperties(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getTransactionId(), dataOut);
        this.looseMarshalLong(wireFormat, info.getExpiration(), dataOut);
        this.looseMarshalLong(wireFormat, info.getTimestamp(), dataOut);
        this.looseMarshalString(info.getCorrelationId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getReplyTo(), dataOut);
        dataOut.writeBoolean(info.isPersistent());
        this.looseMarshalString(info.getType(), dataOut);
        dataOut.writeByte(info.getPriority());
        this.looseMarshalString(info.getGroupID(), dataOut);
        dataOut.writeInt(info.getGroupSequence());
        dataOut.writeBoolean(info.isCompressed());
        this.looseMarshalString(info.getUserID(), dataOut);
        dataOut.writeInt(info.getRedeliveryCounter());
        this.looseMarshalLong(wireFormat, info.getFileSize(), dataOut);
        dataOut.writeInt(info.getPropSize());
        dataOut.writeInt(info.getPieceSize());
        dataOut.writeBoolean(info.isResume());
        dataOut.writeInt(info.getPropNum());
        dataOut.writeBoolean(info.isRenamed());
        dataOut.writeInt(info.getSeq());
        this.looseMarshalByteArray(wireFormat, info.getUsrContext(), dataOut);
        dataOut.writeInt(info.getMsgIdx());
        dataOut.writeInt(info.getFlag());
    }

    protected int tightMarshalMessageProperties1(byte[] marshalledProperties, BooleanStream bs) throws IOException {
        bs.writeBoolean(marshalledProperties != null);
        if (marshalledProperties != null) {
            return this.messagePropertiesPktSize + 4;
        }
        return 0;
    }

    protected void tightMarshalMessageProperties2(byte[] marshalledProperties, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            dataOut.writeInt(this.messagePropertiesPktSize);
            dataOut.write(marshalledProperties, this.msgPropertiesoffset, this.messagePropertiesPktSize);
        }
    }

    protected void looseMarshalMessageProperties(OpenWireFormat wireFormat, byte[] marshalledProperties, DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(marshalledProperties != null);
        if (marshalledProperties != null) {
            dataOut.writeInt(this.messagePropertiesPktSize);
            dataOut.write(marshalledProperties, this.msgPropertiesoffset, this.messagePropertiesPktSize);
        }
    }

    public synchronized void marshal(Object o, DataOutputStream dataOut, OpenWireFormat wireFormat) throws IOException {
        int size = 1;
        if (o != null) {
            DataStructure c = (DataStructure)o;
            byte type = this.getDataStructureType();
            if (wireFormat.isTightEncodingEnabled()) {
                BooleanStream bs = new BooleanStream();
                size += this.tightMarshal1(wireFormat, c, bs);
                size += bs.marshalledSize();
                if (!wireFormat.isSizePrefixDisabled()) {
                    dataOut.writeShort(size + 3);
                }
                dataOut.writeByte(1);
                dataOut.writeByte(type);
                bs.marshal(dataOut);
                this.tightMarshal2(wireFormat, c, dataOut, bs);
            } else {
                OutputStream looseOut = dataOut;
                if (!wireFormat.isSizePrefixDisabled()) {
                    this.bytesOut.restart();
                    looseOut = this.bytesOut;
                }
                looseOut.writeByte(type);
                this.looseMarshal(wireFormat, c, (DataOutput)((Object)looseOut));
                if (!wireFormat.isSizePrefixDisabled()) {
                    ByteSequence sequence = this.bytesOut.toByteSequence();
                    dataOut.writeInt(sequence.getLength());
                    dataOut.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
                }
            }
            this.msgPropertiesoffset += this.messagePropertiesPktSize;
        } else {
            if (!wireFormat.isSizePrefixDisabled()) {
                dataOut.writeInt(size);
            }
            dataOut.writeByte(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWithPartial(DataOutputStream os, OpenWireFormat format, FileMessageSender sender, boolean needAck, AckQueue tmpQ, Long ackId) throws JMSException {
        try {
            int propertiesLength = sender.fileInfo.getPropSize();
            sender.fileInfo.setCommandId(ackId.intValue());
            if (needAck && tmpQ != null) {
                sender.handler.connection.addToAckQTable(ackId, tmpQ);
            }
            this.msgPropertiesoffset = 0;
            int seq = 0;
            sender.fileInfo.setLast(false);
            while (this.msgPropertiesoffset <= propertiesLength && !sender.fileInfo.isLast()) {
                if (sender.pktSize == 0) {
                    this.messagePropertiesPktSize = propertiesLength;
                } else if (this.msgPropertiesoffset < propertiesLength) {
                    this.messagePropertiesPktSize = propertiesLength - this.msgPropertiesoffset > sender.pktSize ? sender.pktSize : propertiesLength - this.msgPropertiesoffset;
                    if (seq == 0 && this.messagePropertiesPktSize + sender.msgInfoSize > sender.pktSize) {
                        this.messagePropertiesPktSize = sender.pktSize - sender.msgInfoSize;
                    }
                } else {
                    this.messagePropertiesPktSize = 0;
                }
                if (this.msgPropertiesoffset + this.messagePropertiesPktSize == propertiesLength) {
                    sender.fileInfo.setLast(true);
                }
                sender.fileInfo.setSeq(seq++);
                sender.producer.waitForSpace(sender.producerId.getValue());
                TlqRemoteProtocolHandler tlqRemoteProtocolHandler = sender.handler;
                synchronized (tlqRemoteProtocolHandler) {
                    this.marshal(sender.fileInfo, os, format);
                    os.flush();
                }
                logger.trace("send a fileinfo : {},", sender.fileInfo);
                sender.producer.increaseUsage(sender.producerId.getValue(), this.messagePropertiesPktSize);
                sender.fileInfo.resetFileinfo();
                sender.handler.setTimeToPing(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }
}

