/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient.filemessage;

import com.tongtech.jms.FileMessage;
import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.jms.protocol.TlqRemoteReadWritePacket;
import com.tongtech.jmsclient.filemessage.FileInfoMarshaller;
import com.tongtech.jmsclient.filemessage.FileSenderHandler;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.protocol.util.TlqKnlMessagePropertiesUtil;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.DataArrayResponse;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.ExceptionResponse;
import com.tongtech.remote.protocol.command.FileInfo;
import com.tongtech.remote.protocol.command.IntegerInfo;
import com.tongtech.remote.protocol.command.LocalTransactionId;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.util.MD5;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;

public class FileMessageSender {
    private static final String RETRANSFER_FLAG = "JMS_TONG_Retransfer";
    private static final String REC_FILENAME = "JMS_TONG_RecFileName";
    private static final String REMOVEFILE_FLAG = "JMS_TONG_Removefile";
    private static final int REMOVE_FLAG = 1;
    private int bitFlags = 0;
    static Logger logger = LoggerFactory.getLogger(FileMessageSender.class);
    private FileInfoMarshaller marshall;
    private long fileSize;
    private int msgIdx;
    private Runnable[] threads;
    protected int resumePos;
    private File recFile;
    private RandomAccessFile rafile;
    private FileLock lock;
    protected int pktSize;
    protected MessageId msgid;
    protected TlqRemoteProtocolHandler handler;
    protected ProducerId producerId;
    protected int pieceSize = 4096;
    protected int msgInfoSize;
    private FileChannel channel;
    FileSenderHandler sender = null;
    protected File file;
    protected boolean hasError = false;
    protected Throwable error;
    public FileInfo fileInfo;
    private boolean removeFile;
    private boolean resend;
    private String fixedFilename;
    private boolean retransfer;
    private int propSize;
    public MessageProducerImpl producer;

    public FileMessageSender(TlqRemoteProtocolHandler handler) {
        this.handler = handler;
        this.init();
    }

    private void init() {
        this.marshall = new FileInfoMarshaller();
        this.pktSize = Integer.parseInt(this.handler.connection.getTrimmedProperty("tmqiPartialMessageSize"));
        this.msgInfoSize = Integer.parseInt(this.handler.connection.getTrimmedProperty("tmqiTlqMessageInfoSize"));
    }

    public void sendFileMessage(MessageImpl msg, DataOutputStream os, MessageId msgid, OpenWireFormat wireFormat, boolean needAck, MessageProducerImpl producer) throws JMSException {
        this.msgid = msgid;
        this.producerId = msgid.getProducerId();
        this.producer = producer;
        String filename = ((FileMessage)((Object)msg)).getFile();
        File file = new File(filename);
        if (!file.exists()) {
            throw new JMSException("File does not exists!");
        }
        this.file = file;
        if (!this.handler.isLocalFile) {
            this.fileSize = file.length();
        }
        this.removeFile = msg.getBooleanProperty(REMOVEFILE_FLAG);
        this.fixedFilename = msg.getStringProperty(REC_FILENAME);
        this.retransfer = msg.getBooleanProperty(RETRANSFER_FLAG);
        try {
            boolean retransterFlag;
            boolean bl = retransterFlag = !this.handler.isLocalFile && this.retransfer;
            if (retransterFlag) {
                this.parpareForRetransfer(msg);
            }
            this.msgid.setProducerId(msgid.getProducerId());
            try {
                this.sender = new FileSenderHandler(0L, this.fileSize, 0, this);
                this.sender.init();
            }
            catch (Exception e) {
                logger.error("init file error ", e);
                JMSException ex = new JMSException(e.getMessage());
                ex.setLinkedException(e);
                throw ex;
            }
            this.sendFileInfo(msg, os, msgid, wireFormat);
            if (retransterFlag) {
                this.recordToFile();
            }
            if (this.fileSize != 0L && !this.handler.isLocalFile) {
                this.sendFileContent(os, this.msgid, wireFormat, this.handler, needAck);
            }
        }
        catch (JMSException e) {
            logger.warn("send file error ,{}", e);
            throw e;
        }
        finally {
            try {
                if (this.lock != null) {
                    this.lock.release();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.rafile != null) {
                    this.rafile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (!this.hasError) {
                    if (this.recFile != null) {
                        this.recFile.delete();
                    }
                    if (this.removeFile && !this.handler.isLocalFile && !producer.getSession().isTransacted) {
                        boolean bl = file.delete();
                    }
                }
            }
            catch (Exception exception) {}
            if (this.sender != null) {
                this.sender.close();
            }
            this.fileInfo.setFileSize(this.fileSize);
            this.fileInfo.setPropSize(this.propSize);
        }
    }

    private void sendFileInfo(MessageImpl msg, DataOutputStream os, MessageId msgid, OpenWireFormat wireFormat) throws JMSException {
        block2: {
            Command response;
            block3: {
                String error;
                while (true) {
                    FileInfo info;
                    this.fileInfo = info = this.createFileInfo(msg, msgid, this.handler, this.producer);
                    response = this.sendFileInfo(os, this.handler, wireFormat);
                    if (response == null) break block2;
                    if (response instanceof DataArrayResponse) {
                        DataStructure[] data = ((DataArrayResponse)response).getData();
                        this.pieceSize = ((IntegerInfo)data[0]).getInfo();
                        this.msgIdx = ((IntegerInfo)data[1]).getInfo();
                        this.resumePos = ((IntegerInfo)data[2]).getInfo();
                        logger.trace("pieceSize={}, msgIdx={}, resumePos={}", new Object[]{new Integer(this.pieceSize), new Integer(this.msgIdx), new Integer(this.resumePos)});
                        break block2;
                    }
                    if (!(response instanceof ExceptionResponse)) break block3;
                    ExceptionResponse ex = (ExceptionResponse)response;
                    error = ex.getException().getMessage();
                    if (error.indexOf("errorCode:[2123]") < 0) break;
                    this.resend = false;
                }
                throw new JMSException(error);
            }
            logger.error("Unknown response {}", response);
        }
        msg.getPacket().setMessageID(this.fileInfo.getMessageId().getValue());
    }

    private void recordToFile() {
        try {
            this.rafile.seek(0L);
            this.rafile.write(this.msgid.toString().getBytes("UTF8"));
            this.rafile.write(TlqKnlMessagePropertiesUtil.parseInt(this.msgIdx));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error(e.getMessage() + "rafile write messageid error");
            e.printStackTrace();
        }
    }

    private void parpareForRetransfer(MessageImpl msg) throws JMSException {
        block12: {
            String name = this.file.getName();
            String path = this.file.getAbsolutePath();
            String fileName = name + "_" + MD5.getMD5String(path + this.handler.connection.getBrokerAddress() + ((Destination)msg.getJMSDestination()).getName() + this.file.lastModified()) + ".msg";
            this.recFile = new File(TlqRemoteProtocolHandler.FILEMSG_CONF_DIR + File.separator + fileName);
            this.rafile = null;
            if (this.recFile.exists()) {
                try {
                    this.rafile = new RandomAccessFile(this.recFile, "rw");
                    byte[] id = new byte[32];
                    this.rafile.read(id);
                    if (id[0] == 0) {
                        this.resend = false;
                        break block12;
                    }
                    String srcId = new String(id, "UTF8");
                    this.msgid = new MessageId(srcId);
                    byte[] idx = new byte[4];
                    this.rafile.read(idx);
                    this.msgIdx = TlqKnlMessagePropertiesUtil.parseInteger(idx);
                    this.resend = true;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    logger.error(e.getMessage() + "rafile read messageId error");
                    e.printStackTrace();
                }
            } else {
                try {
                    this.recFile.createNewFile();
                    this.rafile = new RandomAccessFile(this.recFile, "rw");
                }
                catch (IOException e) {
                    JMSException jmse = new JMSException("create record file error" + this.recFile.getName());
                    jmse.initCause((Throwable)e);
                    throw jmse;
                }
            }
        }
        try {
            this.channel = this.rafile.getChannel();
            this.lock = this.channel.tryLock();
            if (this.lock == null) {
                throw new JMSException("File is snding now!");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            logger.warn("send file error", e1);
            throw new JMSException("File is snding now!");
        }
    }

    private void sendFileContent(DataOutputStream os, MessageId msgid, OpenWireFormat wireFormat, TlqRemoteProtocolHandler handler, boolean needAck) throws JMSException {
        boolean i = false;
        this.sender.handle(os, msgid, wireFormat, handler, needAck);
        if (this.hasError) {
            JMSException ex = new JMSException(this.error.getMessage());
            ex.initCause(this.error);
            if (this.error instanceof SocketException) {
                this.handler.connection.close();
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command sendFileInfo(DataOutputStream os, TlqRemoteProtocolHandler handler, OpenWireFormat wireFormat) throws JMSException {
        Long ackId = new Long(this.fileInfo.getCommandId());
        try {
            AckQueue tmpQ = new AckQueue(true, 1);
            TlqRemoteReadWritePacket ack = null;
            this.fileInfo.setProducerId(this.producerId);
            this.marshall.sendWithPartial(os, wireFormat, this, true, tmpQ, ackId);
            ack = TlqRemoteProtocolHandler.waitForAck(handler, ackId, tmpQ);
            Command command = ack.getCommand();
            return command;
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handleException(e, "C4001", true);
        }
        finally {
            handler.connection.removeFromAckQTable(ackId);
        }
        return null;
    }

    private FileInfo createFileInfo(MessageImpl msg, MessageId newMsgId, TlqRemoteProtocolHandler handler, MessageProducerImpl producer) throws JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)msg.getPacket();
        FileInfo info = new FileInfo();
        info.setCommandId(handler.getNextAckID().intValue());
        info.setFileSize(this.fileSize);
        this.bitFlags = this.retransfer ? (this.bitFlags |= 2) : (this.bitFlags &= 0xFFFFFFFD);
        this.bitFlags = this.removeFile ? (this.bitFlags |= 1) : (this.bitFlags &= 0xFFFFFFFE);
        info.setFlag(this.bitFlags);
        info.setUsrContext(TlqRemoteProtocolHandler.getUsrContextFromMessage(msg));
        String filename = null;
        if (handler.isLocalFile) {
            filename = ((FileMessage)((Object)msg)).getFile();
        } else {
            filename = FileMessageSender.genSampleFileName(((FileMessage)((Object)msg)).getFile());
            if (this.fixedFilename == null) {
                this.fixedFilename = filename;
            }
        }
        if (this.fixedFilename == null) {
            info.setFileName("\"" + filename + "\"");
        } else {
            info.setFileName("\"" + filename + "\" \"" + this.fixedFilename + "\"");
        }
        info.setTransactionId(new LocalTransactionId(handler.connectionId, (int)msg.getPacket().getTransactionID()));
        Destination dest = (Destination)msg.getJMSDestination();
        info.setDestination(com.tongtech.remote.protocol.command.Destination.createDestination(dest.getName(), handler.getDestinationType(dest)));
        if (this.resend) {
            info.setResume(true);
            info.setMessageId(this.msgid);
            info.setMsgIdx(this.msgIdx);
        } else {
            this.msgid = newMsgId;
            JMQByteArrayOutputStream os = new JMQByteArrayOutputStream(new byte[130]);
            Hashtable properties = null;
            try {
                properties = pkt.getProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (properties != null) {
                this.removeExtraInfoproperties(properties);
                TlqKnlMessagePropertiesUtil.getByte((Map)properties, os);
                this.propSize = os.getCount();
                byte[] prop = new byte[this.propSize];
                System.arraycopy(os.getBuf(), 0, prop, 0, os.getCount());
                info.setMarshalledProperties(prop);
                info.setPropSize(this.propSize);
                info.setPropNum(properties.size());
            }
            info.setMessageId(newMsgId);
            info.setPersistent(msg.getPacket().getPersistent());
            info.setCorrelationId(msg.getJMSCorrelationID());
            info.setExpiration(msg.getPacket().getTimeToLive());
            info.setPriority((byte)producer.getPriority());
            info.setTimestamp(msg.getJMSTimestamp());
            info.setType(msg.getJMSType());
            info.setPieceSize(this.pieceSize);
            info.setResponseRequired(true);
            info.setLast(true);
            info.setProducerId(newMsgId.getProducerId());
        }
        return info;
    }

    private void removeExtraInfoproperties(Hashtable properties) {
        properties.remove(REC_FILENAME);
        properties.remove(REMOVEFILE_FLAG);
        properties.remove(RETRANSFER_FLAG);
    }

    public static String genSampleFileName(String name) {
        int index1;
        int index = name.lastIndexOf("/");
        int n = index = index < (index1 = name.lastIndexOf("\\")) ? index1 : index;
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    protected void exitWithError(Throwable error) {
        this.error = error;
        this.hasError = true;
    }
}

