/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jmsclient.filemessage;

import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.jmsclient.filemessage.FileMessageSender;
import com.tongtech.jmsclient.filemessage.FileMessageStatusImpl;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.FileContent;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import javax.jms.JMSException;

public class FileSenderHandler {
    static Logger logger = LoggerFactory.getLogger(FileSenderHandler.class);
    private long startPos;
    private long endPos;
    private long offset;
    private RandomAccessFile raf;
    private int threadNum;
    private int status;
    private FileMessageSender sender;

    public FileSenderHandler(long startPos, long endPos, int threadNum, FileMessageSender sender) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.threadNum = threadNum;
        this.sender = sender;
    }

    public void init() throws Exception {
        if (!this.sender.handler.isLocalFile && this.endPos != 0L) {
            this.raf = new RandomAccessFile(this.sender.file, "r");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(DataOutputStream os, MessageId msgid, OpenWireFormat wireFormat, TlqRemoteProtocolHandler handler, boolean needAck) throws JMSException {
        Long ackid = handler.getNextAckID();
        FileMessageStatusImpl snapshotImpl = new FileMessageStatusImpl(this.endPos, msgid);
        this.sender.producer.setFileProgressSnapshot(snapshotImpl);
        try {
            long pos = this.startPos + (long)(this.sender.resumePos * this.sender.pieceSize);
            snapshotImpl.updatePercentage(pos);
            this.offset = pos;
            this.raf.seek(pos);
            int currentIndex = this.sender.resumePos;
            AckQueue tmpQ = null;
            if (needAck) {
                tmpQ = new AckQueue(true, 1);
                handler.connection.addToAckQTable(ackid, tmpQ);
            }
            while (this.offset < this.endPos) {
                long sendSize;
                block19: {
                    if (this.sender.producer.getWantInterruptMessage() != null && Arrays.equals(this.sender.producer.getWantInterruptMessage().getByteValue(), msgid.getByteValue())) {
                        throw new JMSException("interrupt sending");
                    }
                    long remain = this.endPos - this.offset;
                    sendSize = remain > (long)this.sender.pieceSize ? (long)this.sender.pieceSize : remain;
                    byte[] buf = new byte[(int)sendSize];
                    this.raf.read(buf);
                    this.sender.producer.waitForSpace(this.sender.producerId.getValue());
                    MessageProducerImpl.ProducerState ps = (MessageProducerImpl.ProducerState)this.sender.producer.producerStates.get(new Long(this.sender.producerId.getValue()));
                    this.sendFileContent(buf, currentIndex, os, wireFormat, handler, ackid, ps.getProducerWindow().getUsage());
                    this.sender.producer.increaseUsage(this.sender.producerId.getValue(), sendSize);
                    try {
                        TlqRemoteProtocolHandler.handleSendError(ackid, handler);
                    }
                    catch (JMSException e) {
                        if (!needAck) break block19;
                        throw e;
                    }
                }
                logger.trace("send file ,ThreadNum : {},index: {},buf size :{},offset:{},file point :{}", new Object[]{new Integer(this.threadNum), new Integer(currentIndex), new Long(sendSize), new Long(this.offset), new Long(this.raf.getFilePointer())});
                ++currentIndex;
                this.offset += sendSize;
                snapshotImpl.updatePercentage(this.offset);
            }
            if (needAck) {
                TlqRemoteProtocolHandler.waitForAck(handler, ackid, tmpQ);
            }
        }
        catch (Exception e1) {
            logger.warn("send file error :", e1);
            this.sender.exitWithError(e1);
        }
        finally {
            try {
                if (needAck) {
                    handler.connection.removeFromAckQTable(ackid);
                }
            }
            finally {
                this.close();
            }
            this.sender.producer.cleanInterrupted();
            snapshotImpl.cleanStatus();
        }
    }

    private void sendFileContent(byte[] buf, int piece, DataOutputStream os, OpenWireFormat format, TlqRemoteProtocolHandler handler, Long ackid, long prodcuerWindow) throws IOException, JMSException {
        FileContent content = new FileContent();
        content.setCommandId(ackid.intValue());
        content.setFileContent(buf);
        content.setMessageId(this.sender.msgid);
        content.setPiece(piece);
        content.setProducerId(this.sender.producerId);
        content.setResponseRequired(true);
        content.setSeqId(prodcuerWindow);
        this.writeCommandNoReply(content, os, format, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCommandNoReply(Command command, DataOutputStream os, OpenWireFormat format, TlqRemoteProtocolHandler handler) throws IOException, JMSException {
        TlqRemoteProtocolHandler tlqRemoteProtocolHandler = handler;
        synchronized (tlqRemoteProtocolHandler) {
            format.marshal(command, os);
            logger.trace("send a filecontent {}", command);
            os.flush();
            handler.setTimeToPing(false);
        }
    }

    protected synchronized void setStatus(int status) {
        if (this.status != status) {
            this.status = status;
        }
    }

    protected synchronized int getStatus() {
        return this.status;
    }

    protected void close() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                logger.warn("close file  error,{}", e);
            }
        }
    }
}

