/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jndi.protocol.v3;

import com.tongtech.jndi.protocol.DataStreamMarshaller;
import com.tongtech.jndi.protocol.OpenWireFormat;
import com.tongtech.jndi.protocol.v3.DataArrayResponseMarshaller;
import com.tongtech.jndi.protocol.v3.DataResponseMarshaller;
import com.tongtech.jndi.protocol.v3.ExceptionResponseMarshaller;
import com.tongtech.jndi.protocol.v3.IntegerResponseMarshaller;
import com.tongtech.jndi.protocol.v3.JndiRequestMarshaller;
import com.tongtech.jndi.protocol.v3.ResponseMarshaller;
import com.tongtech.jndi.protocol.v3.StringInfoMarshaller;
import com.tongtech.jndi.protocol.v3.StringRRResponseMarshaller;
import com.tongtech.jndi.protocol.v3.WireFormatInfoMarshaller;

public class MarshallerFactory {
    public static final int CURRENT_VERSION = 20111122;
    private static final DataStreamMarshaller[] marshaller = new DataStreamMarshaller[256];

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.marshaller[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return marshaller;
    }

    static {
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new JndiRequestMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new StringInfoMarshaller());
        MarshallerFactory.add(new StringRRResponseMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
    }
}

