/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.log;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import sun.reflect.Reflection;

public class JDKLogger {
    private Logger logger;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;

    public static synchronized JDKLogger getLogger(String name, String resourceBundleName) {
        return new JDKLogger(name, resourceBundleName);
    }

    private JDKLogger(String name, String resourceBundleName) {
        this.logger = LoggerFactory.getLogger(name);
        this.findResourceBundle(resourceBundleName);
    }

    public boolean isLoggable(Level level) {
        Level jdkLevel = level;
        if (jdkLevel == Level.SEVERE) {
            return this.logger.isErrorEnabled();
        }
        if (jdkLevel == Level.WARNING) {
            return this.logger.isWarnEnabled();
        }
        if (jdkLevel == Level.INFO || jdkLevel == Level.CONFIG) {
            return this.logger.isInfoEnabled();
        }
        if (jdkLevel == Level.FINE) {
            return this.logger.isDebugEnabled();
        }
        if (jdkLevel == Level.FINER || jdkLevel == Level.FINEST) {
            return this.logger.isTraceEnabled();
        }
        return false;
    }

    public void log(Level level, String msg, Object param) {
        String format = null;
        if (this.catalog != null) {
            try {
                format = this.catalog.getString(msg);
                if (format.indexOf("{0}") >= 0 || format.indexOf("{1}") >= 0 || format.indexOf("{2}") >= 0 || format.indexOf("{3}") >= 0) {
                    format = MessageFormat.format(format, param);
                }
            }
            catch (MissingResourceException ex) {
                format = msg;
            }
        }
        if (level.equals(Level.SEVERE)) {
            this.logger.error(format, param);
        } else if (level.equals(Level.WARNING)) {
            this.logger.warn(format, param);
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            this.logger.info(format, param);
        } else if (level.equals(Level.FINE)) {
            this.logger.debug(format, param);
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            this.logger.trace(format, param);
        }
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    private ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        if (this.catalog != null && currentLocale == this.catalogLocale && name == this.catalogName) {
            return this.catalog;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
            this.catalogName = name;
            this.catalogLocale = currentLocale;
            return this.catalog;
        }
        catch (MissingResourceException missingResourceException) {
            Class clz;
            int ix = 0;
            while ((clz = Reflection.getCallerClass((int)ix)) != null) {
                ClassLoader cl2 = clz.getClassLoader();
                if (cl2 == null) {
                    cl2 = ClassLoader.getSystemClassLoader();
                }
                if (cl != cl2) {
                    cl = cl2;
                    try {
                        this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
                        this.catalogName = name;
                        this.catalogLocale = currentLocale;
                        return this.catalog;
                    }
                    catch (MissingResourceException missingResourceException2) {
                        // empty catch block
                    }
                }
                ++ix;
            }
            if (name.equals(this.catalogName)) {
                return this.catalog;
            }
            return null;
        }
    }
}

