/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.org.apache.log4j.dynamicLogLevel;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.org.apache.log4j.dynamicLogLevel.Env;
import com.tongtech.org.apache.log4j.dynamicLogLevel.EnvAccessException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class CheckDynamicLogLevel
implements Runnable {
    private static String isDynamic = null;
    private static long SLEEP_TIME = 8000L;
    private static String showLogLevel = null;
    public static CheckDynamicLogLevel static_CheckDynamicLogSingle = null;
    private static String DYNAMIC_CONFDIR;
    private static FileInputStream fis;
    private static Properties pro;
    private static final String fileName = "tlqjms.conf";
    private static final String pro_jms_level_name = "tlq.jms.log.level";
    static Logger logger;

    private CheckDynamicLogLevel() {
    }

    public static CheckDynamicLogLevel getInstance() {
        static_CheckDynamicLogSingle = new CheckDynamicLogLevel();
        return static_CheckDynamicLogSingle;
    }

    private void initLogFile() {
        if (CheckDynamicLogLevel.getClientDir()) {
            DYNAMIC_CONFDIR = "./tlqjms.conf";
            if (showLogLevel != null && showLogLevel.equals("true")) {
                logger.debug("\u542f\u7528\u5f53\u524d\u8def\u5f84\u52a8\u6001\u65e5\u5fd7\u7ea7\u522b " + DYNAMIC_CONFDIR);
            }
        } else {
            try {
                DYNAMIC_CONFDIR = Env.getEnvVariable("TLQCONFDIR") + "/" + fileName;
                if (showLogLevel != null && showLogLevel.equals("true")) {
                    logger.debug("\u542f\u7528TLQ\u8def\u5f84\u52a8\u6001\u65e5\u5fd7\u7ea7\u522b" + DYNAMIC_CONFDIR);
                }
            }
            catch (EnvAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean getClientDir() {
        try {
            fis = new FileInputStream("./tlqjms.conf");
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return true;
    }

    private void isDynamicLogFromFile() {
        try {
            fis = new FileInputStream(DYNAMIC_CONFDIR);
            pro.load(fis);
            isDynamic = pro.getProperty(pro_jms_level_name);
            showLogLevel = pro.getProperty("show.log.level");
            if (showLogLevel != null && showLogLevel.equals("true")) {
                logger.debug("\u5f53\u524d\u65e5\u5fd7\u7ea7\u522b\u4e3a: " + (isDynamic.equals("none") ? "\u7cfb\u7edf\u914d\u7f6e" : isDynamic));
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    public void run() {
        while (true) {
            this.initLogFile();
            this.isDynamicLogFromFile();
            if (isDynamic == null || isDynamic.equals("close")) {
                isDynamic = null;
                logger.debug("\u52a8\u6001\u4fee\u6539\u53d6\u6d88 \u542f\u7528\u914d\u7f6e\u6587\u4ef6\u65e5\u5fd7\u7ea7\u522b");
            }
            try {
                Thread.sleep(SLEEP_TIME);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static String getIsDynamic() {
        return isDynamic;
    }

    public static long getSLEEP_TIME() {
        return SLEEP_TIME;
    }

    public static void setSLEEP_TIME(long sleep_time) {
        SLEEP_TIME = sleep_time;
    }

    static {
        fis = null;
        pro = new Properties();
        logger = LoggerFactory.getLogger(CheckDynamicLogLevel.class);
    }
}

