/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol;

import com.tongtech.protocol.wireformat.WireFormat;
import com.tongtech.protocol.wireformat.WireFormatFactory;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.WireFormatInfo;

public class OpenWireFormatFactory
implements WireFormatFactory {
    private int version = 3;
    private boolean stackTraceEnabled = true;
    private boolean tcpNoDelayEnabled = true;
    private boolean cacheEnabled = true;
    private boolean tightEncodingEnabled = true;
    private boolean sizePrefixDisabled;
    private long maxInactivityDuration = 30000L;
    private long maxInactivityDurationInitalDelay = 10000L;
    private int cacheSize = 1024;

    @Override
    public WireFormat createWireFormat() {
        WireFormatInfo info = new WireFormatInfo();
        info.setVersion(this.version);
        try {
            info.setStackTraceEnabled(this.stackTraceEnabled);
            info.setCacheEnabled(this.cacheEnabled);
            info.setTcpNoDelayEnabled(this.tcpNoDelayEnabled);
            info.setTightEncodingEnabled(this.tightEncodingEnabled);
            info.setSizePrefixDisabled(this.sizePrefixDisabled);
            info.setMaxInactivityDuration(this.maxInactivityDuration);
            info.setMaxInactivityDurationInitalDelay(this.maxInactivityDurationInitalDelay);
            info.setCacheSize(this.cacheSize);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Could not configure WireFormatInfo");
            ise.initCause(e);
            throw ise;
        }
        OpenWireFormat f = new OpenWireFormat();
        f.setPreferedWireFormatInfo(info);
        return f;
    }

    public boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public void setStackTraceEnabled(boolean stackTraceEnabled) {
        this.stackTraceEnabled = stackTraceEnabled;
    }

    public boolean isTcpNoDelayEnabled() {
        return this.tcpNoDelayEnabled;
    }

    public void setTcpNoDelayEnabled(boolean tcpNoDelayEnabled) {
        this.tcpNoDelayEnabled = tcpNoDelayEnabled;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isTightEncodingEnabled() {
        return this.tightEncodingEnabled;
    }

    public void setTightEncodingEnabled(boolean tightEncodingEnabled) {
        this.tightEncodingEnabled = tightEncodingEnabled;
    }

    public boolean isSizePrefixDisabled() {
        return this.sizePrefixDisabled;
    }

    public void setSizePrefixDisabled(boolean sizePrefixDisabled) {
        this.sizePrefixDisabled = sizePrefixDisabled;
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public long getMaxInactivityDurationInitalDelay() {
        return this.maxInactivityDurationInitalDelay;
    }

    public void setMaxInactivityDurationInitalDelay(long maxInactivityDurationInitalDelay) {
        this.maxInactivityDurationInitalDelay = maxInactivityDurationInitalDelay;
    }
}

