/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.TmqiQueue;
import com.tongtech.remote.protocol.command.TmqiTempQueue;
import com.tongtech.remote.protocol.command.TmqiTempTopic;
import com.tongtech.remote.protocol.command.TmqiTopic;

public abstract class Destination
implements DataStructure {
    public static final int DEST_TYPE_QUEUE = 1;
    public static final int DEST_TYPE_TOPIC = 2;
    public static final int DEST_TEMP = 16;
    protected String DestinationName;
    protected String DestinationClass;
    protected byte[] propertyData;
    protected int DestinationType;

    public byte[] getPropertyData() {
        return this.propertyData;
    }

    public void setPropertyData(byte[] propertyData) {
        this.propertyData = propertyData;
    }

    public String getDestinationClass() {
        if (this instanceof TmqiQueue) {
            return "com.tongtech.tmqi.Queue";
        }
        if (this instanceof TmqiTempQueue) {
            return "com.tongtech.tmqi.jmsclient.TemporaryQueueImpl";
        }
        if (this instanceof TmqiTopic) {
            return "com.tongtech.tmqi.Topic";
        }
        return "com.tongtech.tmqi.jmsclient.TemporaryTopicImpl";
    }

    public void setDestinationClass(String destinationClass) {
        this.DestinationClass = destinationClass;
    }

    public Destination() {
    }

    protected Destination(String destinationName) {
        this.DestinationName = destinationName;
    }

    public static Destination createDestination(String DestinationName2, int DestinationType) {
        if (Destination.isQueue(DestinationType)) {
            if (Destination.isTemporary(DestinationType)) {
                return new TmqiTempQueue(DestinationName2);
            }
            return new TmqiQueue(DestinationName2);
        }
        if (Destination.isTopic(DestinationType)) {
            if (Destination.isTemporary(DestinationType)) {
                return new TmqiTempTopic(DestinationName2);
            }
            return new TmqiTopic(DestinationName2);
        }
        return null;
    }

    public String toString() {
        return " [DestinationClass=" + this.DestinationClass + ", DestinationName=" + this.DestinationName + "]";
    }

    public static boolean isQueue(int mask) {
        return (mask & 1) == 1;
    }

    public static boolean isTopic(int mask) {
        return (mask & 2) == 2;
    }

    public static boolean isTemporary(int mask) {
        return (mask & 0x10) == 16;
    }

    public String getDestinationName() {
        return this.DestinationName;
    }

    public void setDestinationName(String destinationName) {
        this.DestinationName = destinationName;
    }

    public int getDestinationType() {
        return this.DestinationType;
    }

    public void setDestinationType(int destinationType) {
        this.DestinationType = destinationType;
    }

    @Override
    public abstract byte getDataStructureType();

    @Override
    public boolean isMarshallAware() {
        return false;
    }
}

