/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.protocol.util.ByteSequence;
import com.tongtech.protocol.util.TlqKnlMessagePropertiesUtil;
import com.tongtech.protocol.wireformat.WireFormat;
import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.BaseMessage;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.MarshallAware;
import com.tongtech.remote.protocol.command.TransactionId;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class Message
extends BaseMessage
implements MarshallAware {
    public static final byte DATA_STRUCTURE_TYPE = 23;
    public static final int DEFAULT_MINIMUM_MESSAGE_SIZE = 1024;
    protected TransactionId transactionId;
    protected long expiration;
    protected long timestamp;
    protected String correlationId;
    protected Destination replyTo;
    protected boolean persistent;
    protected String type;
    protected byte priority;
    protected String groupID;
    protected int groupSequence;
    protected boolean compressed;
    protected int redeliveryCounter;
    protected int msgSize;
    protected int propSize;
    protected int propNum;
    protected byte[] usrContext;
    protected Hashtable properties;
    protected int MessageType;
    protected byte[] content;
    protected byte[] marshalledProperties;
    protected transient boolean recievedByDFBridge;

    public int getMsgSize() {
        return this.msgSize;
    }

    public void setMsgSize(int msgSize) {
        this.msgSize = msgSize;
    }

    public int getPropSize() {
        return this.propSize;
    }

    public void setPropSize(int propSize) {
        this.propSize = propSize;
    }

    public int getMessageType() {
        return this.MessageType;
    }

    public void setMessageType(int messageType) {
        this.MessageType = messageType;
    }

    public int getPropNum() {
        return this.propNum;
    }

    public void setPropNum(int propNum) {
        this.propNum = propNum;
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    protected void copy(Message copy) {
        super.copy(copy);
        copy.producerId = this.producerId;
        copy.transactionId = this.transactionId;
        copy.destination = this.destination;
        copy.messageId = this.messageId != null ? this.messageId.copy() : null;
        copy.expiration = this.expiration;
        copy.timestamp = this.timestamp;
        copy.correlationId = this.correlationId;
        copy.replyTo = this.replyTo;
        copy.persistent = this.persistent;
        copy.priority = this.priority;
        copy.msgSize = this.msgSize;
        copy.groupID = this.groupID;
        copy.groupSequence = this.groupSequence;
        copy.properties = this.properties != null ? new Hashtable(this.properties) : this.properties;
        copy.content = this.content;
        copy.marshalledProperties = this.marshalledProperties;
        copy.compressed = this.compressed;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return null;
            }
            this.properties = TlqKnlMessagePropertiesUtil.getProperties(this.marshalledProperties, this.propSize);
        }
        return this.properties.get(name);
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return new Properties();
            }
            this.properties = TlqKnlMessagePropertiesUtil.getProperties(this.marshalledProperties, this.propSize);
        }
        return this.properties;
    }

    public void clearProperties() {
        this.marshalledProperties = null;
        this.properties = null;
    }

    public void setProperty(String name, Object value) {
        this.lazyCreateProperties();
        this.properties.put(name, value);
    }

    protected void lazyCreateProperties() {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                this.properties = new Hashtable();
            } else {
                this.properties = TlqKnlMessagePropertiesUtil.getProperties(this.marshalledProperties, this.propSize);
                this.marshalledProperties = null;
            }
        }
    }

    private Hashtable unmarsallProperties(ByteSequence marshalledProperties) throws IOException {
        return null;
    }

    @Override
    public void beforeMarshall(WireFormat wireFormat) throws IOException {
        if (this.properties != null) {
            JMQByteArrayOutputStream os = new JMQByteArrayOutputStream(new byte[100]);
            TlqKnlMessagePropertiesUtil.getByte((Map)this.properties, os);
            this.marshalledProperties = os.getBuf();
            this.propNum = this.properties.size();
            this.propSize = os.getCount();
        }
    }

    @Override
    public void afterMarshall(WireFormat wireFormat) throws IOException {
    }

    @Override
    public void beforeUnmarshall(WireFormat wireFormat) throws IOException {
    }

    @Override
    public void afterUnmarshall(WireFormat wireFormat) throws IOException {
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(TransactionId transactionId) {
        this.transactionId = transactionId;
    }

    public boolean isInTransaction() {
        return this.transactionId != null;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public int getGroupSequence() {
        return this.groupSequence;
    }

    public void setGroupSequence(int groupSequence) {
        this.groupSequence = groupSequence;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean deliveryMode) {
        this.persistent = deliveryMode;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public Destination getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isExpired() {
        long expireTime = this.getExpiration();
        return expireTime > 0L && System.currentTimeMillis() > expireTime;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isRedelivered() {
        return this.redeliveryCounter > 0;
    }

    public void setRedelivered(boolean redelivered) {
        if (redelivered) {
            if (!this.isRedelivered()) {
                this.setRedeliveryCounter(1);
            }
        } else if (this.isRedelivered()) {
            this.setRedeliveryCounter(0);
        }
    }

    public void incrementRedeliveryCounter() {
        ++this.redeliveryCounter;
    }

    public int getRedeliveryCounter() {
        return this.redeliveryCounter;
    }

    public void setRedeliveryCounter(int deliveryCounter) {
        this.redeliveryCounter = deliveryCounter;
    }

    public Message getMessageHardRef() {
        return this;
    }

    public Message getMessage() throws IOException {
        return this;
    }

    @Override
    public boolean isMarshallAware() {
        return true;
    }

    public boolean isRecievedByDFBridge() {
        return this.recievedByDFBridge;
    }

    public void setRecievedByDFBridge(boolean recievedByDFBridge) {
        this.recievedByDFBridge = recievedByDFBridge;
    }

    public void onMessageRolledBack() {
        this.incrementRedeliveryCounter();
    }

    @Override
    public boolean isMessage() {
        return true;
    }

    public byte[] getUsrContext() {
        return this.usrContext;
    }

    public void setUsrContext(byte[] usrContext) {
        this.usrContext = usrContext;
    }

    public boolean isDropped() {
        return false;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Map overrideFields) {
        return super.toString(overrideFields);
    }

    @Override
    public byte getDataStructureType() {
        return 23;
    }

    @Override
    public byte[] getMarshalledProperties() {
        return this.marshalledProperties;
    }

    @Override
    public void setMarshalledProperties(byte[] marshalledProperties) {
        this.marshalledProperties = marshalledProperties;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public void tightMarshalBaseMessagePropertiesUserDef(DataStructure info, DataOutput dataOut, BooleanStream bs) throws IOException {
    }

    @Override
    public void tightMarshalBaseMessageContentUserDef(DataStructure info, DataOutput dataOut, BooleanStream bs) throws IOException {
        Message message = (Message)info;
        boolean haveProperties = false;
        boolean havaContent = false;
        if (bs.readBoolean()) {
            dataOut.writeInt(message.getMarshalledProperties().length);
            haveProperties = true;
        }
        if (bs.readBoolean()) {
            dataOut.writeInt(message.getContent().length);
            havaContent = true;
        }
        if (haveProperties) {
            dataOut.write(message.getMarshalledProperties());
        }
        if (havaContent) {
            dataOut.write(message.getContent());
        }
    }

    @Override
    public void looseMarshalBaseMessagePropertiesUserDef(OpenWireFormat wireFormat, DataStructure info, DataOutput dataOut) throws IOException {
    }

    @Override
    public void looseMarshalBaseMessageContentUserDef(OpenWireFormat wireFormat, DataStructure info, DataOutput dataOut) throws IOException {
        Message message = (Message)info;
        boolean haveProperties = false;
        boolean havaContent = false;
        if (message.getMarshalledProperties() != null) {
            dataOut.writeShort(message.getMarshalledProperties().length);
            haveProperties = true;
        }
        if (message.getContent() != null) {
            dataOut.writeShort(message.getContent().length);
            havaContent = true;
        }
        if (haveProperties) {
            dataOut.write(message.getMarshalledProperties());
        }
        if (havaContent) {
            dataOut.write(message.getContent());
        }
    }

    @Override
    public void tightUnMarshalBaseMessagePropertiesUserDef(DataStructure info, DataInput dataIn, BooleanStream bs) throws IOException {
    }

    @Override
    public void tightUnMarshalBaseMessageContentUserDef(DataStructure info, DataInput dataIn, BooleanStream bs) throws IOException {
        Message message = (Message)info;
        boolean hasProperties = false;
        boolean hasContent = false;
        int propertiesSize = 0;
        int contentSize = 0;
        if (bs.readBoolean()) {
            propertiesSize = dataIn.readInt();
            hasProperties = true;
        }
        if (bs.readBoolean()) {
            contentSize = dataIn.readInt();
            hasContent = true;
        }
        if (hasProperties) {
            byte[] properties = new byte[propertiesSize];
            dataIn.readFully(properties);
            message.setMarshalledProperties(properties);
        }
        if (hasContent) {
            byte[] content = new byte[contentSize];
            dataIn.readFully(content);
            message.setContent(content);
        }
    }

    @Override
    public void looseUnMarshalBaseMessagePropertiesUserDef(DataStructure info, DataInput dataIn) throws IOException {
    }

    @Override
    public void looseUnMarshalBaseMessageContentUserDef(DataStructure info, DataInput dataIn) throws IOException {
        Message message = (Message)info;
        boolean hasProperties = false;
        boolean hasContent = false;
        int propertiesSize = 0;
        int contentSize = 0;
        if (dataIn.readBoolean()) {
            propertiesSize = dataIn.readInt();
            hasProperties = true;
        }
        if (dataIn.readBoolean()) {
            contentSize = dataIn.readInt();
            hasContent = true;
        }
        if (hasProperties) {
            byte[] properties = new byte[propertiesSize];
            dataIn.readFully(properties);
            message.setMarshalledProperties(properties);
        }
        if (hasContent) {
            byte[] content = new byte[contentSize];
            dataIn.readFully(content);
            message.setContent(content);
        }
    }
}

