/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.BaseMessage;
import com.tongtech.remote.protocol.command.DataStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PartialMessage
extends BaseMessage {
    public static final byte DATA_STRUCTURE_TYPE = 60;
    protected byte[] content;
    protected byte[] marshalledProperties;

    @Override
    public byte getDataStructureType() {
        return 60;
    }

    @Override
    public byte[] getMarshalledProperties() {
        return this.marshalledProperties;
    }

    @Override
    public void setMarshalledProperties(byte[] marshalledProperties) {
        this.marshalledProperties = marshalledProperties;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public void tightMarshalBaseMessagePropertiesUserDef(DataStructure info, DataOutput dataOut, BooleanStream bs) throws IOException {
    }

    @Override
    public void tightMarshalBaseMessageContentUserDef(DataStructure info, DataOutput dataOut, BooleanStream bs) throws IOException {
        PartialMessage message = (PartialMessage)info;
        boolean haveProperties = false;
        boolean havaContent = false;
        if (bs.readBoolean()) {
            dataOut.writeShort(message.getMarshalledProperties().length);
            haveProperties = true;
        }
        if (bs.readBoolean()) {
            dataOut.writeShort(message.getContent().length);
            havaContent = true;
        }
        if (haveProperties) {
            dataOut.write(message.getMarshalledProperties());
        }
        if (havaContent) {
            dataOut.write(message.getContent());
        }
    }

    @Override
    public void looseMarshalBaseMessagePropertiesUserDef(OpenWireFormat wireFormat, DataStructure info, DataOutput dataOut) throws IOException {
    }

    @Override
    public void looseMarshalBaseMessageContentUserDef(OpenWireFormat wireFormat, DataStructure info, DataOutput dataOut) throws IOException {
        PartialMessage message = (PartialMessage)info;
        boolean haveProperties = false;
        boolean havaContent = false;
        if (message.getMarshalledProperties() != null) {
            dataOut.writeShort(message.getMarshalledProperties().length);
            haveProperties = true;
        }
        if (message.getContent() != null) {
            dataOut.writeShort(message.getContent().length);
            havaContent = true;
        }
        if (haveProperties) {
            dataOut.write(message.getMarshalledProperties());
        }
        if (havaContent) {
            dataOut.write(message.getContent());
        }
    }

    @Override
    public void tightUnMarshalBaseMessagePropertiesUserDef(DataStructure info, DataInput dataIn, BooleanStream bs) throws IOException {
    }

    @Override
    public void tightUnMarshalBaseMessageContentUserDef(DataStructure info, DataInput dataIn, BooleanStream bs) throws IOException {
        PartialMessage message = (PartialMessage)info;
        boolean hasProperties = false;
        boolean hasContent = false;
        int propertiesSize = 0;
        int contentSize = 0;
        if (bs.readBoolean()) {
            propertiesSize = dataIn.readInt();
            hasProperties = true;
        }
        if (bs.readBoolean()) {
            contentSize = dataIn.readInt();
            hasContent = true;
        }
        if (hasProperties) {
            byte[] properties = new byte[propertiesSize];
            dataIn.readFully(properties);
            message.setMarshalledProperties(properties);
        }
        if (hasContent) {
            byte[] content = new byte[contentSize];
            dataIn.readFully(content);
            message.setContent(content);
        }
    }

    @Override
    public void looseUnMarshalBaseMessagePropertiesUserDef(DataStructure info, DataInput dataIn) throws IOException {
    }

    @Override
    public void looseUnMarshalBaseMessageContentUserDef(DataStructure info, DataInput dataIn) throws IOException {
        PartialMessage message = (PartialMessage)info;
        boolean hasProperties = false;
        boolean hasContent = false;
        int propertiesSize = 0;
        int contentSize = 0;
        if (dataIn.readBoolean()) {
            propertiesSize = dataIn.readInt();
            hasProperties = true;
        }
        if (dataIn.readBoolean()) {
            contentSize = dataIn.readInt();
            hasContent = true;
        }
        if (hasProperties) {
            byte[] properties = new byte[propertiesSize];
            dataIn.readFully(properties);
            message.setMarshalledProperties(properties);
        }
        if (hasContent) {
            byte[] content = new byte[contentSize];
            dataIn.readFully(content);
            message.setContent(content);
        }
    }
}

