/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.remote.protocol.command.BaseCommand;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.remote.protocol.command.RemoveInfo;
import com.tongtech.remote.protocol.command.SessionInfo;

public class ProducerInfo
extends BaseCommand {
    public static final byte DATA_STRUCTURE_TYPE = 6;
    protected ProducerId producerId;
    protected Destination destination;
    protected boolean dispatchAsync;
    protected int windowSize;

    public ProducerInfo() {
    }

    public ProducerInfo(ProducerId producerId) {
        this.producerId = producerId;
    }

    public ProducerInfo(SessionInfo sessionInfo, int producerId) {
        this.producerId = new ProducerId(sessionInfo.getSessionId(), producerId);
    }

    public ProducerInfo copy() {
        ProducerInfo info = new ProducerInfo();
        this.copy(info);
        return info;
    }

    public void copy(ProducerInfo info) {
        super.copy(info);
        info.producerId = this.producerId;
        info.destination = this.destination;
    }

    @Override
    public byte getDataStructureType() {
        return 6;
    }

    public ProducerId getProducerId() {
        return this.producerId;
    }

    public void setProducerId(ProducerId producerId) {
        this.producerId = producerId;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public RemoveInfo createRemoveCommand() {
        RemoveInfo command = new RemoveInfo(this.getProducerId());
        command.setResponseRequired(this.isResponseRequired());
        return command;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }
}

