/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.remote.protocol.command.ConnectionId;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.ProducerId;

public class SessionId
implements DataStructure {
    public static final byte DATA_STRUCTURE_TYPE = 121;
    protected short connectionId;
    protected int value;
    protected transient int hashCode;
    protected transient String key;
    protected transient ConnectionId parentId;

    public SessionId() {
    }

    public SessionId(ConnectionId connectionId, int sessionId) {
        this.connectionId = connectionId.getValue();
        this.value = sessionId;
    }

    public SessionId(SessionId id) {
        this.connectionId = id.getConnectionId();
        this.value = id.getValue();
    }

    public SessionId(ProducerId id) {
        this.connectionId = id.getConnectionId();
        this.value = id.getSessionId();
    }

    public SessionId(ConsumerId id) {
        this.connectionId = id.getConnectionId();
        this.value = id.getSessionId();
    }

    public ConnectionId getParentId() {
        if (this.parentId == null) {
            this.parentId = new ConnectionId(this);
        }
        return this.parentId;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.value;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != SessionId.class) {
            return false;
        }
        SessionId id = (SessionId)o;
        return this.value == id.value;
    }

    @Override
    public byte getDataStructureType() {
        return 121;
    }

    public short getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(short connectionId) {
        this.connectionId = connectionId;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int sessionId) {
        this.value = sessionId;
    }

    public String toString() {
        if (this.key == null) {
            this.key = "" + this.value;
        }
        return this.key;
    }

    @Override
    public boolean isMarshallAware() {
        return false;
    }
}

