/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.protocol.util.ByteArrayInputStream;
import com.tongtech.protocol.util.ByteArrayOutputStream;
import com.tongtech.protocol.util.ByteSequence;
import com.tongtech.protocol.util.MarshallingSupport;
import com.tongtech.protocol.wireformat.WireFormat;
import com.tongtech.remote.protocol.command.BaseCommand;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.MarshallAware;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WireFormatInfo
extends BaseCommand
implements Command,
MarshallAware {
    public static final byte DATA_STRUCTURE_TYPE = 1;
    private static final int MAX_PROPERTY_SIZE = 4096;
    private static final byte[] MAGIC = new byte[]{84, 111, 110, 103, 95, 74, 77, 83};
    protected byte[] magic = MAGIC;
    protected int version;
    protected byte endian;
    protected byte type;
    protected boolean isLocalFile;
    protected byte[] rsrv;
    protected ByteSequence marshalledProperties;
    protected transient Map properties;

    @Override
    public byte getDataStructureType() {
        return 1;
    }

    @Override
    public boolean isWireFormatInfo() {
        return true;
    }

    @Override
    public boolean isMarshallAware() {
        return true;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public void setMagic(byte[] magic) {
        this.magic = magic;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    public void setLocalFile(boolean b) {
        this.isLocalFile = b;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public ByteSequence getMarshalledProperties() {
        return this.marshalledProperties;
    }

    public void setMarshalledProperties(ByteSequence marshalledProperties) {
        this.marshalledProperties = marshalledProperties;
    }

    public Object getProperty(String name) throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return null;
            }
            this.properties = this.unmarsallProperties(this.marshalledProperties);
        }
        return this.properties.get(name);
    }

    public Map getProperties() throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return Collections.EMPTY_MAP;
            }
            this.properties = this.unmarsallProperties(this.marshalledProperties);
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public void clearProperties() {
        this.marshalledProperties = null;
        this.properties = null;
    }

    public void setProperty(String name, Object value) throws IOException {
        this.lazyCreateProperties();
        this.properties.put(name, value);
    }

    protected void lazyCreateProperties() throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                this.properties = new HashMap();
            } else {
                this.properties = this.unmarsallProperties(this.marshalledProperties);
                this.marshalledProperties = null;
            }
        }
    }

    private Map unmarsallProperties(ByteSequence marshalledProperties) throws IOException {
        return MarshallingSupport.unmarshalPrimitiveMap(new DataInputStream(new ByteArrayInputStream(marshalledProperties)), 4096);
    }

    @Override
    public void beforeMarshall(WireFormat wireFormat) throws IOException {
        if (this.marshalledProperties == null && this.properties != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            MarshallingSupport.marshalPrimitiveMap(this.properties, os);
            os.close();
            this.marshalledProperties = baos.toByteSequence();
        }
    }

    @Override
    public void afterMarshall(WireFormat wireFormat) throws IOException {
    }

    @Override
    public void beforeUnmarshall(WireFormat wireFormat) throws IOException {
    }

    @Override
    public void afterUnmarshall(WireFormat wireFormat) throws IOException {
    }

    public boolean isValid() {
        return this.magic != null && Arrays.equals(this.magic, MAGIC);
    }

    @Override
    public void setResponseRequired(boolean responseRequired) {
    }

    public boolean isCacheEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("CacheEnabled");
    }

    public void setCacheEnabled(boolean cacheEnabled) throws IOException {
        this.setProperty("CacheEnabled", cacheEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isStackTraceEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("StackTraceEnabled");
    }

    public void setStackTraceEnabled(boolean stackTraceEnabled) throws IOException {
        this.setProperty("StackTraceEnabled", stackTraceEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTcpNoDelayEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("TcpNoDelayEnabled");
    }

    public void setTcpNoDelayEnabled(boolean tcpNoDelayEnabled) throws IOException {
        this.setProperty("TcpNoDelayEnabled", tcpNoDelayEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isSizePrefixDisabled() throws IOException {
        return Boolean.TRUE == this.getProperty("SizePrefixDisabled");
    }

    public void setSizePrefixDisabled(boolean prefixPacketSize) throws IOException {
        this.setProperty("SizePrefixDisabled", prefixPacketSize ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTightEncodingEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("TightEncodingEnabled");
    }

    public void setTightEncodingEnabled(boolean tightEncodingEnabled) throws IOException {
        this.setProperty("TightEncodingEnabled", tightEncodingEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public long getMaxInactivityDuration() throws IOException {
        Long l = (Long)this.getProperty("MaxInactivityDuration");
        return l == null ? 0L : l;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) throws IOException {
        this.setProperty("MaxInactivityDuration", new Long(maxInactivityDuration));
    }

    public long getMaxInactivityDurationInitalDelay() throws IOException {
        Long l = (Long)this.getProperty("MaxInactivityDurationInitalDelay");
        return l == null ? 0L : l;
    }

    public void setMaxInactivityDurationInitalDelay(long maxInactivityDurationInitalDelay) throws IOException {
        this.setProperty("MaxInactivityDurationInitalDelay", new Long(maxInactivityDurationInitalDelay));
    }

    public int getCacheSize() throws IOException {
        Integer i = (Integer)this.getProperty("CacheSize");
        return i == null ? 0 : i;
    }

    public void setCacheSize(int cacheSize) throws IOException {
        this.setProperty("CacheSize", new Integer(cacheSize));
    }

    @Override
    public String toString() {
        Map p = null;
        try {
            p = this.getProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "WireFormatInfo { commandId=" + this.commandId + ", version=" + this.version + ", properties=" + p + ", magic=" + this.toString(this.magic) + ", isLocalFile=" + this.isLocalFile + "}";
    }

    private String toString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append((char)data[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean isResponseRequired() {
        return false;
    }

    @Override
    public boolean isResponse() {
        return false;
    }

    @Override
    public boolean isBrokerInfo() {
        return false;
    }

    @Override
    public boolean isMessageDispatch() {
        return false;
    }

    @Override
    public boolean isMessage() {
        return false;
    }

    @Override
    public boolean isMessageAck() {
        return false;
    }

    @Override
    public boolean isMessageDispatchNotification() {
        return false;
    }

    @Override
    public boolean isShutdownInfo() {
        return false;
    }

    public void setCachedMarshalledForm(WireFormat wireFormat, ByteSequence data) {
    }

    public ByteSequence getCachedMarshalledForm(WireFormat wireFormat) {
        return null;
    }

    public byte[] getRsrv() {
        return this.rsrv;
    }

    public void setRsrv(byte[] rsrv) {
        this.rsrv = rsrv;
    }

    public byte getEndian() {
        return this.endian;
    }

    public void setEndian(byte endian) {
        this.endian = endian;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }
}

