/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.command;

import com.tongtech.remote.protocol.command.TransactionId;
import com.tongtech.tmqi.util.HexSupport;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XATransactionId
extends TransactionId
implements Xid,
Comparable {
    public static final byte DATA_STRUCTURE_TYPE = 112;
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;
    private int value;
    private transient int hash;
    private transient String transactionKey;

    public XATransactionId() {
    }

    public XATransactionId(Xid xid, int transactionId) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
        this.value = transactionId;
    }

    @Override
    public byte getDataStructureType() {
        return 112;
    }

    @Override
    public synchronized String getTransactionKey() {
        if (this.transactionKey == null) {
            this.transactionKey = "XID:" + this.formatId + ":" + HexSupport.toHexFromBytes(this.globalTransactionId) + ":" + HexSupport.toHexFromBytes(this.branchQualifier);
        }
        return this.transactionKey;
    }

    public String toString() {
        return this.getTransactionKey();
    }

    @Override
    public boolean isXATransaction() {
        return true;
    }

    @Override
    public boolean isLocalTransaction() {
        return false;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public void setBranchQualifier(byte[] branchQualifier) {
        this.branchQualifier = branchQualifier;
        this.hash = 0;
    }

    public void setFormatId(int formatId) {
        this.formatId = formatId;
        this.hash = 0;
    }

    public void setGlobalTransactionId(byte[] globalTransactionId) {
        this.globalTransactionId = globalTransactionId;
        this.hash = 0;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.formatId;
            this.hash = XATransactionId.hash(this.globalTransactionId, this.hash);
            this.hash = XATransactionId.hash(this.branchQualifier, this.hash);
            if (this.hash == 0) {
                this.hash = 0xACEACE;
            }
        }
        return this.hash;
    }

    private static int hash(byte[] bytes, int hash) {
        int size = bytes.length;
        for (int i = 0; i < size; ++i) {
            hash ^= bytes[i] << i % 4 * 8;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != XATransactionId.class) {
            return false;
        }
        XATransactionId xid = (XATransactionId)o;
        return xid.formatId == this.formatId && Arrays.equals(xid.globalTransactionId, this.globalTransactionId) && Arrays.equals(xid.branchQualifier, this.branchQualifier);
    }

    public int compareTo(Object o) {
        if (o == null || o.getClass() != XATransactionId.class) {
            return -1;
        }
        XATransactionId xid = (XATransactionId)o;
        return this.getTransactionKey().compareTo(xid.getTransactionKey());
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int transactionId) {
        this.value = transactionId;
    }
}

