/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ClientIdInfo;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClientIdInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 104;
    }

    @Override
    public DataStructure createObject() {
        return new ClientIdInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ClientIdInfo info = (ClientIdInfo)o;
        info.setClientOperate(dataIn.readShort());
        info.setValue(this.tightUnmarshalString(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ClientIdInfo info = (ClientIdInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalString1(info.getValue(), bs)) + 2;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ClientIdInfo info = (ClientIdInfo)o;
        dataOut.writeShort(info.getClientOperate());
        this.tightMarshalString2(info.getValue(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ClientIdInfo info = (ClientIdInfo)o;
        info.setClientOperate(dataIn.readShort());
        info.setValue(this.looseUnmarshalString(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ClientIdInfo info = (ClientIdInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeShort(info.getClientOperate());
        this.looseMarshalString(info.getValue(), dataOut);
    }
}

