/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConnectionId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.v3.BaseDataStreamMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConnectionIdMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 120;
    }

    @Override
    public DataStructure createObject() {
        return new ConnectionId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ConnectionId info = (ConnectionId)o;
        info.setValue(dataIn.readShort());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConnectionId info = (ConnectionId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return rc + 2;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ConnectionId info = (ConnectionId)o;
        dataOut.writeShort(info.getValue());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ConnectionId info = (ConnectionId)o;
        info.setValue(dataIn.readShort());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ConnectionId info = (ConnectionId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeShort(info.getValue());
    }
}

