/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.LongInfo;
import com.tongtech.remote.protocol.command.MessageAck;
import com.tongtech.remote.protocol.command.TransactionId;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MessageAckMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 22;
    }

    @Override
    public DataStructure createObject() {
        return new MessageAck();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        int i;
        DataStructure[] value;
        int size;
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MessageAck info = (MessageAck)o;
        if (bs.readBoolean()) {
            size = dataIn.readShort();
            value = new ConsumerId[size];
            for (i = 0; i < size; ++i) {
                value[i] = (ConsumerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setConsumerIds((ConsumerId[])value);
        } else {
            info.setConsumerIds(null);
        }
        if (bs.readBoolean()) {
            size = dataIn.readShort();
            value = new LongInfo[size];
            for (i = 0; i < size; ++i) {
                value[i] = (LongInfo)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setSeqIds((LongInfo[])value);
        } else {
            info.setSeqIds(null);
        }
        info.setTransactionId((TransactionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setAckType(dataIn.readByte());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageAck info = (MessageAck)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalObjectArray1(wireFormat, info.getConsumerIds(), bs);
        rc += this.tightMarshalObjectArray1(wireFormat, info.getSeqIds(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getTransactionId(), bs);
        return (rc += this.tightMarshalCachedObject1(wireFormat, info.getConsumerId(), bs)) + 1;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MessageAck info = (MessageAck)o;
        this.tightMarshalObjectArray2(wireFormat, info.getConsumerIds(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info.getSeqIds(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getTransactionId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getConsumerId(), dataOut, bs);
        dataOut.writeByte(info.getAckType());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        int i;
        DataStructure[] value;
        int size;
        super.looseUnmarshal(wireFormat, o, dataIn);
        MessageAck info = (MessageAck)o;
        if (dataIn.readBoolean()) {
            size = dataIn.readShort();
            value = new ConsumerId[size];
            for (i = 0; i < size; ++i) {
                value[i] = (ConsumerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info.setConsumerIds((ConsumerId[])value);
        } else {
            info.setConsumerIds(null);
        }
        if (dataIn.readBoolean()) {
            size = dataIn.readShort();
            value = new LongInfo[size];
            for (i = 0; i < size; ++i) {
                value[i] = (LongInfo)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info.setSeqIds((LongInfo[])value);
        } else {
            info.setSeqIds(null);
        }
        info.setTransactionId((TransactionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setAckType(dataIn.readByte());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MessageAck info = (MessageAck)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalObjectArray(wireFormat, info.getConsumerIds(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info.getSeqIds(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getTransactionId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getConsumerId(), dataOut);
        dataOut.writeByte(info.getAckType());
    }
}

