/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.remote.protocol.command.MessagePull;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MessagePullMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 20;
    }

    @Override
    public DataStructure createObject() {
        return new MessagePull();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MessagePull info = (MessagePull)o;
        info.setConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setDestination((Destination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setCorrelationId(this.tightUnmarshalString(dataIn, bs));
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            MessageId[] value = new MessageId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setMessageId(value);
        } else {
            info.setMessageId(null);
        }
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessagePull info = (MessagePull)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getConsumerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getDestination(), bs);
        rc += this.tightMarshalString1(info.getCorrelationId(), bs);
        return (rc += this.tightMarshalObjectArray1(wireFormat, info.getMessageId(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MessagePull info = (MessagePull)o;
        this.tightMarshalCachedObject2(wireFormat, info.getConsumerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info.getDestination(), dataOut, bs);
        this.tightMarshalString2(info.getCorrelationId(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info.getMessageId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        MessagePull info = (MessagePull)o;
        info.setConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setDestination((Destination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setCorrelationId(this.looseUnmarshalString(dataIn));
        if (dataIn.readBoolean()) {
            int size = dataIn.readShort();
            MessageId[] value = new MessageId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info.setMessageId(value);
        } else {
            info.setMessageId(null);
        }
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MessagePull info = (MessagePull)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getConsumerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getDestination(), dataOut);
        this.looseMarshalString(info.getCorrelationId(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info.getMessageId(), dataOut);
    }
}

