/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.LongInfo;
import com.tongtech.remote.protocol.command.Redeliver;
import com.tongtech.remote.protocol.command.TransactionId;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RedeliverMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 81;
    }

    @Override
    public DataStructure createObject() {
        return new Redeliver();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        int i;
        DataStructure[] value;
        int size;
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        Redeliver info = (Redeliver)o;
        info.setRedelivered(bs.readBoolean());
        info.setTransactionId((TransactionId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        if (bs.readBoolean()) {
            size = dataIn.readShort();
            value = new ConsumerId[size];
            for (i = 0; i < size; ++i) {
                value[i] = (ConsumerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setConsumerId((ConsumerId[])value);
        } else {
            info.setConsumerId(null);
        }
        if (bs.readBoolean()) {
            size = dataIn.readShort();
            value = new LongInfo[size];
            for (i = 0; i < size; ++i) {
                value[i] = (LongInfo)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setSeqIds((LongInfo[])value);
        } else {
            info.setSeqIds(null);
        }
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        Redeliver info = (Redeliver)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        bs.writeBoolean(info.isRedelivered());
        rc += this.tightMarshalNestedObject1(wireFormat, info.getTransactionId(), bs);
        rc += this.tightMarshalObjectArray1(wireFormat, info.getConsumerId(), bs);
        return (rc += this.tightMarshalObjectArray1(wireFormat, info.getSeqIds(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        Redeliver info = (Redeliver)o;
        bs.readBoolean();
        this.tightMarshalNestedObject2(wireFormat, info.getTransactionId(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info.getConsumerId(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info.getSeqIds(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        int i;
        DataStructure[] value;
        int size;
        super.looseUnmarshal(wireFormat, o, dataIn);
        Redeliver info = (Redeliver)o;
        info.setRedelivered(dataIn.readBoolean());
        info.setTransactionId((TransactionId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        if (dataIn.readBoolean()) {
            size = dataIn.readShort();
            value = new ConsumerId[size];
            for (i = 0; i < size; ++i) {
                value[i] = (ConsumerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info.setConsumerId((ConsumerId[])value);
        } else {
            info.setConsumerId(null);
        }
        if (dataIn.readBoolean()) {
            size = dataIn.readShort();
            value = new LongInfo[size];
            for (i = 0; i < size; ++i) {
                value[i] = (LongInfo)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info.setSeqIds((LongInfo[])value);
        } else {
            info.setSeqIds(null);
        }
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        Redeliver info = (Redeliver)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeBoolean(info.isRedelivered());
        this.looseMarshalNestedObject(wireFormat, info.getTransactionId(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info.getConsumerId(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info.getSeqIds(), dataOut);
    }
}

