/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Response;
import com.tongtech.remote.protocol.v3.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ResponseMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 30;
    }

    @Override
    public DataStructure createObject() {
        return new Response();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        Response info = (Response)o;
        info.setRequestCommandType(dataIn.readByte());
        info.setCorrelationId(dataIn.readInt());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        Response info = (Response)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return rc + 5;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        Response info = (Response)o;
        dataOut.writeByte(info.getRequestCommandType());
        dataOut.writeInt(info.getCorrelationId());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        Response info = (Response)o;
        info.setRequestCommandType(dataIn.readByte());
        info.setCorrelationId(dataIn.readInt());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        Response info = (Response)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeByte(info.getRequestCommandType());
        dataOut.writeInt(info.getCorrelationId());
    }
}

