/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.remote.protocol.v3;

import com.tongtech.remote.protocol.BooleanStream;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.StringRRResponse;
import com.tongtech.remote.protocol.v3.BaseDataStreamMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringRRResponseMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 35;
    }

    @Override
    public DataStructure createObject() {
        return new StringRRResponse();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        StringRRResponse info = (StringRRResponse)o;
        info.setResult(dataIn.readInt());
        info.setInfo(this.tightUnmarshalString(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        StringRRResponse info = (StringRRResponse)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalString1(info.getInfo(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        StringRRResponse info = (StringRRResponse)o;
        dataOut.writeInt(info.getResult());
        this.tightMarshalString2(info.getInfo(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        StringRRResponse info = (StringRRResponse)o;
        info.setResult(dataIn.readInt());
        info.setInfo(this.looseUnmarshalString(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        StringRRResponse info = (StringRRResponse)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getResult());
        this.looseMarshalString(info.getInfo(), dataOut);
    }
}

