/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tlq.basement;

import com.tongtech.tlq.basement.TlqMessage;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

class KnlMessageProperties {
    private static final int CHARLENGTH = 1;

    KnlMessageProperties() {
    }

    public static Properties getProperties(byte[] propertiesData, int len) {
        Properties properties = new Properties();
        if (null == propertiesData || propertiesData.length < 27) {
            return properties;
        }
        byte[] prefix = new byte[4];
        System.arraycopy(propertiesData, 0, prefix, 0, 4);
        if (KnlMessageProperties.parseInteger(prefix) != TlqMessage.PROPERTIES_PREFIX_INT) {
            return properties;
        }
        int pos = 16;
        do {
            try {
                byte[] lengthByte = new byte[4];
                System.arraycopy(propertiesData, pos, lengthByte, 0, 4);
                int length = KnlMessageProperties.parseInteger(lengthByte);
                byte[] nameByte = new byte[length];
                System.arraycopy(propertiesData, pos += 4, nameByte, 0, length);
                String name = new String(nameByte);
                pos += length;
                byte type = propertiesData[pos++];
                byte[] valueByteLength = new byte[4];
                System.arraycopy(propertiesData, pos, valueByteLength, 0, 4);
                int valueLength = KnlMessageProperties.parseInteger(valueByteLength);
                pos += 4;
                byte[] valueByte = new byte[valueLength];
                if (type != 67) {
                    System.arraycopy(propertiesData, pos, valueByte, 0, valueLength);
                    pos += valueLength;
                } else {
                    System.arraycopy(propertiesData, pos, valueByte, 0, 1);
                    ++pos;
                }
                String value = new String(valueByte);
                switch (type) {
                    case 83: {
                        String stringValue = new String(value);
                        if (stringValue.equals("true") || stringValue.equals("false")) {
                            properties.put(name, Boolean.valueOf(stringValue));
                            break;
                        }
                        properties.put(name, stringValue);
                        break;
                    }
                    case 73: {
                        properties.put(name, new Integer(value));
                        break;
                    }
                    case 67: {
                        properties.put(name, new Byte(valueByte[0]));
                        break;
                    }
                    case 68: {
                        properties.put(name, new Double(value));
                        break;
                    }
                    case 108: {
                        properties.put(name, new Long(value));
                        break;
                    }
                    case 115: {
                        properties.put(name, new Short(value));
                        break;
                    }
                    case 76: {
                        properties.put(name, new Long(value));
                        break;
                    }
                    case 70: {
                        properties.put(name, new Float(value));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (pos + 1 < len);
        return properties;
    }

    public static int getByte(Hashtable p, byte[] knlByte) {
        System.arraycopy(TlqMessage.PROPERTIES_PREFIX_BYTES, 0, knlByte, 0, 4);
        System.arraycopy(KnlMessageProperties.parseInt(knlByte.length), 0, knlByte, 4, 4);
        int pos = 16;
        Set keys = p.keySet();
        for (String key : keys) {
            byte[] keyByte = key.getBytes();
            int keyLen = keyByte.length;
            Object value = p.get(key);
            byte[] valueByte = value.toString().getBytes();
            int valueLen = valueByte.length;
            if (value instanceof String) {
                System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 83;
                System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Integer) {
                System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 73;
                System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Boolean) {
                System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 83;
                System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Byte) {
                System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 67;
                System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
                byte valueByte1 = (Byte)value;
                byte[] value1 = new byte[]{valueByte1};
                valueLen = value1.length;
                System.arraycopy(value1, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Short) {
                System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 115;
                System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Long) {
                System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 76;
                System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (value instanceof Float) {
                System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
                System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
                knlByte[pos += keyLen] = 70;
                System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
                System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
                pos += valueLen;
                continue;
            }
            if (!(value instanceof Double)) continue;
            System.arraycopy(KnlMessageProperties.parseInt(keyLen), 0, knlByte, pos, 4);
            System.arraycopy(keyByte, 0, knlByte, pos += 4, keyLen);
            knlByte[pos += keyLen] = 68;
            System.arraycopy(KnlMessageProperties.parseInt(valueLen), 0, knlByte, ++pos, 4);
            System.arraycopy(valueByte, 0, knlByte, pos += 4, valueLen);
            pos += valueLen;
        }
        knlByte[pos] = 0;
        System.arraycopy(KnlMessageProperties.parseInt(pos - 16), 0, knlByte, 8, 4);
        System.arraycopy(KnlMessageProperties.parseInt(p.size()), 0, knlByte, 12, 4);
        return pos;
    }

    public static byte[] parseInt(int i) {
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public static int parseInteger(byte[] b) {
        if (b.length != 4) {
            throw new IllegalArgumentException();
        }
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }
}

