/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi;

import com.tongtech.tmqi.BasicConnectionFactory;
import com.tongtech.tmqi.jmsclient.QueueConnectionImpl;
import com.tongtech.tmqi.jmsclient.TopicConnectionImpl;
import com.tongtech.tmqi.naming.AdministeredObjectFactory;
import com.tongtech.tmqi.naming.ReferenceGenerator;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class ConnectionFactory
extends BasicConnectionFactory
implements Referenceable {
    public ConnectionFactory() {
    }

    protected ConnectionFactory(String defaultsBase) {
        super(defaultsBase);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(this.getProperty("tmqiDefaultUsername"), this.getProperty("tmqiDefaultPassword"));
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return new QueueConnectionImpl(this.getCurrentConfiguration(), username, password, this.getConnectionType());
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(this.getProperty("tmqiDefaultUsername"), this.getProperty("tmqiDefaultPassword"));
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return new TopicConnectionImpl(this.getCurrentConfiguration(), username, password, this.getConnectionType());
    }

    @Override
    public Reference getReference() {
        return ReferenceGenerator.getReference(this, AdministeredObjectFactory.class.getName());
    }

    public void setTmqiAddressList(String tmqiAddressList) throws JMSException {
        this.setProperty("tmqiAddressList", tmqiAddressList);
    }

    public String getTmqiAddressList() throws JMSException {
        return this.getProperty("tmqiAddressList");
    }
}

