/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi;

import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.DestinationName;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public abstract class Destination
extends AdministeredObject
implements javax.jms.Destination {
    private static final String defaultsBase = "Destination";

    public Destination() {
        super(defaultsBase);
    }

    public Destination(String name) throws InvalidDestinationException {
        super(defaultsBase);
        if (name == null || "".equals(name)) {
            String errorString = AdministeredObject.cr.getKString("C4050");
            throw new InvalidDestinationException(errorString, "C4050");
        }
        if (this.isTemporary()) {
            this.configuration.put("tmqiDestinationName", name);
        } else if (DestinationName.isSyntaxValid(name)) {
            this.configuration.put("tmqiDestinationName", name);
        } else {
            String errorString = AdministeredObject.cr.getKString("C4050", name);
            throw new InvalidDestinationException(errorString, "C4050");
        }
    }

    public String getName() {
        try {
            return super.getProperty("tmqiDestinationName");
        }
        catch (JMSException e) {
            return "";
        }
    }

    public String getQueueName() throws JMSException {
        return this.getName();
    }

    public String getTopicName() throws JMSException {
        return this.getName();
    }

    @Override
    public String toString() {
        return "Destination\ngetName():\t\t" + this.getName() + super.toString();
    }

    public abstract boolean isQueue();

    public abstract boolean isTemporary();

    @Override
    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("tmqiDestinationName", "Untitled_Destination_Object");
        this.configurationTypes.put("tmqiDestinationName", "java.lang.String");
        this.configurationLabels.put("tmqiDestinationName", "L0570");
        this.configuration.put("tmqiDestinationDescription", "A Description for the Destination Object");
        this.configurationTypes.put("tmqiDestinationDescription", "java.lang.String");
        this.configurationLabels.put("tmqiDestinationDescription", "L0571");
        if (!this.isQueue()) {
            this.configuration.put("tmqiTopicPubQueueName", "TLQ.SYS.BROKER.SYN");
            this.configurationTypes.put("tmqiTopicPubQueueName", "java.lang.String");
            this.configurationLabels.put("tmqiTopicPubQueueName", "L0572");
            this.configuration.put("tmqiTopicSubQueueName", "TLQ.SYS.BROKER.SUB");
            this.configurationTypes.put("tmqiTopicSubQueueName", "java.lang.String");
            this.configurationLabels.put("tmqiTopicSubQueueName", "L0573");
        } else {
            this.configuration.put("LocalQueueName", "");
            this.configurationTypes.put("LocalQueueName", "java.lang.String");
        }
        this.configuration.put("MsgNum", "");
        this.configurationTypes.put("MsgNum", "java.lang.Integer");
        this.configuration.put("MsgSize", "");
        this.configurationTypes.put("MsgSize", "java.lang.Integer");
        this.configuration.put("QueSpaceSize", "");
        this.configurationTypes.put("QueSpaceSize", "java.lang.Integer");
        this.configuration.put("LocalQueDataBuff", "");
        this.configurationTypes.put("LocalQueDataBuff", "java.lang.Integer");
        this.configuration.put("MsgArrangeMode", "");
        this.configurationTypes.put("MsgArrangeMode", "java.lang.Integer");
        this.configuration.put("UsageType", "");
        this.configurationTypes.put("UsageType", "java.lang.Integer");
        this.configuration.put("DefPriority", "");
        this.configurationTypes.put("DefPriority", "java.lang.Integer");
        this.configuration.put("DefPersistence", "");
        this.configurationTypes.put("DefPersistence", "java.lang.Integer");
        this.configuration.put("TrigType", "");
        this.configurationTypes.put("TrigType", "java.lang.String");
        this.configuration.put("TrigProgId", "");
        this.configurationTypes.put("TrigProgId", "java.lang.Integer");
        this.configuration.put("TrigAmount", "");
        this.configurationTypes.put("TrigAmount", "java.lang.Integer");
        this.configuration.put("TrigPara", "");
        this.configurationTypes.put("TrigPara", "java.lang.String");
        this.configuration.put("QueueType", "");
        this.configurationTypes.put("QueueType", "java.lang.String");
    }

    public Boolean validate_iDestinationName(String name) {
        if (this.isTemporary()) {
            if (name != null && name.startsWith("t_d__")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return new Boolean(DestinationName.isSyntaxValid(name));
    }

    @Override
    public void overrideProperties() {
    }
}

