/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi;

import com.tongtech.tmqi.BasicQueue;
import com.tongtech.tmqi.DestinationName;
import com.tongtech.tmqi.naming.AdministeredObjectFactory;
import com.tongtech.tmqi.naming.ReferenceGenerator;
import javax.jms.JMSException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class Queue
extends BasicQueue
implements Referenceable {
    public Queue() {
    }

    public Queue(String name) throws JMSException {
        super(name);
    }

    @Override
    public Reference getReference() {
        return ReferenceGenerator.getReference(this, AdministeredObjectFactory.class.getName());
    }

    public void setName(String name) {
        if (!DestinationName.isSyntaxValid(name)) {
            throw new IllegalArgumentException("MQ:Queue:Invalid Queue Name - " + name);
        }
        this.configuration.put("tmqiDestinationName", name);
    }

    public void setDescription(String description) {
        this.configuration.put("tmqiDestinationDescription", description);
    }

    public String getDescription() {
        try {
            return this.getProperty("tmqiDestinationDescription");
        }
        catch (JMSException jmse) {
            return "";
        }
    }
}

