/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.apps.console;

import com.tongtech.tmqi.admin.apps.console.BlankInspector;
import com.tongtech.tmqi.admin.apps.console.ConsoleObj;
import com.tongtech.tmqi.admin.apps.console.InspectorPanel;
import com.tongtech.tmqi.admin.apps.console.SplashScreenInspector;
import com.tongtech.tmqi.admin.apps.console.event.AdminEvent;
import com.tongtech.tmqi.admin.apps.console.event.AdminEventListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;

public class AInspector
extends JScrollPane {
    private static String SPLASH_SCREEN = "SplashScreen";
    private static String BLANK = "Blank";
    private EventListenerList aListeners = new EventListenerList();
    private InspectorPanel currentCard = null;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private Hashtable cardList;

    public AInspector() {
        this.initGui();
    }

    public void addAdminEventListener(AdminEventListener l) {
        this.aListeners.add(AdminEventListener.class, l);
    }

    public void removeAdminEventListener(AdminEventListener l) {
        this.aListeners.remove(AdminEventListener.class, l);
    }

    public void inspect(ConsoleObj conObj) {
        if (conObj == null) {
            this.cardLayout.show(this.cardPanel, BLANK);
            return;
        }
        InspectorPanel ip = this.getInspectorPanel(conObj);
        if (ip == null && (ip = this.addInspectorPanel(conObj)) == null) {
            System.err.println("Cannot inspect object: " + conObj + "\nFailed to create inspector panel");
            return;
        }
        this.currentCard = ip;
        this.currentCard.inspectConsoleObj(conObj, this.aListeners);
        this.showInspectorPanel(conObj);
    }

    public void refresh() {
        if (this.currentCard != null) {
            this.currentCard.refresh();
        }
    }

    public void selectedObjectUpdated() {
        if (this.currentCard != null) {
            this.currentCard.selectedObjectUpdated();
        }
    }

    public void clearSelection() {
        if (this.currentCard != null) {
            this.currentCard.clearSelection();
        }
    }

    private void showInspectorPanel(ConsoleObj conObj) {
        this.cardLayout.show(this.cardPanel, conObj.getInspectorPanelId());
    }

    private InspectorPanel getInspectorPanel(ConsoleObj conObj) {
        String panelId = conObj.getInspectorPanelId();
        Object obj = this.cardList.get(panelId);
        if (obj != null && obj instanceof InspectorPanel) {
            return (InspectorPanel)obj;
        }
        return null;
    }

    private InspectorPanel addInspectorPanel(ConsoleObj conObj) {
        String panelId = conObj.getInspectorPanelId();
        String panelClassName = conObj.getInspectorPanelClassName();
        InspectorPanel ip = null;
        try {
            ip = (InspectorPanel)Class.forName(panelClassName).newInstance();
        }
        catch (ClassNotFoundException cnfEx) {
            System.err.println("ConsoleObj does not name a valid inspector panel classname: " + cnfEx);
        }
        catch (InstantiationException ie) {
            System.err.println("Failed to intantiate inspector panel : " + ie);
        }
        catch (IllegalAccessException iae) {
            System.err.println("Illegal Access Exception while trying to intantiate inspector panel : " + iae);
        }
        if (ip == null) {
            return null;
        }
        this.cardPanel.add((Component)ip, panelId);
        this.cardList.put(panelId, ip);
        return ip;
    }

    private void fireAdminEventDispatched(AdminEvent ae) {
        Object[] l = this.aListeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != AdminEventListener.class) continue;
            ((AdminEventListener)l[i + 1]).adminEventDispatched(ae);
        }
    }

    private void initGui() {
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.initLayers(this.cardPanel);
        this.setViewportView(this.cardPanel);
        Dimension minimumSize = new Dimension(100, 50);
        this.setMinimumSize(minimumSize);
    }

    private void initLayers(JPanel parent) {
        JPanel p = new JPanel();
        this.cardList = new Hashtable();
        p = new SplashScreenInspector();
        parent.add((Component)p, SPLASH_SCREEN);
        this.cardList.put(SPLASH_SCREEN, p);
        p = new BlankInspector();
        parent.add((Component)p, BLANK);
        this.cardList.put(BLANK, p);
        this.cardLayout.show(parent, SPLASH_SCREEN);
    }
}

