/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.apps.objmgr;

import com.tongtech.tmqi.Version;
import com.tongtech.tmqi.admin.apps.objmgr.CmdRunner;
import com.tongtech.tmqi.admin.apps.objmgr.HelpPrinter;
import com.tongtech.tmqi.admin.apps.objmgr.ObjMgrException;
import com.tongtech.tmqi.admin.apps.objmgr.ObjMgrOptionParser;
import com.tongtech.tmqi.admin.apps.objmgr.ObjMgrOptions;
import com.tongtech.tmqi.admin.apps.objmgr.ObjMgrProperties;
import com.tongtech.tmqi.admin.apps.objmgr.Utils;
import com.tongtech.tmqi.admin.resources.AdminResources;
import com.tongtech.tmqi.admin.util.Globals;
import com.tongtech.tmqi.util.options.BadNameValueArgException;
import com.tongtech.tmqi.util.options.InvalidBasePropNameException;
import com.tongtech.tmqi.util.options.InvalidHardCodedValueException;
import com.tongtech.tmqi.util.options.MissingArgException;
import com.tongtech.tmqi.util.options.OptionException;
import com.tongtech.tmqi.util.options.UnrecognizedOptionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;

public class ObjMgr
implements ObjMgrOptions {
    public static final String FIRST_VERSION = "2.0";
    public static final String VERSION = "2.0";
    private static final String PROP_NAME_VERSION = "version";
    private static AdminResources ar = Globals.getAdminResources();

    public static void main(String[] args) {
        HelpPrinter hp;
        int exitcode = 0;
        if (ObjMgr.silentModeOptionSpecified(args)) {
            Globals.setSilentMode(true);
        }
        if (ObjMgr.shortHelpOptionSpecified(args)) {
            hp = new HelpPrinter();
            hp.printShortHelp(0);
        } else if (ObjMgr.longHelpOptionSpecified(args)) {
            hp = new HelpPrinter();
            hp.printLongHelp();
        }
        if (ObjMgr.versionOptionSpecified(args)) {
            ObjMgr.printBanner();
            ObjMgr.printVersion();
            System.exit(0);
        }
        ObjMgrProperties objMgrProps = null;
        try {
            objMgrProps = ObjMgrOptionParser.parseArgs(args);
        }
        catch (OptionException e) {
            ObjMgr.handleArgsParsingExceptions(e);
        }
        String propFileName = objMgrProps.getInputFileName();
        if (propFileName != null && !propFileName.equals("")) {
            ObjMgrProperties tmpProps = new ObjMgrProperties();
            try {
                FileInputStream fis = new FileInputStream(propFileName);
                tmpProps.load(fis);
            }
            catch (IOException ioe) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3080"), false);
                System.err.println(ioe);
                System.exit(1);
            }
            String v = ObjMgr.getFileVersion(tmpProps);
            if (v != null) {
                try {
                    ObjMgr.checkVersion(propFileName, v, "2.0", "2.0");
                }
                catch (ObjMgrException ome) {
                    Globals.stdErrPrintln(ar.getString("A1001"), ome.getMessage(), false);
                    System.exit(1);
                }
            }
            Enumeration<?> e = objMgrProps.propertyNames();
            while (e.hasMoreElements()) {
                String propVal;
                String propName = (String)e.nextElement();
                if (propName == null || (propVal = objMgrProps.getProperty(propName)) == null || propName.equals("inputFile")) continue;
                tmpProps.put(propName, propVal);
            }
            objMgrProps = tmpProps;
        }
        objMgrProps = ObjMgr.trimPropValues(objMgrProps);
        try {
            ObjMgr.checkOptions(objMgrProps);
        }
        catch (ObjMgrException ome) {
            ObjMgr.handleCheckOptionsExceptions(ome);
        }
        if (objMgrProps.previewModeSet()) {
            System.exit(0);
        }
        CmdRunner cmdRunner = new CmdRunner(objMgrProps);
        exitcode = cmdRunner.runCommands();
        System.exit(exitcode);
    }

    private static void checkOptions(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String cmd = objMgrProps.getCommand();
        if (cmd == null) {
            ObjMgrException objMgrEx = new ObjMgrException(0);
            objMgrEx.setProperties(objMgrProps);
            throw objMgrEx;
        }
        if (ObjMgr.readOnlyOptionSpecified(objMgrProps)) {
            ObjMgr.checkReadOnly(objMgrProps);
        }
        if (cmd.equals("add")) {
            ObjMgr.checkAdd(objMgrProps);
        } else if (cmd.equals("delete")) {
            ObjMgr.checkDelete(objMgrProps);
        } else if (cmd.equals("query")) {
            ObjMgr.checkQuery(objMgrProps);
        } else if (cmd.equals("list")) {
            ObjMgr.checkList(objMgrProps);
        } else if (cmd.equals("update")) {
            ObjMgr.checkUpdate(objMgrProps);
        } else {
            ObjMgrException objMgrEx = new ObjMgrException(1);
            objMgrEx.setProperties(objMgrProps);
            throw objMgrEx;
        }
    }

    private static void checkAdd(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String objType = objMgrProps.getObjType();
        if (objType == null) {
            ObjMgrException objMgrEx = new ObjMgrException(2);
            objMgrEx.setProperties(objMgrProps);
            throw objMgrEx;
        }
        if (Utils.isDestObjType(objType)) {
            ObjMgr.checkAddDestination(objMgrProps);
        } else if (Utils.isFactoryObjType(objType)) {
            ObjMgr.checkAddFactory(objMgrProps);
        } else {
            ObjMgrException objMgrEx = new ObjMgrException(3);
            objMgrEx.setProperties(objMgrProps);
            throw objMgrEx;
        }
    }

    private static void checkAddDestination(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String lookupName = objMgrProps.getLookupName();
        if (lookupName == null) {
            ObjMgrException e = new ObjMgrException(4);
            e.setProperties(objMgrProps);
            throw e;
        }
    }

    private static void checkAddFactory(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String lookupName = objMgrProps.getLookupName();
        if (lookupName == null) {
            ObjMgrException e = new ObjMgrException(4);
            e.setProperties(objMgrProps);
            throw e;
        }
    }

    private static void checkDelete(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String lookupName = objMgrProps.getLookupName();
        if (lookupName == null) {
            ObjMgrException e = new ObjMgrException(4);
            e.setProperties(objMgrProps);
            throw e;
        }
    }

    private static void checkQuery(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String lookupName = objMgrProps.getLookupName();
        if (lookupName == null) {
            ObjMgrException e = new ObjMgrException(4);
            e.setProperties(objMgrProps);
            throw e;
        }
    }

    private static void checkList(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String type = objMgrProps.getObjType();
        if (type != null && !Utils.isValidObjType(type)) {
            ObjMgrException e = new ObjMgrException(3);
            e.setProperties(objMgrProps);
            throw e;
        }
    }

    private static void checkUpdate(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String type = objMgrProps.getObjType();
        if (type != null && !Utils.isValidObjType(type)) {
            ObjMgrException e = new ObjMgrException(3);
            e.setProperties(objMgrProps);
            throw e;
        }
    }

    private static void checkReadOnly(ObjMgrProperties objMgrProps) throws ObjMgrException {
        String s = objMgrProps.getProperty("obj.readOnly");
        if (s.equalsIgnoreCase("t") || s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            s = Boolean.TRUE.toString();
            objMgrProps.put("obj.readOnly", Boolean.TRUE.toString());
        } else if (s.equalsIgnoreCase("f") || s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            s = Boolean.FALSE.toString();
            objMgrProps.put("obj.readOnly", Boolean.FALSE.toString());
        }
        if (!s.equalsIgnoreCase(Boolean.TRUE.toString()) && !s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            ObjMgrException e = new ObjMgrException(6);
            e.setProperties(objMgrProps);
            throw e;
        }
    }

    private static void printBanner() {
    }

    private static boolean shortHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-h") && !args[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-H") && !args[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean readOnlyOptionSpecified(ObjMgrProperties objMgrProps) {
        String s = objMgrProps.getProperty("obj.readOnly");
        return s != null;
    }

    private static boolean versionOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-v") && !args[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static void printVersion() {
        Version version = new Version();
        Globals.stdOutPrintln(version.getVersion());
        Globals.stdOutPrintln(ar.getString("A1065") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
        Globals.stdOutPrintln(ar.getString("A1066") + System.getProperty("java.class.path"));
    }

    private static void handleArgsParsingExceptions(OptionException e) {
        String option = e.getOption();
        if (e instanceof UnrecognizedOptionException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3001", option, "objmgr"), true);
        } else if (e instanceof InvalidBasePropNameException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3002", option), true);
        } else if (e instanceof InvalidHardCodedValueException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3003", option), true);
        } else if (e instanceof MissingArgException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3004", option, "objmgr"), true);
        } else if (e instanceof BadNameValueArgException) {
            BadNameValueArgException bnvae = (BadNameValueArgException)e;
            String badArg = bnvae.getArg();
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3005", badArg, option), true);
        } else {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3000"), true);
        }
    }

    private static void handleCheckOptionsExceptions(ObjMgrException e) {
        ObjMgrProperties objMgrProps = e.getProperties();
        int type = e.getType();
        switch (type) {
            case 0: {
                ObjMgr.printBanner();
                HelpPrinter hp = new HelpPrinter();
                hp.printShortHelp(1);
                break;
            }
            case 1: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3021", objMgrProps.getCommand()), true);
                break;
            }
            case 2: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3023", "-t"), true);
                break;
            }
            case 3: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3024", objMgrProps.getObjType()), true);
                break;
            }
            case 6: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3027", objMgrProps.getProperty("obj.readOnly")), true);
                break;
            }
            case 4: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3025", "-l"), true);
                break;
            }
            case 5: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3026", "-o"), true);
                break;
            }
            default: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3020"), true);
            }
        }
    }

    private static ObjMgrProperties trimPropValues(ObjMgrProperties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String propValue = props.getProperty(propName);
            if (propValue == null || (propValue = propValue.trim()) == null) continue;
            props.put(propName, propValue);
        }
        return props;
    }

    private static String getFileVersion(ObjMgrProperties props) {
        String val = props.getProperty(PROP_NAME_VERSION);
        return val;
    }

    private static void checkVersion(String propFileName, String fileVersionStr, String expectedVersionStr, String firstVersionStr) throws ObjMgrException {
        double fileVersion;
        double firstVersion;
        double expectedVersion;
        try {
            expectedVersion = Double.parseDouble(expectedVersionStr);
        }
        catch (NumberFormatException nfe) {
            double expectedVersion2 = 0.0;
            ObjMgrException ome = new ObjMgrException(ar.getKString("A3151", expectedVersionStr));
            throw ome;
        }
        try {
            firstVersion = Double.parseDouble(firstVersionStr);
        }
        catch (NumberFormatException nfe) {
            double firstVersion2 = 0.0;
            ObjMgrException ome = new ObjMgrException(ar.getKString("A3151", firstVersionStr));
            throw ome;
        }
        try {
            fileVersion = Double.parseDouble(fileVersionStr);
        }
        catch (NumberFormatException nfe) {
            Object[] args = new Object[4];
            double fileVersion2 = 0.0;
            args[0] = propFileName;
            args[1] = PROP_NAME_VERSION;
            args[2] = fileVersionStr;
            args[3] = expectedVersionStr;
            String s = ar.getKString("A3152", args);
            ObjMgrException ome = new ObjMgrException(s);
            throw ome;
        }
        if (fileVersion < firstVersion) {
            Object[] args = new Object[]{propFileName, PROP_NAME_VERSION, fileVersionStr, expectedVersionStr};
            String s = ar.getKString("A3153", args);
            ObjMgrException ome = new ObjMgrException(s);
            throw ome;
        }
        if (fileVersion > expectedVersion) {
            Object[] args = new Object[]{propFileName, PROP_NAME_VERSION, fileVersionStr, expectedVersionStr};
            String s = ar.getKString("A3153", args);
            ObjMgrException ome = new ObjMgrException(s);
            throw ome;
        }
    }
}

