/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.objstore;

import com.tongtech.tmqi.admin.objstore.NameAlreadyExistsException;
import com.tongtech.tmqi.admin.objstore.NameNotFoundException;
import com.tongtech.tmqi.admin.objstore.ObjStore;
import com.tongtech.tmqi.admin.objstore.ObjStoreAttrs;
import com.tongtech.tmqi.admin.objstore.ObjStoreException;
import com.tongtech.tmqi.admin.objstore.ObjStoreTypeNotSupportedException;
import com.tongtech.tmqi.admin.objstore.jndi.JNDIStore;
import java.util.Vector;

public class ObjStoreManager {
    private boolean DEBUG = false;
    private static ObjStoreManager mgr = null;
    public static final int JNDI = 0;
    protected Vector objStores = new Vector();

    protected ObjStoreManager() {
    }

    public static synchronized ObjStoreManager getObjStoreManager() {
        if (mgr == null) {
            mgr = new ObjStoreManager();
        }
        return mgr;
    }

    public ObjStore createStore(ObjStoreAttrs attrs) throws ObjStoreException {
        String id = attrs.getID();
        if (this.DEBUG) {
            System.out.println("DEBUG: ObjStoreManager.createStore() getID() ---> " + id);
        }
        if (!this.idExists(id)) {
            ObjStore os = ObjStoreFactory.createStore(attrs);
            this.objStores.addElement(os);
            return os;
        }
        throw new NameAlreadyExistsException();
    }

    public void destroyStore(String id) throws ObjStoreException {
        if (!this.idExists(id)) {
            throw new NameNotFoundException();
        }
        this.removeFromObjStores(id);
    }

    public ObjStore getStore(String id) {
        ObjStore os = null;
        String id2 = null;
        for (int i = 0; i < this.objStores.size(); ++i) {
            os = (ObjStore)this.objStores.get(i);
            id2 = os.getID();
            if (!id.equals(id2)) continue;
            return os;
        }
        return null;
    }

    public Vector getOpenStores() {
        return this.getStores(true);
    }

    public Vector getClosedStores() {
        return this.getStores(false);
    }

    private Vector getStores(boolean open) {
        Vector<ObjStore> stores = new Vector<ObjStore>();
        ObjStore os = null;
        if (open) {
            for (int i = 0; i < this.objStores.size(); ++i) {
                os = (ObjStore)this.objStores.get(i);
                if (!os.isOpen()) continue;
                stores.addElement(os);
            }
        } else {
            for (int i = 0; i < this.objStores.size(); ++i) {
                os = (ObjStore)this.objStores.get(i);
                if (os.isOpen()) continue;
                stores.addElement(os);
            }
        }
        return stores;
    }

    public Vector getAllStores() {
        return this.objStores;
    }

    private boolean idExists(String id) {
        for (int i = 0; i < this.objStores.size(); ++i) {
            String id2 = ((ObjStore)this.objStores.get(i)).getID();
            if (!id.equals(id2)) continue;
            return true;
        }
        return false;
    }

    private void removeFromObjStores(String id) {
        for (int i = 0; i < this.objStores.size(); ++i) {
            String id2 = ((ObjStore)this.objStores.get(i)).getID();
            if (!id.equals(id2)) continue;
            this.objStores.remove(i);
            return;
        }
    }

    private static class ObjStoreFactory {
        private ObjStoreFactory() {
        }

        private static ObjStore createStore(ObjStoreAttrs attrs) throws ObjStoreException {
            int type = attrs.getType();
            if (0 == type) {
                return new JNDIStore(attrs);
            }
            throw new ObjStoreTypeNotSupportedException();
        }
    }
}

